/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.operation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEndsOrdering;
import org.eclipse.sirius.diagram.sequence.tool.internal.Messages;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;

public final class FixGraphicalOrderingOperation
extends AbstractModelChangeOperation<Void> {
    private final SequenceDDiagram diagram;

    public FixGraphicalOrderingOperation(SequenceDDiagram diagram) {
        super(Messages.FixGraphicalOrderingOperation_operationName);
        this.diagram = diagram;
    }

    public Void execute() {
        EventEndsOrdering graphical = this.diagram.getGraphicalOrdering();
        List<EventEnd> invalids = this.findInvalidEnds(graphical);
        this.removeEnds(graphical, invalids);
        return null;
    }

    private List<EventEnd> findInvalidEnds(EventEndsOrdering graphical) {
        ArrayList<EventEnd> invalids = new ArrayList<EventEnd>();
        for (EventEnd end : graphical.getEventEnds()) {
            if (this.isValidEnd(end)) continue;
            invalids.add(end);
        }
        return invalids;
    }

    private boolean isValidEnd(EventEnd end) {
        return end.getSemanticEnd() != null && end.getSemanticEnd().eContainer() != null;
    }

    private void removeEnds(EventEndsOrdering graphical, List<EventEnd> invalids) {
        for (EventEnd invalidEnd : invalids) {
            graphical.getEventEnds().remove((Object)invalidEnd);
        }
    }
}

