/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.Smoothness;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;

public class GmfLayoutCommand
extends AbstractTransactionalCommand {
    public static final String JUNCTION_POINTS_STYLE_NAME = "junctionPoints";
    private IAdaptable diagramViewAdapter;
    private List<ShapeLayoutData> shapeLayouts = new LinkedList<ShapeLayoutData>();
    private List<EdgeLayoutData> edgeLayouts = new LinkedList<EdgeLayoutData>();

    public GmfLayoutCommand(TransactionalEditingDomain domain, String label, IAdaptable adapter) {
        super(domain, label, null);
        this.diagramViewAdapter = adapter;
    }

    public void addShapeLayout(View view, Point location, Dimension size) {
        assert (view != null);
        ShapeLayoutData layout = new ShapeLayoutData();
        layout.view = view;
        layout.location = location;
        layout.size = size;
        this.shapeLayouts.add(layout);
    }

    public void addEdgeLayout(Edge edge, PointList bends, String sourceTerminal, String targetTerminal, String junctionPoints, Routing routingToApply) {
        assert (edge != null);
        EdgeLayoutData layout = new EdgeLayoutData();
        layout.edge = edge;
        layout.bends = bends;
        layout.junctionPoints = junctionPoints;
        layout.sourceTerminal = sourceTerminal;
        layout.targetTerminal = targetTerminal;
        layout.routingToApply = routingToApply;
        this.edgeLayouts.add(layout);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        monitor.beginTask(this.getLabel(), 1);
        for (ShapeLayoutData shapeLayout : this.shapeLayouts) {
            if (shapeLayout.location != null) {
                ViewUtil.setStructuralFeatureValue((View)shapeLayout.view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)Math.toIntExact(Math.round(shapeLayout.location.preciseX())));
                ViewUtil.setStructuralFeatureValue((View)shapeLayout.view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)Math.toIntExact(Math.round(shapeLayout.location.preciseY())));
            }
            if (shapeLayout.size == null) continue;
            ViewUtil.setStructuralFeatureValue((View)shapeLayout.view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)Math.toIntExact(Math.round(shapeLayout.size.preciseWidth())));
            ViewUtil.setStructuralFeatureValue((View)shapeLayout.view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height(), (Object)Math.toIntExact(Math.round(shapeLayout.size.preciseHeight())));
        }
        this.shapeLayouts.clear();
        for (EdgeLayoutData edgeLayout : this.edgeLayouts) {
            RoutingStyle routingStyle;
            IdentityAnchor anchor;
            if (edgeLayout.bends != null) {
                ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>(edgeLayout.bends.size());
                Point sourcePoint = edgeLayout.bends.getFirstPoint();
                Point targetPoint = edgeLayout.bends.getLastPoint();
                int i = 0;
                while (i < edgeLayout.bends.size()) {
                    Point bend = edgeLayout.bends.getPoint(i);
                    newBendpoints.add(new RelativeBendpoint(bend.x - sourcePoint.x, bend.y - sourcePoint.y, bend.x - targetPoint.x, bend.y - targetPoint.y));
                    ++i;
                }
                RelativeBendpoints points = (RelativeBendpoints)edgeLayout.edge.getBendpoints();
                points.setPoints(newBendpoints);
            }
            if (edgeLayout.sourceTerminal != null) {
                anchor = (IdentityAnchor)edgeLayout.edge.getSourceAnchor();
                if (anchor == null) {
                    anchor = NotationFactory.eINSTANCE.createIdentityAnchor();
                    edgeLayout.edge.setSourceAnchor((Anchor)anchor);
                }
                anchor.setId(edgeLayout.sourceTerminal);
            }
            if (edgeLayout.targetTerminal != null) {
                anchor = (IdentityAnchor)edgeLayout.edge.getTargetAnchor();
                if (anchor == null) {
                    anchor = NotationFactory.eINSTANCE.createIdentityAnchor();
                    edgeLayout.edge.setTargetAnchor((Anchor)anchor);
                }
                anchor.setId(edgeLayout.targetTerminal);
            }
            StringValueStyle style = (StringValueStyle)edgeLayout.edge.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), JUNCTION_POINTS_STYLE_NAME);
            if (edgeLayout.junctionPoints == null) {
                if (style != null) {
                    edgeLayout.edge.getStyles().remove((Object)style);
                }
            } else {
                if (style == null) {
                    style = NotationFactory.eINSTANCE.createStringValueStyle();
                    style.setName(JUNCTION_POINTS_STYLE_NAME);
                    edgeLayout.edge.getStyles().add((Object)style);
                }
                style.setStringValue(edgeLayout.junctionPoints);
            }
            if ((routingStyle = (RoutingStyle)edgeLayout.edge.getStyle(NotationPackage.eINSTANCE.getRoutingStyle())) == null || edgeLayout.routingToApply == null) continue;
            routingStyle.setRouting(edgeLayout.routingToApply);
            routingStyle.setSmoothness(Smoothness.NONE_LITERAL);
        }
        this.edgeLayouts.clear();
        monitor.done();
        return CommandResult.newOKCommandResult();
    }

    public List<EdgeLayoutData> getEdgeLayouts() {
        return Collections.unmodifiableList(this.edgeLayouts);
    }

    public List<ShapeLayoutData> getShapeLayouts() {
        return Collections.unmodifiableList(this.shapeLayouts);
    }

    public List<?> getAffectedFiles() {
        View view;
        if (this.diagramViewAdapter != null && (view = (View)this.diagramViewAdapter.getAdapter(View.class)) != null) {
            return GmfLayoutCommand.getWorkspaceFiles((EObject)view);
        }
        return super.getAffectedFiles();
    }

    public static final class EdgeLayoutData {
        public Edge edge;
        public PointList bends;
        public String junctionPoints;
        public String sourceTerminal;
        public String targetTerminal;
        public Routing routingToApply;
    }

    public static final class ShapeLayoutData {
        public View view;
        public Point location;
        public Dimension size;
    }
}

