/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.contributions;

import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionImpl;
import org.eclipse.gmf.runtime.diagram.ui.actions.CheckedPropertyAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.contributions.ModesMenuManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.EditorActionBarContributor;

public class StandardModeAction
extends CheckedPropertyAction {
    private static final ImageDescriptor DEFAULT_MODE_IMAGE_DESCRIPTOR = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/defaultMode.png");
    private DDiagram ddiagram;
    private DDiagramEditor editor;
    private ModesMenuManager modesMenuManager;

    public StandardModeAction(IWorkbenchPage page, DDiagramEditor editor, DDiagram editorDiagram, ModesMenuManager modesMenuManager) {
        super(page, "defaultMode", Messages.ChangeEditModeAction_ChangePropertyValueRequest_label, (Object)"defaultMode");
        this.setWorkbenchPart(page.getActivePart());
        this.setId("defaultMode");
        this.setToolTipText(Messages.EditModeAction_Label);
        this.ddiagram = editorDiagram;
        if (this.ddiagram != null) {
            this.setImageDescriptor(DEFAULT_MODE_IMAGE_DESCRIPTOR);
            this.setTextAndStatusAccordingToDefaultMode();
        }
        this.editor = editor;
        this.modesMenuManager = modesMenuManager;
    }

    protected synchronized boolean calculateChecked() {
        return this.ddiagram != null && !this.ddiagram.isIsInShowingMode() && !this.ddiagram.isIsInLayoutingMode();
    }

    protected synchronized void doRun(IProgressMonitor progressMonitor) {
        if (this.editor == null || this.ddiagram == null) {
            return;
        }
        TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)this.editor.getEditingDomain();
        if (editingDomain != null) {
            TransactionImpl t = new TransactionImpl(editingDomain, false, Collections.EMPTY_MAP);
            try {
                t.start();
                this.ddiagram.setIsInLayoutingMode(false);
                this.ddiagram.setIsInShowingMode(false);
                t.commit();
            }
            catch (InterruptedException | RollbackException e) {
                DiagramPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.diagram", Messages.ChangeEditModeAction_ChangeFailure, e));
            }
        }
        this.modesMenuManager.refresh();
        this.setTextAndStatusAccordingToDefaultMode();
    }

    protected synchronized boolean calculateEnabled() {
        return this.ddiagram != null && this.editor != null;
    }

    private void setTextAndStatusAccordingToDefaultMode() {
        this.setText(Messages.DefaultModeAction_Label);
        IEditorPart activeEditor = EclipseUIUtil.getActiveEditor();
        if (activeEditor != null) {
            IEditorSite site = (IEditorSite)activeEditor.getSite();
            EditorActionBarContributor actionBarContributor = null;
            IStatusLineManager statusLineManager = null;
            if (site != null && site.getActionBarContributor() instanceof EditorActionBarContributor) {
                actionBarContributor = (EditorActionBarContributor)site.getActionBarContributor();
            }
            if (actionBarContributor != null && actionBarContributor.getActionBars() != null) {
                statusLineManager = actionBarContributor.getActionBars().getStatusLineManager();
            }
            if (statusLineManager != null) {
                String statusMessage = Messages.DefaultModeAction_statusOn;
                statusLineManager.setMessage(DiagramUIPlugin.getPlugin().getImage(DEFAULT_MODE_IMAGE_DESCRIPTOR), statusMessage);
            }
        }
    }

    public int getStyle() {
        return 2;
    }

    protected boolean isSelectionListener() {
        return false;
    }

    public synchronized void dispose() {
        this.ddiagram = null;
        this.modesMenuManager = null;
        this.editor = null;
        super.dispose();
    }
}

