/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.derived;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.derived.IDerivedResourceHandler;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.environment.SdkFuture;
import org.eclipse.scout.sdk.s2e.derived.DefaultResourceChangeEventFilter;
import org.eclipse.scout.sdk.s2e.derived.IDerivedResourceHandlerFactory;
import org.eclipse.scout.sdk.s2e.derived.IDerivedResourceManager;
import org.eclipse.scout.sdk.s2e.environment.AbstractJob;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.environment.WorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class DerivedResourceManager
implements IDerivedResourceManager {
    public static final String TYPE_CHANGED_TRIGGER_JOB_FAMILY = "AUTO_UPDATE_JOB_FAMILY";
    public static final String JAVA_DELTA_CHECK_JOB_FAMILY = "JAVA_DELTA_CHECK_JOB_FAMILY";
    private boolean m_enabled = false;
    private final List<IDerivedResourceHandlerFactory> m_updateHandlerFactories = new ArrayList<IDerivedResourceHandlerFactory>();
    private IResourceChangeListener m_resourceChangeListener;
    private Predicate<IResourceChangeEvent> m_resourceChangeEventFilter;
    private final BlockingQueue<IResourceChangeEvent> m_javaChangeEventsToCheck;
    private final P_ResourceChangeEventCheckJob m_javaDeltaCheckJob;
    private final BlockingQueue<IDerivedResourceHandler> m_triggerHandlers;
    private final P_RunQueuedTriggerHandlersJob m_runQueuedTriggerHandlersJob;

    public DerivedResourceManager() {
        DefaultResourceChangeEventFilter filter = new DefaultResourceChangeEventFilter();
        filter.setIgnoreScoutSdkEvents(false);
        this.m_resourceChangeEventFilter = filter;
        this.m_javaChangeEventsToCheck = new ArrayBlockingQueue<IResourceChangeEvent>(500, true);
        this.m_triggerHandlers = new ArrayBlockingQueue<IDerivedResourceHandler>(200, true);
        this.m_runQueuedTriggerHandlersJob = new P_RunQueuedTriggerHandlersJob(this.m_triggerHandlers);
        this.m_javaDeltaCheckJob = new P_ResourceChangeEventCheckJob(this, this.m_javaChangeEventsToCheck);
    }

    public void dispose() {
        this.setEnabled(false);
        AbstractJob.waitForJobFamily(TYPE_CHANGED_TRIGGER_JOB_FAMILY);
    }

    @Override
    public void addDerivedResourceHandlerFactory(IDerivedResourceHandlerFactory handler) {
        this.m_updateHandlerFactories.add(handler);
    }

    @Override
    public void removeDerivedResourceHandlerFactory(IDerivedResourceHandlerFactory handler) {
        this.m_updateHandlerFactories.remove(handler);
    }

    @Override
    public void trigger(final Set<IResource> resources) {
        AbstractJob triggerJob = new AbstractJob(this, "Searching base resources for derived resources update..."){
            final /* synthetic */ DerivedResourceManager this$0;
            {
                this.this$0 = this$0;
                super(name);
            }

            @Override
            protected void execute(IProgressMonitor monitor) {
                this.this$0.triggerSync(resources);
            }
        };
        triggerJob.setPriority(50);
        triggerJob.schedule();
    }

    @Override
    public Predicate<IResourceChangeEvent> getResourceChangeEventFilter() {
        return this.m_resourceChangeEventFilter;
    }

    @Override
    public void setResourceChangeEventFilter(Predicate<IResourceChangeEvent> resourceChangeEventFilter) {
        this.m_resourceChangeEventFilter = resourceChangeEventFilter;
    }

    protected void triggerSync(Collection<IResource> resources) {
        Set<IResource> cleanResources = DerivedResourceManager.cleanCopy(resources);
        if (this.enqueueFiles(cleanResources)) {
            this.m_runQueuedTriggerHandlersJob.abort();
            this.m_runQueuedTriggerHandlersJob.schedule(1000L);
        }
    }

    protected boolean enqueueFiles(Set<IResource> resources) {
        if (resources.isEmpty()) {
            return false;
        }
        boolean added = false;
        try {
            IJavaSearchScope searchScope = JdtUtils.createJavaSearchScope(resources);
            for (IDerivedResourceHandler handler : this.createOperations(resources, searchScope)) {
                if (this.m_triggerHandlers.contains(handler)) continue;
                if (DerivedResourceManager.addElementToQueueSecure(this.m_triggerHandlers, handler, handler.toString(), -1L, null)) {
                    added = true;
                    continue;
                }
                SdkLog.warning((CharSequence)"Unable to queue more derived resource update events. Queue is already full. Skipping event: {}", (Object[])new Object[]{handler.toString()});
            }
        }
        catch (RuntimeException e) {
            SdkLog.warning((CharSequence)"Unable to create java search scope", (Object[])new Object[]{e});
        }
        return added;
    }

    protected static Set<IResource> cleanCopy(Collection<IResource> resources) {
        if (resources == null) {
            return Collections.emptySet();
        }
        return resources.stream().filter(Objects::nonNull).filter(IResource::isAccessible).filter(r -> !DerivedResourceManager.existsParentIn(resources, r)).collect(Collectors.toCollection(() -> new LinkedHashSet(resources.size())));
    }

    protected static boolean existsParentIn(Iterable<IResource> searchList, IResource resource) {
        IPath path = resource.getFullPath();
        for (IResource r : searchList) {
            if (r == null || !r.isAccessible() || r.equals((Object)resource) || !r.getFullPath().isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }

    protected Collection<IDerivedResourceHandler> createOperations(Set<IResource> resources, IJavaSearchScope searchScope) {
        ArrayList<IDerivedResourceHandler> all = null;
        for (IDerivedResourceHandlerFactory factory : this.m_updateHandlerFactories) {
            try {
                List<IDerivedResourceHandler> ops = factory.createHandlersFor(resources, searchScope);
                if (ops == null || ops.isEmpty()) continue;
                if (all == null) {
                    all = new ArrayList<IDerivedResourceHandler>();
                }
                all.addAll(ops);
            }
            catch (CoreException e) {
                SdkLog.error((CharSequence)"Unable to create operation with handler '{}'.", (Object[])new Object[]{factory.getClass(), e});
            }
        }
        if (all == null) {
            return Collections.emptyList();
        }
        return all;
    }

    @Override
    public synchronized void setEnabled(boolean enabled) {
        if (this.m_enabled == enabled) {
            return;
        }
        this.m_enabled = enabled;
        if (enabled) {
            if (this.m_resourceChangeListener == null) {
                this.m_resourceChangeListener = new P_ResourceChangeListener(this.m_javaChangeEventsToCheck);
                ResourcesPlugin.getWorkspace().addResourceChangeListener(this.m_resourceChangeListener, 1);
            }
            this.m_javaDeltaCheckJob.schedule();
        } else {
            Thread thread;
            if (this.m_resourceChangeListener != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.m_resourceChangeListener);
                this.m_resourceChangeListener = null;
            }
            if ((thread = this.m_javaDeltaCheckJob.getThread()) != null) {
                this.m_javaDeltaCheckJob.cancel();
                thread.interrupt();
                try {
                    this.m_javaDeltaCheckJob.join(3000L, null);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.m_enabled;
    }

    private static <T> boolean addElementToQueueSecure(BlockingQueue<T> queue, T element, String name, long timeout, TimeUnit unit) {
        int numInterrupted = 0;
        while (true) {
            boolean interrupted;
            try {
                interrupted = false;
                if (timeout == 0L) {
                    return queue.offer(element);
                }
                if (timeout < 0L) {
                    queue.put(element);
                    return true;
                }
                return queue.offer(element, timeout, unit);
            }
            catch (InterruptedException e) {
                SdkLog.debug((Object[])new Object[]{e});
                if (interrupted = ++numInterrupted < 10) continue;
                SdkLog.warning((CharSequence)"Too many thread interrupts while waiting for space in the trigger queue. Skipping '{}'.", (Object[])new Object[]{name});
                return false;
            }
            break;
        }
    }

    private static final class P_RunQueuedTriggerHandlersJob
    extends AbstractJob {
        private final BlockingQueue<IDerivedResourceHandler> m_queueToConsume;
        private boolean m_isAborted;

        private P_RunQueuedTriggerHandlersJob(BlockingQueue<IDerivedResourceHandler> queueToConsume) {
            super("Auto-updating derived resources");
            this.setRule(RunTriggerHandlersJobRule.INSTANCE);
            this.setPriority(50);
            this.m_isAborted = false;
            this.m_queueToConsume = queueToConsume;
        }

        public boolean belongsTo(Object family) {
            return DerivedResourceManager.TYPE_CHANGED_TRIGGER_JOB_FAMILY.equals(family);
        }

        private void abort() {
            this.m_isAborted = true;
        }

        private boolean isAborted() {
            return this.m_isAborted;
        }

        private void doCancel() {
            this.m_queueToConsume.clear();
        }

        private void doAbort() {
            this.m_isAborted = false;
            this.schedule();
        }

        @Override
        protected void execute(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                this.doCancel();
                return;
            }
            if (this.isAborted()) {
                this.doAbort();
                return;
            }
            int numOperations = this.m_queueToConsume.size();
            if (numOperations < 1) {
                return;
            }
            EclipseEnvironment.runInEclipseEnvironment((env, progress) -> this.execute((IEnvironment)env, (EclipseProgress)progress, numOperations));
        }

        private void execute(IEnvironment env, EclipseProgress progress, int numOperations) {
            int workByHandler = 100;
            progress.init(numOperations * workByHandler, "", new Object[0]);
            ArrayList executedFileWrites = new ArrayList(numOperations);
            for (int i = 1; i <= numOperations; ++i) {
                if (this.isAborted()) {
                    this.doAbort();
                    return;
                }
                IDerivedResourceHandler handler = (IDerivedResourceHandler)this.m_queueToConsume.poll();
                if (handler == null) continue;
                String handlerName = handler.toString();
                progress.monitor().setTaskName(handlerName + " [" + i + " of " + numOperations + "]");
                progress.monitor().subTask("");
                try {
                    executedFileWrites.addAll(P_RunQueuedTriggerHandlersJob.executeHandler(handler, env, progress.newChild(workByHandler)));
                }
                catch (OperationCanceledException e) {
                    this.doCancel();
                    throw e;
                }
                catch (RuntimeException e) {
                    SdkLog.error((CharSequence)"Error while: {}", (Object[])new Object[]{handlerName, e});
                }
                if (i % 500 != 0) continue;
                SdkFuture.awaitAllLoggingOnError(executedFileWrites);
                executedFileWrites.clear();
                WorkingCopyManager.currentWorkingCopyManager().checkpoint(null);
            }
            SdkFuture.awaitAllLoggingOnError(executedFileWrites);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Collection<? extends IFuture<?>> executeHandler(IDerivedResourceHandler handler, IEnvironment env, IProgress progress) {
            Collection collection;
            long start = System.currentTimeMillis();
            try {
                collection = handler.apply(env, progress);
            }
            catch (Throwable throwable) {
                SdkLog.debug((CharSequence)"Derived Resource Handler ({}) took {}ms to execute.", (Object[])new Object[]{handler.toString(), System.currentTimeMillis() - start});
                throw throwable;
            }
            SdkLog.debug((CharSequence)"Derived Resource Handler ({}) took {}ms to execute.", (Object[])new Object[]{handler.toString(), System.currentTimeMillis() - start});
            return collection;
        }
    }

    private static final class P_ResourceChangeEventCheckJob
    extends AbstractJob {
        private final DerivedResourceManager m_manager;
        private final BlockingQueue<IResourceChangeEvent> m_queueToConsume;

        private P_ResourceChangeEventCheckJob(DerivedResourceManager m, BlockingQueue<IResourceChangeEvent> queueToConsume) {
            super("Check if resource delta triggers a derived resource update");
            this.setSystem(true);
            this.setUser(false);
            this.setPriority(50);
            this.m_manager = m;
            this.m_queueToConsume = queueToConsume;
        }

        public boolean belongsTo(Object family) {
            return DerivedResourceManager.JAVA_DELTA_CHECK_JOB_FAMILY.equals(family);
        }

        @Override
        protected void execute(IProgressMonitor monitor) {
            while (!monitor.isCanceled()) {
                IResourceChangeEvent event = null;
                try {
                    event = this.m_queueToConsume.take();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (monitor.isCanceled()) {
                    return;
                }
                if (event == null || event.getDelta() == null) continue;
                Set<IResource> resources = P_ResourceChangeEventCheckJob.collectFilesFromDelta(event.getDelta());
                this.m_manager.triggerSync(resources);
            }
        }

        private static Set<IResource> collectFilesFromDelta(IResourceDelta d) {
            LinkedHashSet<IResource> scope = new LinkedHashSet<IResource>();
            try {
                d.accept(delta -> {
                    IResource resource = delta.getResource();
                    if (resource != null && resource.getType() == 1 && resource.exists()) {
                        scope.add(resource);
                        return false;
                    }
                    return true;
                });
            }
            catch (CoreException e) {
                SdkLog.error((CharSequence)"Could not calculate the resources affected by a change event.", (Object[])new Object[]{e});
            }
            return scope;
        }
    }

    private final class P_ResourceChangeListener
    implements IResourceChangeListener {
        private final BlockingQueue<IResourceChangeEvent> m_eventCollector;

        private P_ResourceChangeListener(BlockingQueue<IResourceChangeEvent> eventCollector) {
            this.m_eventCollector = eventCollector;
        }

        private boolean isInterestingResourceChangeEvent(IResourceChangeEvent event) {
            Predicate<IResourceChangeEvent> filter = DerivedResourceManager.this.getResourceChangeEventFilter();
            return filter == null || filter.test(event);
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (this.isInterestingResourceChangeEvent(event) && !DerivedResourceManager.addElementToQueueSecure(this.m_eventCollector, event, event.toString(), 10L, TimeUnit.SECONDS)) {
                SdkLog.warning((CharSequence)"Unable to queue more java element changes. Queue is already full. Skipping event.", (Object[])new Object[0]);
            }
        }
    }

    public static final class RunTriggerHandlersJobRule
    implements ISchedulingRule {
        public static final ISchedulingRule INSTANCE = new RunTriggerHandlersJobRule();

        private RunTriggerHandlersJobRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == INSTANCE;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == INSTANCE;
        }
    }
}

