/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.classid;

import java.util.function.BiConsumer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.classid.ClassIds;
import org.eclipse.scout.sdk.core.s.generator.annotation.ScoutAnnotationGenerator;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.operation.AnnotationNewOperation;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.ui.IMarkerResolution;

public class ClassIdDuplicateResolution
implements IMarkerResolution {
    private final IAnnotation m_annotation;

    public ClassIdDuplicateResolution(IAnnotation annotation) {
        this.m_annotation = annotation;
    }

    public String getLabel() {
        return "Update with new @ClassId value";
    }

    public void run(IMarker marker) {
        String newId;
        IType parent = (IType)this.m_annotation.getAncestor(7);
        if (JdtUtils.exists((IJavaElement)parent) && Strings.hasText((CharSequence)(newId = ClassIds.next((String)parent.getFullyQualifiedName())))) {
            EclipseEnvironment.runInEclipseEnvironment(ClassIdDuplicateResolution.createUpdateAnnotationInJavaSourceOperation(parent, newId)).thenRun(() -> ClassIdDuplicateResolution.removeMarker(marker));
        }
    }

    protected static void removeMarker(IMarker marker) {
        try {
            marker.delete();
        }
        catch (CoreException e) {
            IResource resource = marker.getResource();
            if (resource == null) {
                SdkLog.debug((String)"Unable to delete marker", (Object[])new Object[]{e});
            }
            SdkLog.debug((String)"Unable to delete marker on '{}'.", (Object[])new Object[]{resource.getFullPath().toOSString(), e});
        }
    }

    protected static BiConsumer<EclipseEnvironment, EclipseProgress> createUpdateAnnotationInJavaSourceOperation(IType annotationOwner, String newId) {
        return new AnnotationNewOperation(ScoutAnnotationGenerator.createClassId((String)newId), (IMember)annotationOwner);
    }
}

