/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ContentAssistantFacade;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.ScoutModelHierarchy;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.AbstractJob;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.RunnableJob;
import org.eclipse.scout.sdk.s2e.ui.internal.template.BigDecimalFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ButtonProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.CalendarFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.CodeProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ColumnProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.DateFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ExtensionProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.FormFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.FormHandlerProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ImageFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.KeyStrokeProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.LabelFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ListBoxFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.LongFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.MenuProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.RadioButtonProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.SequenceBoxProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.StringFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TabBoxProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TableFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TemplateProposalDescriptor;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TreeFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ValueTypeFieldProposal;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.swt.widgets.Display;

public final class ScoutTemplateProposalFactory {
    public static final Map<String, TemplateProposalDescriptor> TEMPLATES = new ConcurrentHashMap<String, TemplateProposalDescriptor>();

    static {
        int relevance = 10000;
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField", "org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField", "MyString", "Field", "stringfield_add.gif", relevance, StringFieldProposal.class, Collections.singletonList("textfield")));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.IBigDecimalField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.IBigDecimalField", "org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.AbstractBigDecimalField", "MyBigDecimal", "Field", "doublefield_add.gif", relevance, BigDecimalFieldProposal.class, Arrays.asList("numberfield", "doublefield", "floatfield")));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField", "org.eclipse.scout.rt.client.ui.form.fields.booleanfield.AbstractBooleanField", "MyBoolean", "Field", "formField_add.png", relevance, FormFieldProposal.class, Arrays.asList("checkboxfield", "tristatefield")));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.button.IButton", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.button.IButton", "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton", "My", "Button", "button_add.gif", relevance, ButtonProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.calendarfield.ICalendarField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.calendarfield.ICalendarField", "org.eclipse.scout.rt.client.ui.form.fields.calendarfield.AbstractCalendarField", "MyCalendar", "Field", "formField_add.png", relevance, CalendarFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField", "org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractDateField", "MyDate", "Field", "datefield_add.gif", relevance, DateFieldProposal.class, Collections.singletonList("datetimefield")));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField", "org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.AbstractFileChooserField", "MyFileChooser", "Field", "filechooserfield_add.gif", relevance, FormFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox", "org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox", "MyGroup", "Box", "groupbox_add.png", relevance, FormFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField", "org.eclipse.scout.rt.client.ui.form.fields.htmlfield.AbstractHtmlField", "MyHtml", "Field", "formField_add.png", relevance, FormFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.labelfield.ILabelField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.labelfield.ILabelField", "org.eclipse.scout.rt.client.ui.form.fields.labelfield.AbstractLabelField", "MyLabel", "Field", "formField_add.png", relevance, LabelFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.listbox.IListBox", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.listbox.IListBox", "org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox", "MyList", "Box", "formField_add.png", relevance, ListBoxFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.smartfield.IProposalField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.smartfield.IProposalField", "org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractProposalField", "MyProposal", "Field", "smartfield_add.gif", relevance, ValueTypeFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField", "org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField", "MySmart", "Field", "smartfield_add.gif", relevance, ValueTypeFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.longfield.ILongField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.longfield.ILongField", "org.eclipse.scout.rt.client.ui.form.fields.longfield.AbstractLongField", "MyLong", "Field", "integerfield_add.gif", relevance, LongFieldProposal.class, Arrays.asList("integerfield", "numberfield")));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup", "org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup", "MyRadioButtonGroup", "", "radiobuttonGroup_add.gif", relevance, ValueTypeFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox", "org.eclipse.scout.rt.client.ui.form.fields.sequencebox.AbstractSequenceBox", "MySequence", "Box", "sequencebox_add.gif", relevance, SequenceBoxProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox", "org.eclipse.scout.rt.client.ui.form.fields.tabbox.AbstractTabBox", "MyTab", "Box", "tabbox_add.gif", relevance, TabBoxProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField", "org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField", "MyTable", "Field", "tablefield_add.gif", relevance, TableFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.treefield.ITreeField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.treefield.ITreeField", "org.eclipse.scout.rt.client.ui.form.fields.treefield.AbstractTreeField", "MyTree", "Field", "treefield_add.gif", relevance, TreeFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton", "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractRadioButton", "MyRadio", "Button", "radiobutton_add.gif", relevance, RadioButtonProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.action.menu.IMenu", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.action.menu.IMenu", "org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu", "MyMenu", "Menu", "menu_add.png", relevance, MenuProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke", "org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke", "My", "KeyStroke", "keystroke_add.png", relevance, KeyStrokeProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.shared.services.common.code.ICode", new TemplateProposalDescriptor("org.eclipse.scout.rt.shared.services.common.code.ICode", "org.eclipse.scout.rt.shared.services.common.code.AbstractCode", "My", "Code", "code_add.png", relevance, CodeProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.IFormHandler", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.IFormHandler", "org.eclipse.scout.rt.client.ui.form.AbstractFormHandler", "My", "Handler", "formHandler.png", relevance, FormHandlerProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn", "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn", "My", "Column", "tableColumn_add.png", relevance, ColumnProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.shared.extension.IExtension", new TemplateProposalDescriptor("org.eclipse.scout.rt.shared.extension.IExtension", "org.eclipse.scout.rt.shared.extension.AbstractExtension", "My", "Extension", "extension_add.png", relevance, ExtensionProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.imagefield.IImageField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.imagefield.IImageField", "org.eclipse.scout.rt.client.ui.form.fields.imagefield.AbstractImageField", "MyImage", "Field", "formField_add.png", relevance, ImageFieldProposal.class));
    }

    private ScoutTemplateProposalFactory() {
    }

    public static List<ICompletionProposal> createTemplateProposals(IType declaringType, int offset, String prefix, SourceViewer viewer) {
        ISourceRange surroundingTypeNameRange;
        Set<String> superTypesOfDeclaringType;
        try {
            superTypesOfDeclaringType = ScoutTemplateProposalFactory.getAllSuperTypesOf(declaringType);
            surroundingTypeNameRange = declaringType.getNameRange();
        }
        catch (JavaModelException e) {
            SdkLog.error((CharSequence)"Unable to calculate supertype hierarchy for '{}'.", (Object[])new Object[]{declaringType.getFullyQualifiedName(), e});
            return Collections.emptyList();
        }
        Set possibleChildrenIfcFqn = ScoutModelHierarchy.getPossibleChildren(superTypesOfDeclaringType);
        if (possibleChildrenIfcFqn.isEmpty()) {
            return Collections.emptyList();
        }
        ICompilationUnit compilationUnit = declaringType.getCompilationUnit();
        FutureTask<EclipseEnvironment> javaEnvProviderCreator = new FutureTask<EclipseEnvironment>(new P_JavaEnvironmentPreloader(compilationUnit, prefix != null, offset, viewer));
        RunnableJob javaEnvCreatorJob = new RunnableJob("Init Java Environment", javaEnvProviderCreator);
        javaEnvCreatorJob.setUser(false);
        javaEnvCreatorJob.setSystem(true);
        javaEnvCreatorJob.setPriority(20);
        javaEnvCreatorJob.schedule();
        IJavaProject javaProject = declaringType.getJavaProject();
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        for (TemplateProposalDescriptor candidate : TEMPLATES.values()) {
            if (!candidate.isActiveFor(possibleChildrenIfcFqn, javaProject, prefix)) continue;
            result.add(candidate.createProposal(compilationUnit, offset, surroundingTypeNameRange, javaEnvProviderCreator, prefix));
        }
        return result;
    }

    private static Set<String> getAllSuperTypesOf(IType declaringType) throws JavaModelException {
        ITypeHierarchy supertypeHierarchy = declaringType.newSupertypeHierarchy(null);
        IType[] allTypes = supertypeHierarchy.getAllTypes();
        HashSet<String> superTypesOfDeclaringType = new HashSet<String>(allTypes.length);
        IType[] iTypeArray = allTypes;
        int n = allTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType superType = iTypeArray[n2];
            superTypesOfDeclaringType.add(superType.getFullyQualifiedName());
            ++n2;
        }
        return superTypesOfDeclaringType;
    }

    private static final class P_JavaEnvironmentPreloader
    implements Callable<EclipseEnvironment>,
    ICompletionListener {
        private final ICompilationUnit m_icu;
        private final boolean m_hasSearchString;
        private final int m_pos;
        private final ContentAssistantFacade m_contentAssistFacade;
        private final EclipseEnvironment m_provider;
        private final Display m_display;

        private P_JavaEnvironmentPreloader(ICompilationUnit icu, boolean hasSearchString, int pos, SourceViewer viewer) {
            this.m_icu = icu;
            this.m_hasSearchString = hasSearchString;
            this.m_pos = pos;
            this.m_contentAssistFacade = viewer.getContentAssistantFacade();
            this.m_display = viewer.getControl().getDisplay();
            this.m_provider = EclipseEnvironment.createUnsafe(env -> this.m_contentAssistFacade.addCompletionListener((ICompletionListener)this));
        }

        @Override
        public EclipseEnvironment call() throws JavaModelException {
            String pck = JdtUtils.getPackage((ICompilationUnit)this.m_icu);
            if (Strings.isBlank((CharSequence)pck)) {
                pck = null;
            }
            IJavaEnvironment env = this.m_provider.toScoutJavaEnvironment(this.m_icu.getJavaProject());
            StringBuilder buf = new StringBuilder(this.m_icu.getSource());
            if (this.m_hasSearchString) {
                buf.insert(this.m_pos, ';');
            }
            env.registerCompilationUnitOverride(pck, this.m_icu.getElementName(), (CharSequence)buf);
            env.findType(this.m_icu.findPrimaryType().getFullyQualifiedName());
            return this.m_provider;
        }

        public void assistSessionStarted(ContentAssistEvent event) {
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            this.m_contentAssistFacade.removeCompletionListener((ICompletionListener)this);
            this.m_display.asyncExec(this::scheduleEnvironmentClose);
        }

        private void scheduleEnvironmentClose() {
            AbstractJob closeJob = new AbstractJob("close content assist environment"){

                protected void execute(IProgressMonitor monitor) {
                    m_provider.close();
                }
            };
            closeJob.setSystem(true);
            closeJob.setUser(false);
            closeJob.schedule();
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }
    }
}

