/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.IGridAdapter;
import org.eclipse.nebula.widgets.grid.internal.IScrollBarProxy;
import org.eclipse.nebula.widgets.grid.internal.NullScrollBarProxy;
import org.eclipse.nebula.widgets.grid.internal.ScrollBarProxyAdapter;
import org.eclipse.nebula.widgets.grid.internal.gridkit.GridThemeAdapter;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grid
extends Canvas {
    private static final int MIN_ITEM_HEIGHT = 16;
    private static final int GRID_WIDTH = 1;
    private List<GridItem> items = new ArrayList<GridItem>();
    private List<GridItem> rootItems = new ArrayList<GridItem>();
    private List<GridItem> selectedItems = new ArrayList<GridItem>();
    private List<Point> selectedCells = new ArrayList<Point>();
    private List<GridColumn> columns = new ArrayList<GridColumn>();
    private List<GridColumn> displayOrderedColumns = new ArrayList<GridColumn>();
    private List<GridColumnGroup> columnGroups = new ArrayList<GridColumnGroup>();
    private GridItem focusItem;
    private boolean isTree;
    private boolean disposing;
    private boolean columnHeadersVisible;
    private boolean columnFootersVisible;
    private boolean linesVisible = true;
    private int currentVisibleItems;
    private int selectionType = 4;
    private boolean selectionEnabled = true;
    private boolean cellSelectionEnabled;
    private int customItemHeight = -1;
    private int groupHeaderHeight;
    private Point itemImageSize;
    private ControlListener resizeListener;
    private boolean isTemporaryResize;
    private IScrollBarProxy vScroll;
    private IScrollBarProxy hScroll;
    private boolean scrollValuesObsolete;
    private int topIndex = -1;
    private int bottomIndex = -1;
    private boolean bottomIndexShownCompletely;
    private final IGridAdapter gridAdapter;
    private transient CompositeItemHolder itemHolder;
    boolean hasDifferingHeights;
    boolean markupEnabled;
    boolean markupValidationDisabled;
    LayoutCache layoutCache;

    public Grid(Composite parent, int style) {
        super(parent, Grid.checkStyle(style));
        if ((style & 2) != 0) {
            this.selectionType = 2;
        }
        if (this.getVerticalBar() != null) {
            this.getVerticalBar().setVisible(false);
            this.vScroll = new ScrollBarProxyAdapter(this.getVerticalBar());
        } else {
            this.vScroll = new NullScrollBarProxy();
        }
        if (this.getHorizontalBar() != null) {
            this.getHorizontalBar().setVisible(false);
            this.hScroll = new ScrollBarProxyAdapter(this.getHorizontalBar());
        } else {
            this.hScroll = new NullScrollBarProxy();
        }
        this.gridAdapter = new GridAdapter();
        this.layoutCache = new LayoutCache();
        this.setScrollValuesObsolete();
        this.initListeners();
    }

    public void dispose() {
        this.disposing = true;
        this.removeControlListener(this.resizeListener);
        super.dispose();
        for (GridItem item : this.items) {
            item.dispose();
        }
        for (GridColumn column : this.columns) {
            column.dispose();
        }
        for (GridColumnGroup group : this.columnGroups) {
            group.dispose();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point rreferredSize = null;
        if (wHint == -1 || hHint == -1) {
            rreferredSize = this.getTableSize();
            rreferredSize.x += 2 * this.getBorderWidth();
            rreferredSize.y += 2 * this.getBorderWidth();
        }
        int width = 0;
        int height = 0;
        if (wHint == -1) {
            width += rreferredSize.x;
            if (this.getVerticalBar() != null) {
                width += this.getVerticalBar().getSize().x;
            }
        } else {
            width = wHint;
        }
        if (hHint == -1) {
            height += rreferredSize.y;
            if (this.getHorizontalBar() != null) {
                height += this.getHorizontalBar().getSize().y;
            }
        } else {
            height = hHint;
        }
        return new Point(width, height);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(17, (Listener)typedListener);
        this.addListener(18, (Listener)typedListener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(17, (SWTEventListener)listener);
        this.removeListener(18, (SWTEventListener)listener);
    }

    public void setItemCount(int count) {
        this.checkWidget();
        int itemCount = Math.max(0, count);
        while (itemCount < this.items.size()) {
            this.items.get(this.items.size() - 1).dispose();
        }
        while (itemCount > this.items.size()) {
            new GridItem(this, 0);
        }
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public GridItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new GridItem[this.items.size()]);
    }

    public GridItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            SWT.error((int)6);
        }
        return this.items.get(index);
    }

    public GridItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
        }
        GridItem result = null;
        if (point.x >= 0 && point.x <= this.getClientArea().width) {
            Point p = new Point(point.x, point.y);
            int y = 0;
            if (this.columnHeadersVisible) {
                y += this.getHeaderHeight();
            }
            if (p.y > y) {
                int row = this.getTopIndex();
                while (row < this.items.size() && y <= this.getClientArea().height && result == null) {
                    GridItem currentItem = this.items.get(row);
                    if (currentItem.isVisible()) {
                        int currentItemHeight = currentItem.getHeight();
                        if (p.y >= y && p.y < y + currentItemHeight) {
                            result = currentItem;
                        }
                        y += currentItemHeight;
                    }
                    ++row;
                }
            }
        }
        return result;
    }

    public int indexOf(GridItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        int result = -1;
        if (item.getParent() == this) {
            result = this.items.indexOf((Object)item);
        }
        return result;
    }

    public int getRootItemCount() {
        this.checkWidget();
        return this.rootItems.size();
    }

    public GridItem[] getRootItems() {
        this.checkWidget();
        return this.rootItems.toArray(new GridItem[this.rootItems.size()]);
    }

    public GridItem getRootItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.rootItems.size()) {
            SWT.error((int)6);
        }
        return this.rootItems.get(index);
    }

    public GridItem getNextVisibleItem(GridItem item) {
        this.checkWidget();
        GridItem result = null;
        int index = this.items.indexOf((Object)item);
        if (index != this.items.size() - 1) {
            result = this.items.get(index + 1);
            while (result != null && !result.isVisible()) {
                result = ++index != this.items.size() - 1 ? this.items.get(index + 1) : null;
            }
        }
        return result;
    }

    public GridItem getPreviousVisibleItem(GridItem item) {
        this.checkWidget();
        GridItem result = null;
        int index = 0;
        index = item == null ? this.items.size() : this.items.indexOf((Object)item);
        if (index > 0) {
            result = this.items.get(index - 1);
            while (result != null && !result.isVisible()) {
                result = --index > 0 ? this.items.get(index - 1) : null;
            }
        }
        return result;
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columns.size();
    }

    public GridColumn[] getColumns() {
        this.checkWidget();
        return this.columns.toArray(new GridColumn[this.columns.size()]);
    }

    public GridColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index > this.getColumnCount() - 1) {
            SWT.error((int)6);
        }
        return this.columns.get(index);
    }

    public int indexOf(GridColumn column) {
        this.checkWidget();
        if (column == null) {
            SWT.error((int)4);
        }
        int result = -1;
        if (column.getParent() == this) {
            result = this.columns.indexOf((Object)column);
        }
        return result;
    }

    public void setColumnOrder(int[] order) {
        int i;
        this.checkWidget();
        if (order == null) {
            SWT.error((int)4);
        }
        if (order.length != this.displayOrderedColumns.size()) {
            SWT.error((int)5);
        }
        boolean[] seen = new boolean[this.displayOrderedColumns.size()];
        int i2 = 0;
        while (i2 < order.length) {
            if (order[i2] < 0 || order[i2] >= this.displayOrderedColumns.size()) {
                SWT.error((int)5);
            }
            if (seen[order[i2]]) {
                SWT.error((int)5);
            }
            seen[order[i2]] = true;
            ++i2;
        }
        if (this.columnGroups.size() != 0) {
            GridColumnGroup currentGroup = null;
            int columnsInGroup = 0;
            i = 0;
            while (i < order.length) {
                GridColumn column = this.getColumn(order[i]);
                if (currentGroup != null) {
                    if (column.getColumnGroup() != currentGroup && columnsInGroup > 0) {
                        SWT.error((int)5);
                    } else if (--columnsInGroup <= 0) {
                        currentGroup = null;
                    }
                } else if (column.getColumnGroup() != null) {
                    currentGroup = column.getColumnGroup();
                    columnsInGroup = currentGroup.getColumns().length - 1;
                }
                ++i;
            }
        }
        GridColumn[] columns = this.getColumns();
        int[] oldOrder = this.getColumnOrder();
        this.displayOrderedColumns.clear();
        i = 0;
        while (i < order.length) {
            this.displayOrderedColumns.add(columns[order[i]]);
            ++i;
        }
        i = 0;
        while (i < order.length) {
            if (oldOrder[i] != order[i]) {
                columns[order[i]].fireMoved();
            }
            ++i;
        }
        this.updatePrimaryCheckColumn();
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] result = new int[this.columns.size()];
        int i = 0;
        while (i < result.length) {
            GridColumn column = this.displayOrderedColumns.get(i);
            result[i] = this.columns.indexOf((Object)column);
            ++i;
        }
        return result;
    }

    public GridColumn getNextVisibleColumn(GridColumn column) {
        this.checkWidget();
        GridColumn result = null;
        int index = this.displayOrderedColumns.indexOf((Object)column);
        if (index != this.displayOrderedColumns.size() - 1) {
            result = this.displayOrderedColumns.get(index + 1);
            while (result != null && !result.isVisible()) {
                result = ++index != this.displayOrderedColumns.size() - 1 ? this.displayOrderedColumns.get(index + 1) : null;
            }
        }
        return result;
    }

    public GridColumn getPreviousVisibleColumn(GridColumn column) {
        this.checkWidget();
        GridColumn result = null;
        int index = 0;
        index = column == null ? this.displayOrderedColumns.size() : this.displayOrderedColumns.indexOf((Object)column);
        if (index > 0) {
            result = this.displayOrderedColumns.get(index - 1);
            while (result != null && !result.isVisible()) {
                result = --index > 0 ? this.displayOrderedColumns.get(index - 1) : null;
            }
        }
        return result;
    }

    public int getColumnGroupCount() {
        this.checkWidget();
        return this.columnGroups.size();
    }

    public GridColumnGroup[] getColumnGroups() {
        this.checkWidget();
        return this.columnGroups.toArray(new GridColumnGroup[this.columnGroups.size()]);
    }

    public GridColumnGroup getColumnGroup(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnGroups.size()) {
            SWT.error((int)6);
        }
        return this.columnGroups.get(index);
    }

    public void clear(int index, boolean allChildren) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            SWT.error((int)6);
        }
        this.items.get(index).clear(allChildren);
        this.redraw();
    }

    public void clear(int start, int end, boolean allChildren) {
        this.checkWidget();
        if (start <= end) {
            if (start < 0 || start > end || end >= this.items.size()) {
                SWT.error((int)6);
            }
            int i = start;
            while (i <= end) {
                this.items.get(i).clear(allChildren);
                ++i;
            }
            this.redraw();
        }
    }

    public void clear(int[] indices, boolean allChildren) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if (indices.length > 0) {
            int i = 0;
            while (i < indices.length) {
                if (!this.isValidItemIndex(indices[i])) {
                    SWT.error((int)6);
                }
                ++i;
            }
            i = 0;
            while (i < indices.length) {
                this.items.get(indices[i]).clear(allChildren);
                ++i;
            }
            this.redraw();
        }
    }

    public void clearAll(boolean allChildren) {
        this.checkWidget();
        int itemsCount = this.items.size();
        if (itemsCount > 0) {
            this.clear(0, itemsCount - 1, allChildren);
            this.itemImageSize = null;
            this.setCellToolTipsEnabled(false);
            this.layoutCache.invalidateItemHeight();
        }
    }

    public void setSelectionEnabled(boolean selectionEnabled) {
        this.checkWidget();
        if (!selectionEnabled) {
            this.selectedItems.clear();
            this.redraw();
        }
        this.selectionEnabled = selectionEnabled;
    }

    public boolean getSelectionEnabled() {
        this.checkWidget();
        return this.selectionEnabled;
    }

    public void select(int index) {
        this.checkWidget();
        if (this.selectionEnabled && this.isValidItemIndex(index)) {
            if (!this.cellSelectionEnabled && this.selectionType == 4) {
                this.selectedItems.clear();
            }
            this.internalSelect(index);
            this.redraw();
        }
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (this.selectionEnabled && (this.selectionType != 4 || start == end)) {
            if (!this.cellSelectionEnabled && this.selectionType == 4) {
                this.selectedItems.clear();
            }
            int index = Math.max(0, start);
            while (index <= Math.min(this.items.size() - 1, end)) {
                this.internalSelect(index);
                ++index;
            }
            this.redraw();
        }
    }

    public void select(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if (this.selectionEnabled && (this.selectionType != 4 || indices.length <= 1)) {
            if (!this.cellSelectionEnabled && this.selectionType == 4) {
                this.selectedItems.clear();
            }
            int i = 0;
            while (i < indices.length) {
                this.internalSelect(indices[i]);
                ++i;
            }
            this.redraw();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if (this.selectionEnabled && this.selectionType != 4 && !this.cellSelectionEnabled) {
            this.selectedItems.clear();
            this.selectedItems.addAll(this.items);
            this.redraw();
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        if (this.isValidItemIndex(index)) {
            this.internalDeselect(index);
            this.redraw();
        }
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        int index = Math.max(0, start);
        while (index <= Math.min(this.items.size() - 1, end)) {
            this.internalDeselect(index);
            ++index;
        }
        this.redraw();
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        int i = 0;
        while (i < indices.length) {
            this.internalDeselect(indices[i]);
            ++i;
        }
        this.redraw();
    }

    public void deselectAll() {
        this.checkWidget();
        this.internalDeselectAll();
        this.redraw();
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (this.selectionEnabled && this.isValidItemIndex(index)) {
            this.internalDeselectAll();
            this.internalSelect(index);
            this.redraw();
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if (this.selectionEnabled && (this.selectionType != 4 || start == end)) {
            this.internalDeselectAll();
            int index = Math.max(0, start);
            while (index <= Math.min(this.items.size() - 1, end)) {
                this.internalSelect(index);
                ++index;
            }
            this.redraw();
        }
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if (this.selectionEnabled && (this.selectionType != 4 || indices.length <= 1)) {
            this.internalDeselectAll();
            int i = 0;
            while (i < indices.length) {
                this.internalSelect(indices[i]);
                ++i;
            }
            this.redraw();
        }
    }

    public void setSelection(GridItem[] items) {
        this.checkWidget();
        if (items == null) {
            SWT.error((int)4);
        }
        if (this.selectionEnabled && (this.selectionType != 4 || items.length <= 1)) {
            this.internalDeselectAll();
            int i = 0;
            while (i < items.length) {
                GridItem item = items[i];
                if (item != null) {
                    if (item.isDisposed()) {
                        SWT.error((int)5);
                    }
                    this.internalSelect(this.indexOf(item));
                }
                ++i;
            }
            this.redraw();
        }
    }

    public GridItem[] getSelection() {
        this.checkWidget();
        GridItem[] result = new GridItem[]{};
        if (!this.cellSelectionEnabled) {
            result = this.selectedItems.toArray(new GridItem[this.selectedItems.size()]);
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int result = 0;
        if (!this.cellSelectionEnabled) {
            result = this.selectedItems.size();
        }
        return result;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int result = -1;
        if (this.cellSelectionEnabled) {
            if (this.selectedCells.size() != 0) {
                result = this.selectedCells.get((int)0).y;
            }
        } else if (this.selectedItems.size() != 0) {
            result = this.items.indexOf((Object)this.selectedItems.get(0));
        }
        return result;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int[] result = new int[]{};
        if (this.cellSelectionEnabled) {
            ArrayList<GridItem> selectedRows = new ArrayList<GridItem>();
            for (Point cell : this.selectedCells) {
                GridItem item = this.getItem(cell.y);
                if (selectedRows.contains((Object)item)) continue;
                selectedRows.add(item);
            }
            result = new int[selectedRows.size()];
            int i = 0;
            while (i < result.length) {
                GridItem item = (GridItem)((Object)selectedRows.get(i));
                result[i] = this.items.indexOf((Object)item);
                ++i;
            }
        } else {
            result = new int[this.selectedItems.size()];
            int i = 0;
            while (i < result.length) {
                GridItem item = this.selectedItems.get(i);
                result[i] = this.items.indexOf((Object)item);
                ++i;
            }
        }
        return result;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        boolean result = false;
        if (this.isValidItemIndex(index)) {
            if (this.cellSelectionEnabled) {
                for (Point cell : this.selectedCells) {
                    if (cell.y != index) continue;
                    result = true;
                }
            } else {
                result = this.isSelected(this.items.get(index));
            }
        }
        return result;
    }

    public boolean isSelected(GridItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        boolean result = false;
        if (this.cellSelectionEnabled) {
            int index = this.indexOf(item);
            if (index != -1) {
                for (Point cell : this.selectedCells) {
                    if (cell.y != index) continue;
                    result = true;
                }
            }
        } else {
            result = this.selectedItems.contains((Object)item);
        }
        return result;
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index > this.items.size() - 1) {
            SWT.error((int)6);
        }
        this.items.get(index).dispose();
        this.redraw();
    }

    public void remove(int start, int end) {
        this.checkWidget();
        int i = end;
        while (i >= start) {
            if (i < 0 || i > this.items.size() - 1) {
                SWT.error((int)6);
            }
            this.items.get(i).dispose();
            --i;
        }
        this.redraw();
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        GridItem[] removeThese = new GridItem[indices.length];
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (this.isValidItemIndex(index)) {
                removeThese[i] = this.items.get(index);
            } else {
                SWT.error((int)6);
            }
            ++i;
        }
        i = 0;
        while (i < removeThese.length) {
            removeThese[i].dispose();
            ++i;
        }
        this.redraw();
    }

    public void removeAll() {
        this.checkWidget();
        while (this.items.size() > 0) {
            this.items.get(0).dispose();
        }
        this.redraw();
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        if (this.columnHeadersVisible != show) {
            this.columnHeadersVisible = show;
            this.layoutCache.invalidateHeaderHeight();
            this.invalidateTopBottomIndex();
            this.setScrollValuesObsolete();
        }
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return this.columnHeadersVisible;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!this.layoutCache.hasHeaderHeight()) {
            this.layoutCache.headerHeight = this.computeHeaderHeight();
        }
        return this.layoutCache.headerHeight;
    }

    public void setFooterVisible(boolean show) {
        this.checkWidget();
        if (this.columnFootersVisible != show) {
            this.columnFootersVisible = show;
            this.layoutCache.invalidateFooterHeight();
            this.invalidateTopBottomIndex();
            this.setScrollValuesObsolete();
        }
    }

    public boolean getFooterVisible() {
        this.checkWidget();
        return this.columnFootersVisible;
    }

    public int getFooterHeight() {
        this.checkWidget();
        if (!this.layoutCache.hasFooterHeight()) {
            this.layoutCache.footerHeight = this.computeFooterHeight();
        }
        return this.layoutCache.footerHeight;
    }

    public int getGroupHeaderHeight() {
        this.checkWidget();
        if (!this.layoutCache.hasHeaderHeight()) {
            this.layoutCache.headerHeight = this.computeHeaderHeight();
        }
        return this.groupHeaderHeight;
    }

    public void setLinesVisible(boolean linesVisible) {
        this.checkWidget();
        this.linesVisible = linesVisible;
        this.redraw();
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    public void setFocusItem(GridItem item) {
        this.checkWidget();
        if (item == null || item.isDisposed() || item.getParent() != this || !item.isVisible()) {
            SWT.error((int)5);
        }
        this.focusItem = item;
    }

    public GridItem getFocusItem() {
        this.checkWidget();
        return this.focusItem;
    }

    public void setItemHeight(int height) {
        this.checkWidget();
        if (height < 1) {
            SWT.error((int)5);
        }
        if (this.customItemHeight != height) {
            this.customItemHeight = height;
            int i = 0;
            while (i < this.items.size()) {
                this.items.get(i).setHeight(height);
                ++i;
            }
            this.hasDifferingHeights = false;
            this.invalidateTopBottomIndex();
            this.setScrollValuesObsolete();
        }
    }

    public int getItemHeight() {
        this.checkWidget();
        int result = this.customItemHeight;
        if (result == -1) {
            if (!this.layoutCache.hasItemHeight()) {
                this.layoutCache.itemHeight = this.computeItemHeight();
            }
            result = this.layoutCache.itemHeight;
        }
        return result;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.layoutCache.invalidateItemHeight();
        this.setScrollValuesObsolete();
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if (this.isValidItemIndex(index)) {
            this.updateScrollBars();
            GridItem item = this.items.get(index);
            if (item.isVisible() && this.vScroll.getVisible()) {
                int vScrollAmount = 0;
                int i = 0;
                while (i < index) {
                    if (this.items.get(i).isVisible()) {
                        ++vScrollAmount;
                    }
                    ++i;
                }
                this.vScroll.setSelection(vScrollAmount);
                this.invalidateTopBottomIndex();
            }
        }
    }

    public int getTopIndex() {
        this.checkWidget();
        if (this.topIndex == -1) {
            this.updateScrollBars();
            if (this.vScroll.getVisible()) {
                int firstVisibleIndex = this.vScroll.getSelection();
                if (this.isTree) {
                    Iterator<GridItem> iterator = this.items.iterator();
                    int row = firstVisibleIndex + 1;
                    while (row > 0 && iterator.hasNext()) {
                        GridItem item = iterator.next();
                        if (!item.isVisible() || --row != 0) continue;
                        firstVisibleIndex = this.items.indexOf((Object)item);
                    }
                }
                this.topIndex = firstVisibleIndex;
            } else {
                this.topIndex = 0;
            }
        }
        return this.topIndex;
    }

    public void showItem(GridItem item) {
        int visibleGridHeight;
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (item.isDisposed()) {
            SWT.error((int)5);
        }
        if (item.getParent() == this && (visibleGridHeight = this.getVisibleGridHeight()) >= 1) {
            this.updateScrollBars();
            GridItem parent = item.getParentItem();
            while (parent != null) {
                if (!parent.isExpanded()) {
                    parent.setExpanded(true);
                    parent.fireEvent(17);
                }
                parent = parent.getParentItem();
            }
            if (!this.isShown(item)) {
                this.setTopIndex(this.items.indexOf((Object)item));
            }
        }
    }

    public void showColumn(GridColumn column) {
        this.checkWidget();
        if (column == null) {
            SWT.error((int)4);
        }
        if (column.isDisposed()) {
            SWT.error((int)5);
        }
        if (column.getParent() == this) {
            this.updateScrollBars();
            if (!column.isVisible()) {
                GridColumnGroup group;
                group.setExpanded(!(group = column.getColumnGroup()).getExpanded());
                if (group.getExpanded()) {
                    group.notifyListeners(17, new Event());
                } else {
                    group.notifyListeners(18, new Event());
                }
            }
            if (this.hScroll.getVisible()) {
                int offset = this.hScroll.getSelection();
                int x = this.getColumnHeaderXPosition(column);
                if (x < 0 || x + column.getWidth() > this.getClientArea().width) {
                    if (x >= 0 && column.getWidth() <= this.getClientArea().width) {
                        x -= this.getClientArea().width - column.getWidth();
                    }
                    this.hScroll.setSelection(offset + x);
                }
            }
        }
    }

    public void showSelection() {
        this.checkWidget();
        GridItem item = null;
        if (this.cellSelectionEnabled) {
            if (this.selectedCells.size() != 0) {
                Point cell = this.selectedCells.get(0);
                item = this.getItem(cell.y);
                this.showItem(item);
                GridColumn column = this.getColumn(cell.x);
                this.showColumn(column);
            }
        } else if (this.selectedItems.size() != 0) {
            item = this.selectedItems.get(0);
            this.showItem(item);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (adapter == IItemHolderAdapter.class) {
            if (this.itemHolder == null) {
                this.itemHolder = new CompositeItemHolder();
            }
            result = this.itemHolder;
        } else {
            result = adapter == IGridAdapter.class ? this.gridAdapter : (adapter == ICellToolTipAdapter.class ? this.gridAdapter : super.getAdapter(adapter));
        }
        return (T)result;
    }

    public void setData(String key, Object value) {
        if ("org.eclipse.rap.rwt.markupEnabled".equals(key) && !this.markupEnabled) {
            this.markupEnabled = Boolean.TRUE.equals(value);
        } else if ("org.eclipse.rap.rwt.markupValidationDisabled".equals(key)) {
            this.markupValidationDisabled = Boolean.TRUE.equals(value);
        }
        super.setData(key, value);
    }

    int newItem(GridItem item, int index, boolean root) {
        int row = 0;
        GridItem parentItem = item.getParentItem();
        if (!this.isTree && parentItem != null) {
            this.isTree = true;
        }
        int flatIndex = index;
        if (root && index != -1) {
            flatIndex = index >= this.rootItems.size() ? -1 : this.items.indexOf((Object)this.rootItems.get(index));
        } else if (!root) {
            if (index >= parentItem.getItems().length || index == -1) {
                GridItem rightMostDescendent = parentItem;
                while (rightMostDescendent.getItems().length > 0) {
                    GridItem[] rightMostDescendentItems = rightMostDescendent.getItems();
                    rightMostDescendent = rightMostDescendentItems[rightMostDescendentItems.length - 1];
                }
                flatIndex = this.indexOf(rightMostDescendent) + 1;
            } else {
                flatIndex = this.indexOf(parentItem.getItems()[index]);
            }
        }
        if (flatIndex == -1) {
            this.items.add(item);
            row = this.items.size() - 1;
        } else {
            this.items.add(flatIndex, item);
            row = flatIndex;
        }
        this.invalidateTopBottomIndex();
        this.updateVisibleItems(1);
        return row;
    }

    void removeItem(GridItem item) {
        this.items.remove((Object)item);
        if (!this.disposing) {
            this.selectedItems.remove((Object)item);
            if (this.focusItem == item) {
                this.focusItem = null;
            }
            this.invalidateTopBottomIndex();
            if (item.isVisible()) {
                this.updateVisibleItems(-1);
            }
            this.setScrollValuesObsolete();
        }
    }

    void newRootItem(GridItem item, int index) {
        if (index == -1 || index >= this.rootItems.size()) {
            this.rootItems.add(item);
        } else {
            this.rootItems.add(index, item);
        }
    }

    void removeRootItem(GridItem item) {
        this.rootItems.remove((Object)item);
    }

    int newColumn(GridColumn column, int index) {
        if (index == -1) {
            this.columns.add(column);
            this.displayOrderedColumns.add(column);
        } else {
            this.columns.add(index, column);
            this.displayOrderedColumns.add(index, column);
        }
        this.updatePrimaryCheckColumn();
        for (GridItem item : this.items) {
            item.columnAdded(index);
        }
        if (column.isCheck()) {
            this.layoutCache.invalidateItemHeight();
        }
        this.layoutCache.invalidateHeaderHeight();
        this.layoutCache.invalidateFooterHeight();
        this.invalidateTopBottomIndex();
        this.setScrollValuesObsolete();
        return this.columns.size() - 1;
    }

    void removeColumn(GridColumn column) {
        int index = this.indexOf(column);
        this.columns.remove((Object)column);
        this.displayOrderedColumns.remove((Object)column);
        this.updatePrimaryCheckColumn();
        for (GridItem item : this.items) {
            item.columnRemoved(index);
        }
        if (column.isCheck()) {
            this.layoutCache.invalidateItemHeight();
        }
        this.layoutCache.invalidateHeaderHeight();
        this.layoutCache.invalidateFooterHeight();
        this.invalidateTopBottomIndex();
        this.setScrollValuesObsolete();
    }

    void newColumnGroup(GridColumnGroup group) {
        this.columnGroups.add(group);
        if (this.columnGroups.size() == 1) {
            this.layoutCache.invalidateHeaderHeight();
        }
        this.invalidateTopBottomIndex();
        this.setScrollValuesObsolete();
    }

    void removeColumnGroup(GridColumnGroup group) {
        this.columnGroups.remove((Object)group);
        if (this.columnGroups.size() == 0) {
            this.layoutCache.invalidateHeaderHeight();
        }
        this.invalidateTopBottomIndex();
        this.setScrollValuesObsolete();
    }

    boolean isDisposing() {
        return this.disposing;
    }

    void updateVisibleItems(int amount) {
        this.currentVisibleItems += amount;
    }

    GridColumn[] getColumnsInOrder() {
        this.checkWidget();
        return this.displayOrderedColumns.toArray(new GridColumn[this.columns.size()]);
    }

    void imageSetOnItem(int column, GridItem item) {
        Image image = item.getImage(column);
        if (image != null && this.itemImageSize == null) {
            Rectangle imageBounds = image.getBounds();
            this.itemImageSize = new Point(imageBounds.width, imageBounds.height);
            this.layoutCache.invalidateItemHeight();
            this.setScrollValuesObsolete();
        }
    }

    int getMaxContentWidth(GridColumn column) {
        return Grid.getMaxInnerWidth(this.getRootItems(), this.indexOf(column));
    }

    int getBottomIndex() {
        this.checkWidget();
        if (this.bottomIndex == -1) {
            int topIndex = this.getTopIndex();
            int visibleGridHeight = this.getVisibleGridHeight();
            if (this.items.size() == 0) {
                this.bottomIndex = 0;
            } else if (visibleGridHeight < 1) {
                this.bottomIndex = topIndex;
            } else {
                RowRange range = this.getRowRange(topIndex, visibleGridHeight, false, false);
                this.bottomIndex = range.endIndex;
                this.bottomIndexShownCompletely = range.height <= visibleGridHeight;
            }
        }
        return this.bottomIndex;
    }

    void invalidateTopBottomIndex() {
        this.topIndex = -1;
        this.bottomIndex = -1;
    }

    Point getOrigin(GridColumn column, GridItem item) {
        int x = column.getLeft() - this.hScroll.getSelection();
        int y = 0;
        if (item != null) {
            if (this.columnHeadersVisible) {
                y += this.getHeaderHeight();
            }
            int topIndex = this.getTopIndex();
            int itemIndex = this.items.indexOf((Object)item);
            if (itemIndex == -1) {
                SWT.error((int)5);
            }
            while (topIndex != itemIndex) {
                GridItem currentItem;
                if (topIndex < itemIndex) {
                    currentItem = this.items.get(topIndex);
                    if (currentItem.isVisible()) {
                        y += currentItem.getHeight();
                    }
                    ++topIndex;
                    continue;
                }
                if (topIndex <= itemIndex || !(currentItem = this.items.get(--topIndex)).isVisible()) continue;
                y -= currentItem.getHeight();
            }
        }
        return new Point(x, y);
    }

    boolean isShown(GridItem item) {
        this.checkWidget();
        boolean result = false;
        if (item.isVisible()) {
            int itemIndex = this.items.indexOf((Object)item);
            if (itemIndex == -1) {
                SWT.error((int)5);
            }
            int firstVisibleIndex = this.getTopIndex();
            int lastVisibleIndex = this.getBottomIndex();
            result = itemIndex >= firstVisibleIndex && itemIndex < lastVisibleIndex || itemIndex == lastVisibleIndex && this.bottomIndexShownCompletely;
        }
        return result;
    }

    private void doRedraw() {
        this.updateScrollBars();
    }

    void setScrollValuesObsolete() {
        this.scrollValuesObsolete = true;
        this.redraw();
    }

    void updateScrollBars() {
        if (this.scrollValuesObsolete) {
            Point preferredSize = this.getTableSize();
            Rectangle clientArea = this.getClientArea();
            int doublePass = 1;
            while (doublePass <= 2) {
                if (preferredSize.y > clientArea.height) {
                    this.vScroll.setVisible(true);
                } else {
                    this.vScroll.setVisible(false);
                    this.vScroll.setValues(0, 0, 1, 1, 1, 1);
                }
                if (preferredSize.x > clientArea.width) {
                    this.hScroll.setVisible(true);
                } else {
                    this.hScroll.setVisible(false);
                    this.hScroll.setValues(0, 0, 1, 1, 1, 1);
                }
                clientArea = this.getClientArea();
                ++doublePass;
            }
            if (this.vScroll.getVisible()) {
                int max = this.currentVisibleItems;
                int thumb = 1;
                int visibleGridHeight = this.getVisibleGridHeight();
                if (!this.hasDifferingHeights) {
                    thumb = visibleGridHeight / this.getItemHeight();
                } else if (visibleGridHeight >= 1) {
                    RowRange range = this.getRowRange(-1, visibleGridHeight, true, true);
                    max -= range.rows - 1;
                }
                int selection = Math.min(this.vScroll.getSelection(), max);
                this.vScroll.setValues(selection, 0, max, thumb, 1, thumb);
            }
            if (this.hScroll.getVisible()) {
                int hiddenArea = preferredSize.x - clientArea.width;
                int selection = Math.min(this.hScroll.getSelection(), hiddenArea);
                this.hScroll.setValues(selection, 0, preferredSize.x, clientArea.width, 5, clientArea.width);
            }
            this.scrollValuesObsolete = false;
        }
    }

    protected IScrollBarProxy getHorizontalScrollBarProxy() {
        this.checkWidget();
        return this.hScroll;
    }

    protected IScrollBarProxy getVerticalScrollBarProxy() {
        this.checkWidget();
        return this.vScroll;
    }

    private void initListeners() {
        this.resizeListener = new ResizeListener();
        this.addControlListener(this.resizeListener);
    }

    void setCellToolTipsEnabled(boolean enabled) {
        this.setData(ICellToolTipProvider.ENABLE_CELL_TOOLTIP, enabled);
    }

    private Point getTableSize() {
        int width = 0;
        int height = 0;
        if (this.columnHeadersVisible) {
            height += this.getHeaderHeight();
        }
        if (this.columnFootersVisible) {
            height += this.getFooterHeight();
        }
        height += this.getGridHeight();
        for (GridColumn column : this.columns) {
            if (!column.isVisible()) continue;
            width += column.getWidth();
        }
        return new Point(width, height);
    }

    private int getGridHeight() {
        int result = 0;
        if (this.hasDifferingHeights) {
            int i = 0;
            while (i < this.items.size()) {
                GridItem item = this.items.get(i);
                if (item.isVisible()) {
                    result += item.getHeight();
                }
                ++i;
            }
        } else {
            result = this.currentVisibleItems * this.getItemHeight();
        }
        return result;
    }

    private int getVisibleGridHeight() {
        int headerHeight = this.columnHeadersVisible ? this.getHeaderHeight() : 0;
        int footerHeight = this.columnFootersVisible ? this.getFooterHeight() : 0;
        return this.getClientArea().height - headerHeight - footerHeight;
    }

    private static int getMaxInnerWidth(GridItem[] items, int index) {
        int maxInnerWidth = 0;
        int i = 0;
        while (i < items.length) {
            GridItem item = items[i];
            maxInnerWidth = Math.max(maxInnerWidth, item.getPreferredWidth(index));
            if (item.isExpanded()) {
                int innerWidth = Grid.getMaxInnerWidth(item.getItems(), index);
                maxInnerWidth = Math.max(maxInnerWidth, innerWidth);
            }
            ++i;
        }
        return maxInnerWidth;
    }

    private void internalSelect(int index) {
        if (this.isValidItemIndex(index)) {
            GridItem item = this.items.get(index);
            if (!this.cellSelectionEnabled && !this.selectedItems.contains((Object)item)) {
                this.selectedItems.add(item);
            }
        }
    }

    private void internalDeselect(int index) {
        if (this.isValidItemIndex(index)) {
            GridItem item = this.items.get(index);
            if (!this.cellSelectionEnabled && this.selectedItems.contains((Object)item)) {
                this.selectedItems.remove((Object)item);
            }
        }
    }

    private void internalDeselectAll() {
        if (!this.cellSelectionEnabled) {
            this.selectedItems.clear();
        }
    }

    private void updatePrimaryCheckColumn() {
        if ((this.getStyle() & 0x20) == 32) {
            boolean firstCol = true;
            for (GridColumn col : this.displayOrderedColumns) {
                col.setTableCheck(firstCol);
                firstCol = false;
            }
        }
    }

    private int computeItemHeight() {
        int result = Math.max(this.getItemImageSize().y, TextSizeUtil.getCharHeight((Font)this.getFont()));
        if (this.hasCheckBoxes()) {
            result = Math.max(this.getCheckBoxImageOuterSize().y, result);
        }
        result += this.getCellPadding().height;
        ++result;
        result = Math.max(result, 16);
        return result;
    }

    private int computeHeaderHeight() {
        int result = 0;
        this.groupHeaderHeight = 0;
        if (this.columnHeadersVisible) {
            int columnHeaderHeight = 0;
            int i = 0;
            while (i < this.getColumnCount()) {
                GridColumn column = this.columns.get(i);
                Font headerFont = column.getHeaderFont();
                String headerText = column.getText();
                Image headerImage = column.getImage();
                int computedHeight = this.computeColumnHeight(headerFont, headerText, headerImage, 0);
                columnHeaderHeight = Math.max(columnHeaderHeight, computedHeight);
                ++i;
            }
            i = 0;
            while (i < this.getColumnGroupCount()) {
                GridColumnGroup group = this.columnGroups.get(i);
                Font groupFont = group.getHeaderFont();
                String groupText = group.getText();
                Image groupImage = group.getImage();
                int chevronHeight = group.getChevronHeight();
                int computedHeight = this.computeColumnHeight(groupFont, groupText, groupImage, chevronHeight);
                this.groupHeaderHeight = Math.max(this.groupHeaderHeight, computedHeight);
                ++i;
            }
            result = columnHeaderHeight + this.groupHeaderHeight;
        }
        return result;
    }

    private int computeFooterHeight() {
        int result = 0;
        if (this.columnFootersVisible) {
            int columnFooterHeight = 0;
            int i = 0;
            while (i < this.getColumnCount()) {
                GridColumn column = this.columns.get(i);
                Font footerFont = column.getFooterFont();
                String footerText = column.getFooterText();
                Image footerImage = column.getFooterImage();
                int computedHeight = this.computeColumnHeight(footerFont, footerText, footerImage, 0);
                columnFooterHeight = Math.max(columnFooterHeight, computedHeight);
                ++i;
            }
            result = columnFooterHeight;
        }
        return result;
    }

    private int computeColumnHeight(Font font, String text, Image image, int minHeight) {
        int result = minHeight;
        int textHeight = 0;
        textHeight = text.contains("\n") ? TextSizeUtil.textExtent((Font)font, (String)text, (int)0).y : TextSizeUtil.getCharHeight((Font)font);
        result = Math.max(result, textHeight);
        int imageHeight = image == null ? 0 : image.getBounds().height;
        result = Math.max(result, imageHeight);
        result += this.getHeaderPadding().height;
        return result += this.getThemeAdapter().getHeaderBorderBottomWidth((Control)this);
    }

    private void repackColumns() {
        int i = 0;
        while (i < this.getColumnCount()) {
            this.columns.get(i).repack();
            ++i;
        }
    }

    private int getItemIndex(GridItem item) {
        int result = -1;
        GridItem parentItem = item.getParentItem();
        result = parentItem == null ? this.rootItems.indexOf((Object)item) : parentItem.indexOf(item);
        return result;
    }

    private int getColumnHeaderXPosition(GridColumn column) {
        int result = -1;
        if (column.isVisible()) {
            result = column.getLeft() - this.hScroll.getSelection();
        }
        return result;
    }

    private int getCellLeft(int index) {
        return this.getColumn(index).getLeft();
    }

    private int getCellWidth(int index) {
        GridColumn column = this.getColumn(index);
        return column.isVisible() ? column.getWidth() : 0;
    }

    private int getCheckBoxOffset(int index) {
        int result = -1;
        Rectangle padding = this.getCellPadding();
        if (this.isColumnCentered(index) && !this.isTreeColumn(index) && !this.hasColumnImages(index) && !this.hasColumnTexts(index)) {
            result = (this.getCellWidth(index) - this.getCheckBoxImageSize().x) / 2;
            result = Math.max(result, padding.x);
        }
        if (result == -1) {
            result = this.getCheckBoxMargin().x;
            if (!this.isTreeColumn(index)) {
                result += padding.x;
            }
        }
        return result;
    }

    private int getCheckBoxWidth(int index) {
        return this.getColumn(index).isCheck() ? this.getCheckBoxImageSize().x : 0;
    }

    private int getImageOffset(int index) {
        int result = 0;
        if (!this.isTreeColumn(index)) {
            result += this.getCellPadding().x;
        }
        if (this.getColumn(index).isCheck()) {
            result += this.getCheckBoxImageOuterSize().x;
        }
        return result;
    }

    private int getImageWidth(int index) {
        int result = 0;
        if (this.hasColumnImages(index)) {
            result = this.getItemImageSize().x;
            int availableWidth = this.getCellWidth(index);
            if (!this.isTreeColumn(index)) {
                result -= this.getCellPadding().x;
            }
            availableWidth = Math.max(0, availableWidth);
            result = Math.min(result, availableWidth);
        }
        return result;
    }

    private int getTextOffset(int index) {
        int result = this.getImageOffset(index);
        if (this.hasColumnImages(index)) {
            result += this.getItemImageSize().x;
            result += this.getCellSpacing();
        }
        return result;
    }

    private int getTextWidth(int index) {
        Rectangle padding = this.getCellPadding();
        int rightPadding = padding.width - padding.x;
        return Math.max(0, this.getCellWidth(index) - this.getTextOffset(index) - rightPadding);
    }

    Point getItemImageSize() {
        Point result = new Point(0, 0);
        if (this.itemImageSize != null) {
            result.x = this.itemImageSize.x;
            result.y = this.itemImageSize.y;
        }
        return result;
    }

    boolean hasColumnImages(int index) {
        return this.getColumn((int)index).imageCount > 0;
    }

    boolean hasColumnTexts(int index) {
        return this.getColumn((int)index).textCount > 0;
    }

    private boolean hasCheckBoxes() {
        boolean result = (this.getStyle() & 0x20) != 0;
        int i = 0;
        while (i < this.getColumnCount() && !result) {
            GridColumn column = this.columns.get(i);
            if (column.isCheck()) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    Point getCheckBoxImageOuterSize() {
        Point imageSize = this.getCheckBoxImageSize();
        Rectangle margin = this.getCheckBoxMargin();
        return new Point(imageSize.x + margin.width, imageSize.y + margin.height);
    }

    boolean isTreeColumn(int index) {
        boolean result = false;
        if (this.isTree) {
            int columnCount = this.getColumnCount();
            result = columnCount == 0 && index == 0 || columnCount > 0 && index == this.getColumnOrder()[0];
        }
        return result;
    }

    private boolean isColumnCentered(int index) {
        return this.getColumn(index).getAlignment() == 0x1000000;
    }

    private Point getCheckBoxImageSize() {
        if (!this.layoutCache.hasCheckBoxImageSize()) {
            this.layoutCache.checkBoxImageSize = this.getThemeAdapter().getCheckBoxImageSize((Control)this);
        }
        return this.layoutCache.checkBoxImageSize;
    }

    private Rectangle getCheckBoxMargin() {
        if (!this.layoutCache.hasCheckBoxMargin()) {
            this.layoutCache.checkBoxMargin = this.getThemeAdapter().getCheckBoxMargin((Control)this);
        }
        return this.layoutCache.checkBoxMargin;
    }

    Rectangle getCellPadding() {
        if (!this.layoutCache.hasCellPadding()) {
            this.layoutCache.cellPadding = this.getThemeAdapter().getCellPadding((Control)this);
        }
        return this.layoutCache.cellPadding;
    }

    Rectangle getHeaderPadding() {
        if (!this.layoutCache.hasHeaderPadding()) {
            this.layoutCache.headerPadding = this.getThemeAdapter().getHeaderPadding((Control)this);
        }
        return this.layoutCache.headerPadding;
    }

    int getIndentationWidth() {
        if (!this.layoutCache.hasIndentationWidth()) {
            this.layoutCache.indentationWidth = this.getThemeAdapter().getIndentationWidth((Control)this);
        }
        return this.layoutCache.indentationWidth;
    }

    int getCellSpacing() {
        if (!this.layoutCache.hasCellSpacing()) {
            this.layoutCache.cellSpacing = this.getThemeAdapter().getCellSpacing((Control)this);
        }
        return this.layoutCache.cellSpacing;
    }

    private GridThemeAdapter getThemeAdapter() {
        return (GridThemeAdapter)this.getAdapter(IThemeAdapter.class);
    }

    private static int checkStyle(int style) {
        int mask = 302517030;
        int result = style & mask;
        result |= 0x20000000;
        return result |= 0x10000;
    }

    private RowRange getRowRange(int start, int availableHeight, boolean forceEndCompletelyInside, boolean inverse) {
        RowRange result = new RowRange();
        int startIndex = start;
        if (startIndex == -1) {
            if (inverse) {
                startIndex = this.items.size();
            }
            while (this.isValidItemIndex(startIndex += inverse ? -1 : 1) && !this.items.get(startIndex).isVisible()) {
            }
            if (!this.isValidItemIndex(startIndex)) {
                result = null;
            }
        }
        if (result != null) {
            if (startIndex < 0 || startIndex >= this.items.size() || !this.items.get(startIndex).isVisible()) {
                SWT.error((int)5);
            }
            if (availableHeight <= 0) {
                result.startIndex = startIndex;
                result.endIndex = startIndex;
                result.rows = 0;
                result.height = 0;
            } else if (this.isTree || this.hasDifferingHeights) {
                int otherIndex = startIndex;
                int consumedItems = 0;
                int consumedHeight = 0;
                ++consumedItems;
                consumedHeight += this.items.get(otherIndex).getHeight();
                boolean abort = false;
                while (consumedHeight + 1 <= availableHeight && !abort) {
                    GridItem nextItem;
                    int nextIndex = otherIndex;
                    while ((nextItem = this.isValidItemIndex(nextIndex += inverse ? -1 : 1) ? this.items.get(nextIndex) : null) != null && !nextItem.isVisible()) {
                    }
                    if (nextItem == null || forceEndCompletelyInside && consumedHeight + nextItem.getHeight() > availableHeight) {
                        abort = true;
                        continue;
                    }
                    ++consumedItems;
                    consumedHeight += nextItem.getHeight();
                    otherIndex = nextIndex;
                }
                result.startIndex = !inverse ? startIndex : otherIndex;
                result.endIndex = !inverse ? otherIndex : startIndex;
                result.rows = consumedItems;
                result.height = consumedHeight;
            } else {
                int availableRows = availableHeight / this.getItemHeight();
                if (!forceEndCompletelyInside && availableRows * this.getItemHeight() < availableHeight) {
                    ++availableRows;
                }
                int otherIndex = startIndex + (availableRows - 1) * (inverse ? -1 : 1);
                otherIndex = Math.max(otherIndex, 0);
                otherIndex = Math.min(otherIndex, this.items.size() - 1);
                result.startIndex = !inverse ? startIndex : otherIndex;
                result.endIndex = !inverse ? otherIndex : startIndex;
                result.rows = result.endIndex - result.startIndex + 1;
                result.height = this.getItemHeight() * result.rows;
            }
        }
        return result;
    }

    private boolean isValidItemIndex(int index) {
        return index >= 0 && index < this.items.size();
    }

    private final class CellToolTipProvider
    implements ICellToolTipProvider,
    SerializableCompatibility {
        private CellToolTipProvider() {
        }

        public void getToolTipText(Item item, int columnIndex) {
            String toolTipText = ((GridItem)item).getToolTipText(columnIndex);
            Grid.this.getAdapter(ICellToolTipAdapter.class).setCellToolTipText(toolTipText);
        }
    }

    private final class CompositeItemHolder
    implements IItemHolderAdapter {
        private CompositeItemHolder() {
        }

        public void add(Item item) {
            throw new UnsupportedOperationException();
        }

        public void insert(Item item, int index) {
            throw new UnsupportedOperationException();
        }

        public void remove(Item item) {
            throw new UnsupportedOperationException();
        }

        public Item[] getItems() {
            GridItem[] items = Grid.this.getItems();
            GridColumn[] columns = Grid.this.getColumns();
            GridColumnGroup[] groups = Grid.this.getColumnGroups();
            Item[] result = new Item[columns.length + items.length + groups.length];
            System.arraycopy(groups, 0, result, 0, groups.length);
            System.arraycopy(columns, 0, result, groups.length, columns.length);
            System.arraycopy(items, 0, result, groups.length + columns.length, items.length);
            return result;
        }
    }

    private final class GridAdapter
    implements IGridAdapter,
    ICellToolTipAdapter,
    SerializableCompatibility {
        private String toolTipText;
        private ICellToolTipProvider provider;

        public GridAdapter() {
            this.provider = new CellToolTipProvider();
        }

        public void invalidateTopIndex() {
            Grid.this.invalidateTopBottomIndex();
        }

        public int getIndentationWidth() {
            return Grid.this.getIndentationWidth();
        }

        public int getCellLeft(int index) {
            return Grid.this.getCellLeft(index);
        }

        public int getCellWidth(int index) {
            return Grid.this.getCellWidth(index);
        }

        public int getCheckBoxOffset(int index) {
            return Grid.this.getCheckBoxOffset(index);
        }

        public int getCheckBoxWidth(int index) {
            return Grid.this.getCheckBoxWidth(index);
        }

        public int getImageOffset(int index) {
            return Grid.this.getImageOffset(index);
        }

        public int getImageWidth(int index) {
            return Grid.this.getImageWidth(index);
        }

        public int getTextOffset(int index) {
            return Grid.this.getTextOffset(index);
        }

        public int getTextWidth(int index) {
            return Grid.this.getTextWidth(index);
        }

        public int getItemIndex(GridItem item) {
            return Grid.this.getItemIndex(item);
        }

        public ICellToolTipProvider getCellToolTipProvider() {
            return this.provider;
        }

        public void setCellToolTipProvider(ICellToolTipProvider provider) {
            this.provider = provider;
        }

        public String getCellToolTipText() {
            return this.toolTipText;
        }

        public void setCellToolTipText(String toolTipText) {
            this.toolTipText = toolTipText;
        }

        public void doRedraw() {
            Grid.this.doRedraw();
        }
    }

    static final class LayoutCache
    implements SerializableCompatibility {
        private static final int UNKNOWN = -1;
        int headerHeight = -1;
        int footerHeight = -1;
        int itemHeight = -1;
        int cellSpacing = -1;
        int indentationWidth = -1;
        Rectangle cellPadding;
        Rectangle checkBoxMargin;
        Point checkBoxImageSize;
        Rectangle headerPadding;

        LayoutCache() {
        }

        public boolean hasHeaderPadding() {
            return this.headerPadding != null;
        }

        public void invalidateHeaderPadding() {
            this.headerPadding = null;
        }

        public boolean hasHeaderHeight() {
            return this.headerHeight != -1;
        }

        public void invalidateHeaderHeight() {
            this.headerHeight = -1;
        }

        public boolean hasFooterHeight() {
            return this.footerHeight != -1;
        }

        public void invalidateFooterHeight() {
            this.footerHeight = -1;
        }

        public boolean hasItemHeight() {
            return this.itemHeight != -1;
        }

        public void invalidateItemHeight() {
            this.itemHeight = -1;
        }

        public boolean hasCellSpacing() {
            return this.cellSpacing != -1;
        }

        public void invalidateCellSpacing() {
            this.cellSpacing = -1;
        }

        public boolean hasIndentationWidth() {
            return this.indentationWidth != -1;
        }

        public void invalidateIndentationWidth() {
            this.indentationWidth = -1;
        }

        public boolean hasCellPadding() {
            return this.cellPadding != null;
        }

        public void invalidateCellPadding() {
            this.cellPadding = null;
        }

        public boolean hasCheckBoxMargin() {
            return this.checkBoxMargin != null;
        }

        public void invalidateCheckBoxMargin() {
            this.checkBoxMargin = null;
        }

        public boolean hasCheckBoxImageSize() {
            return this.checkBoxImageSize != null;
        }

        public void invalidateCheckBoxImageSize() {
            this.checkBoxImageSize = null;
        }

        public void invalidateAll() {
            this.invalidateHeaderPadding();
            this.invalidateHeaderHeight();
            this.invalidateFooterHeight();
            this.invalidateItemHeight();
            this.invalidateCellSpacing();
            this.invalidateCellPadding();
            this.invalidateCheckBoxMargin();
            this.invalidateCheckBoxImageSize();
            this.invalidateIndentationWidth();
        }
    }

    private final class ResizeListener
    extends ControlAdapter {
        private ResizeListener() {
        }

        public void controlResized(ControlEvent event) {
            if (TextSizeUtil.isTemporaryResize()) {
                Grid.this.isTemporaryResize = true;
                Grid.this.layoutCache.invalidateHeaderHeight();
                Grid.this.layoutCache.invalidateFooterHeight();
                Grid.this.layoutCache.invalidateItemHeight();
            } else {
                if (Grid.this.isTemporaryResize) {
                    Grid.this.isTemporaryResize = false;
                    Grid.this.repackColumns();
                }
                Grid.this.invalidateTopBottomIndex();
                Grid.this.setScrollValuesObsolete();
            }
        }
    }

    private static class RowRange {
        public int startIndex;
        public int endIndex;
        public int rows;
        public int height;

        private RowRange() {
        }
    }
}

