/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.supplemental.fileupload.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadHandler;
import org.eclipse.rap.rwt.supplemental.fileupload.internal.FileUploadHandlerStore;
import org.eclipse.rap.rwt.supplemental.fileupload.internal.FileUploadProcessor;

public final class FileUploadServiceHandler
implements ServiceHandler {
    private static final String PARAMETER_TOKEN = "token";
    static final String SERVICE_HANDLER_ID = "org.eclipse.rap.fileupload";

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean hasSession;
        boolean bl = hasSession = request.getSession(false) != null;
        if (hasSession) {
            String token = request.getParameter(PARAMETER_TOKEN);
            FileUploadHandler registeredHandler = FileUploadHandlerStore.getInstance().getHandler(token);
            if (registeredHandler == null) {
                String message = "Invalid or missing token";
                response.sendError(403, message);
            } else if (!"POST".equals(request.getMethod().toUpperCase())) {
                String message = "Only POST requests allowed";
                response.sendError(405, message);
            } else if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                String message = "Content must be in multipart type";
                response.sendError(415, message);
            } else {
                FileUploadProcessor processor = new FileUploadProcessor(registeredHandler);
                processor.handleFileUpload(request, response);
            }
        }
    }

    public static String getUrl(String token) {
        StringBuffer url = new StringBuffer();
        url.append(RWT.getServiceManager().getServiceHandlerUrl(SERVICE_HANDLER_ID));
        url.append('&');
        url.append(PARAMETER_TOKEN).append('=').append(token);
        int relativeIndex = url.lastIndexOf("/");
        if (relativeIndex > -1) {
            url.delete(0, relativeIndex + 1);
        }
        return url.toString();
    }
}

