/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.util.ArrayList;
import org.apache.coyote.RequestInfo;

public class RequestGroupInfo {
    ArrayList<RequestInfo> processors = new ArrayList();
    private long deadMaxTime = 0L;
    private long deadProcessingTime = 0L;
    private int deadRequestCount = 0;
    private int deadErrorCount = 0;
    private long deadBytesReceived = 0L;
    private long deadBytesSent = 0L;

    public synchronized void addRequestProcessor(RequestInfo rp) {
        this.processors.add(rp);
    }

    public synchronized void removeRequestProcessor(RequestInfo rp) {
        if (rp != null) {
            if (this.deadMaxTime < rp.getMaxTime()) {
                this.deadMaxTime = rp.getMaxTime();
            }
            this.deadProcessingTime += rp.getProcessingTime();
            this.deadRequestCount += rp.getRequestCount();
            this.deadErrorCount += rp.getErrorCount();
            this.deadBytesReceived += rp.getBytesReceived();
            this.deadBytesSent += rp.getBytesSent();
            this.processors.remove(rp);
        }
    }

    public synchronized long getMaxTime() {
        long maxTime = this.deadMaxTime;
        int i = 0;
        while (i < this.processors.size()) {
            RequestInfo rp = this.processors.get(i);
            if (maxTime < rp.getMaxTime()) {
                maxTime = rp.getMaxTime();
            }
            ++i;
        }
        return maxTime;
    }

    public synchronized void setMaxTime(long maxTime) {
        this.deadMaxTime = maxTime;
        int i = 0;
        while (i < this.processors.size()) {
            RequestInfo rp = this.processors.get(i);
            rp.setMaxTime(maxTime);
            ++i;
        }
    }

    public synchronized long getProcessingTime() {
        long time = this.deadProcessingTime;
        int i = 0;
        while (i < this.processors.size()) {
            RequestInfo rp = this.processors.get(i);
            time += rp.getProcessingTime();
            ++i;
        }
        return time;
    }

    public synchronized void setProcessingTime(long totalTime) {
        this.deadProcessingTime = totalTime;
        int i = 0;
        while (i < this.processors.size()) {
            RequestInfo rp = this.processors.get(i);
            rp.setProcessingTime(totalTime);
            ++i;
        }
    }

    public synchronized int getRequestCount() {
        int requestCount = this.deadRequestCount;
        int i = 0;
        while (i < this.processors.size()) {
            RequestInfo rp = this.processors.get(i);
            requestCount += rp.getRequestCount();
            ++i;
        }
        return requestCount;
    }

    public synchronized void setRequestCount(int requestCount) {
        this.deadRequestCount = requestCount;
        int i = 0;
        while (i < this.processors.size()) {
            RequestInfo rp = this.processors.get(i);
            rp.setRequestCount(requestCount);
            ++i;
        }
    }

    public synchronized int getErrorCount() {
        int requestCount = this.deadErrorCount;
        int i = 0;
        while (i < this.processors.size()) {
            RequestInfo rp = this.processors.get(i);
            requestCount += rp.getErrorCount();
            ++i;
        }
        return requestCount;
    }

    public synchronized void setErrorCount(int errorCount) {
        this.deadErrorCount = errorCount;
        int i = 0;
        while (i < this.processors.size()) {
            RequestInfo rp = this.processors.get(i);
            rp.setErrorCount(errorCount);
            ++i;
        }
    }

    public synchronized long getBytesReceived() {
        long bytes = this.deadBytesReceived;
        int i = 0;
        while (i < this.processors.size()) {
            RequestInfo rp = this.processors.get(i);
            bytes += rp.getBytesReceived();
            ++i;
        }
        return bytes;
    }

    public synchronized void setBytesReceived(long bytesReceived) {
        this.deadBytesReceived = bytesReceived;
        int i = 0;
        while (i < this.processors.size()) {
            RequestInfo rp = this.processors.get(i);
            rp.setBytesReceived(bytesReceived);
            ++i;
        }
    }

    public synchronized long getBytesSent() {
        long bytes = this.deadBytesSent;
        int i = 0;
        while (i < this.processors.size()) {
            RequestInfo rp = this.processors.get(i);
            bytes += rp.getBytesSent();
            ++i;
        }
        return bytes;
    }

    public synchronized void setBytesSent(long bytesSent) {
        this.deadBytesSent = bytesSent;
        int i = 0;
        while (i < this.processors.size()) {
            RequestInfo rp = this.processors.get(i);
            rp.setBytesSent(bytesSent);
            ++i;
        }
    }

    public void resetCounters() {
        this.setBytesReceived(0L);
        this.setBytesSent(0L);
        this.setRequestCount(0);
        this.setProcessingTime(0L);
        this.setMaxTime(0L);
        this.setErrorCount(0);
    }
}

