/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.jmx;

import javax.management.DynamicMBean;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.ha.authenticator.ClusterSingleSignOn;
import org.apache.catalina.ha.deploy.FarmWarDeployer;
import org.apache.catalina.ha.session.DeltaManager;
import org.apache.catalina.ha.tcp.SimpleTcpCluster;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;

public class ClusterJmxHelper {
    protected static Registry registry = Registry.getRegistry(null, null);
    private static final Log log = LogFactory.getLog(ClusterJmxHelper.class);
    protected static boolean jmxEnabled = true;
    protected static MBeanServer mbeanServer = null;

    public static Registry getRegistry() {
        return registry;
    }

    public static MBeanServer getMBeanServer() throws Exception {
        if (mbeanServer == null) {
            mbeanServer = MBeanServerFactory.findMBeanServer(null).size() > 0 ? MBeanServerFactory.findMBeanServer(null).get(0) : MBeanServerFactory.createMBeanServer();
        }
        return mbeanServer;
    }

    protected static boolean initMetaData(Class<?> clazz) {
        block3: {
            try {
                if (clazz != null) break block3;
                return false;
            }
            catch (Exception exception) {
                log.warn("Unable to load meta data for class:" + clazz.getName());
                return false;
            }
        }
        ClusterJmxHelper.getRegistry().loadMetadata(clazz.getResourceAsStream("mbeans-descriptors.xml"));
        return true;
    }

    public static DynamicMBean getManagedBean(Object object) throws Exception {
        DynamicMBean mbean = null;
        if (ClusterJmxHelper.getRegistry() != null) {
            ManagedBean managedBean = registry.findManagedBean(object.getClass().getName());
            mbean = managedBean.createMBean(object);
        }
        return mbean;
    }

    protected static void initDefaultCluster() {
        ClusterJmxHelper.initMetaData(SimpleTcpCluster.class);
        ClusterJmxHelper.initMetaData(DeltaManager.class);
        ClusterJmxHelper.initMetaData(FarmWarDeployer.class);
        ClusterJmxHelper.initMetaData(ClusterSingleSignOn.class);
    }

    public static boolean registerDefaultCluster(SimpleTcpCluster cluster) {
        try {
            ClusterJmxHelper.initDefaultCluster();
            ObjectName clusterName = ClusterJmxHelper.getDefaultClusterName(cluster);
            if (!ClusterJmxHelper.getMBeanServer().isRegistered(clusterName)) {
                ClusterJmxHelper.getMBeanServer().registerMBean(ClusterJmxHelper.getManagedBean(cluster), clusterName);
            }
            return true;
        }
        catch (Exception x) {
            log.warn("Unable to register default cluster implementation with JMX", x);
            return false;
        }
    }

    public static boolean unregisterDefaultCluster(SimpleTcpCluster cluster) {
        try {
            ObjectName clusterName = ClusterJmxHelper.getDefaultClusterName(cluster);
            if (ClusterJmxHelper.getMBeanServer().isRegistered(clusterName)) {
                ClusterJmxHelper.getMBeanServer().unregisterMBean(clusterName);
            }
            return true;
        }
        catch (Exception x) {
            log.warn("Unable to unregister default cluster implementation with JMX", x);
            return false;
        }
    }

    private static ObjectName getDefaultClusterName(SimpleTcpCluster cluster) throws Exception {
        String domain = ClusterJmxHelper.getMBeanServer().getDefaultDomain();
        String type = ":type=";
        String clusterType = String.valueOf(type) + "Cluster";
        if (cluster.getContainer() instanceof StandardHost) {
            domain = ((StandardHost)cluster.getContainer()).getDomain();
            clusterType = String.valueOf(clusterType) + ",host=" + cluster.getContainer().getName();
        } else if (cluster.getContainer() instanceof StandardEngine) {
            domain = ((StandardEngine)cluster.getContainer()).getDomain();
        }
        ObjectName clusterName = new ObjectName(String.valueOf(domain) + clusterType);
        return clusterName;
    }
}

