/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.customizer;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.rap.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.rap.http.servlet.internal.context.ContextController;
import org.eclipse.rap.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.rap.http.servlet.internal.error.HttpWhiteboardFailureException;
import org.eclipse.rap.http.servlet.internal.registration.ResourceRegistration;
import org.eclipse.rap.http.servlet.internal.util.StringPlus;
import org.eclipse.rap.service.servlet.internal.runtime.dto.FailedResourceDTO;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ContextResourceTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<Object, ResourceRegistration> {
    public ContextResourceTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime, contextController);
    }

    public AtomicReference<ResourceRegistration> addingService(ServiceReference<Object> serviceReference) {
        AtomicReference<ResourceRegistration> result = new AtomicReference<ResourceRegistration>();
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return result;
        }
        try {
            this.contextController.checkShutdown();
            if (!this.contextController.matches(serviceReference)) {
                if (this.httpServiceRuntime.isDefaultContext(this.contextController) && !this.httpServiceRuntime.matchesAnyContext(serviceReference)) {
                    throw new HttpWhiteboardFailureException("Doesn't match any contexts. " + serviceReference, 1);
                }
                AtomicReference<ResourceRegistration> atomicReference = result;
                return atomicReference;
            }
            try {
                if (this.contextController.isLegacyContext() && serviceReference.getProperty("equinox.legacy.tccl") == null && serviceReference.getProperty("osgi.http.whiteboard.context.select") != null && ((String)serviceReference.getProperty("osgi.http.whiteboard.context.select")).contains("osgi.http.whiteboard.context.httpservice".concat("="))) {
                    throw new HttpWhiteboardFailureException("Whiteboard resources cannot bind to legacy contexts. " + serviceReference, 1);
                }
                this.httpServiceRuntime.removeFailedResourceDTO(serviceReference);
                result.set(this.contextController.addResourceRegistration(serviceReference));
            }
            catch (HttpWhiteboardFailureException hwfe) {
                this.httpServiceRuntime.debug(hwfe.getMessage(), hwfe);
                this.recordFailed(serviceReference, hwfe.getFailureReason());
            }
            catch (Throwable t) {
                this.httpServiceRuntime.error(t.getMessage(), t);
                this.recordFailed(serviceReference, 4);
            }
        }
        finally {
            this.httpServiceRuntime.incrementServiceChangecount();
        }
        return result;
    }

    @Override
    void removeFailed(ServiceReference<Object> serviceReference) {
        this.contextController.getHttpServiceRuntime().removeFailedResourceDTO(serviceReference);
    }

    private void recordFailed(ServiceReference<Object> serviceReference, int failureReason) {
        FailedResourceDTO failedResourceDTO = new FailedResourceDTO();
        failedResourceDTO.failureReason = failureReason;
        failedResourceDTO.patterns = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.resource.pattern")).toArray(new String[0]);
        failedResourceDTO.prefix = String.valueOf(serviceReference.getProperty("osgi.http.whiteboard.resource.prefix"));
        failedResourceDTO.serviceId = (Long)serviceReference.getProperty("service.id");
        failedResourceDTO.servletContextId = this.contextController.getServiceId();
        this.contextController.getHttpServiceRuntime().recordFailedResourceDTO(serviceReference, failedResourceDTO);
    }
}

