/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.registration;

import org.eclipse.rap.http.servlet.internal.registration.Registration;
import org.eclipse.rap.http.servlet.internal.servlet.Match;
import org.osgi.dto.DTO;

public abstract class MatchableRegistration<T, D extends DTO>
extends Registration<T, D> {
    public MatchableRegistration(T t, D d) {
        super(t, d);
    }

    public abstract String match(String var1, String var2, String var3, String var4, Match var5);

    private boolean isPathWildcardMatch(String pattern, String servletPath) {
        int cpl = pattern.length() - 2;
        if (pattern.endsWith("/*") && servletPath.regionMatches(0, pattern, 0, cpl)) {
            if (pattern.length() > 2 && !pattern.startsWith(servletPath)) {
                return false;
            }
            if (servletPath.length() == cpl) {
                return true;
            }
        }
        return false;
    }

    protected final boolean doMatch(String pattern, String servletPath, String pathInfo, String extension, Match match) throws IllegalArgumentException {
        if (match == Match.EXACT) {
            return pattern.equals(servletPath);
        }
        if (match == Match.CONTEXT_ROOT && "".equals(pattern)) {
            return "".equals(servletPath) && "/".equals(pathInfo);
        }
        if (match == Match.DEFAULT_SERVLET && "/".equals(pattern)) {
            return !servletPath.isEmpty() && pathInfo == null;
        }
        if (pattern.indexOf("/*.") == 0) {
            pattern = pattern.substring(1);
        }
        if (!pattern.isEmpty() && pattern.charAt(0) == '/') {
            if (match == Match.DEFAULT_SERVLET && pattern.length() == 1) {
                return true;
            }
            if (match == Match.REGEX && this.isPathWildcardMatch(pattern, servletPath)) {
                return true;
            }
        }
        if (match == Match.EXTENSION) {
            int index = pattern.lastIndexOf("*.");
            String patterPrefix = "";
            if (index > 0) {
                patterPrefix = pattern.substring(0, index - 1);
            }
            if (index != -1 && servletPath.equals(patterPrefix)) {
                return pattern.endsWith("." + extension);
            }
        }
        return false;
    }
}

