/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.quickaccess.QuickAccessElement;

class PreviousPicksProvider
extends QuickAccessProvider {
    LinkedList<QuickAccessElement> elements;
    private int maxNumberOfElements;
    private Supplier<List<QuickAccessElement>> initializer;
    private Collection<QuickAccessProvider> initialProviders;

    PreviousPicksProvider(int maxNumberOfElements) {
        this.maxNumberOfElements = maxNumberOfElements;
    }

    public void setElementsInitializer(Supplier<List<QuickAccessElement>> initializer) {
        this.initializer = initializer;
    }

    public void setInvolvedProviders(Collection<QuickAccessProvider> providers) {
        this.initialProviders = providers;
    }

    @Override
    public QuickAccessElement findElement(String id, String filterText) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuickAccessElement[] getElements() {
        PreviousPicksProvider previousPicksProvider = this;
        synchronized (previousPicksProvider) {
            if (this.elements == null) {
                this.elements = new LinkedList();
                if (this.initializer != null) {
                    this.elements.addAll((Collection<QuickAccessElement>)this.initializer.get());
                }
            }
        }
        return (QuickAccessElement[])this.elements.stream().filter(Objects::nonNull).toArray(QuickAccessElement[]::new);
    }

    @Override
    public QuickAccessElement[] getElementsSorted(String filter, IProgressMonitor monitor) {
        return this.getElements();
    }

    @Override
    public String getId() {
        return "org.eclipse.ui.previousPicks";
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.get().QuickAccess_Previous;
    }

    @Override
    protected void doReset() {
    }

    public void addPreviousPick(QuickAccessElement element, Consumer<QuickAccessElement> onRemoveElement) {
        this.elements.remove(element);
        if (this.elements.size() == this.maxNumberOfElements) {
            QuickAccessElement removedElement = this.elements.removeLast();
            if (onRemoveElement != null) {
                onRemoveElement.accept(removedElement);
            }
        }
        this.elements.addFirst(element);
    }

    public void removeElement(QuickAccessElement removedElement) {
        if (this.elements != null) {
            this.elements.remove(removedElement);
        }
    }

    @Override
    public boolean requiresUiAccess() {
        if (this.initialProviders == null) {
            return false;
        }
        return this.initialProviders.stream().anyMatch(QuickAccessProvider::requiresUiAccess);
    }
}

