/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

public interface Invocable {
    public static final ThreadLocal<Boolean> __nonBlocking = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public static boolean isNonBlockingInvocation() {
        return __nonBlocking.get();
    }

    public static void invokeNonBlocking(Runnable task) {
        Boolean was_non_blocking = __nonBlocking.get();
        try {
            __nonBlocking.set(Boolean.TRUE);
            task.run();
        }
        finally {
            __nonBlocking.set(was_non_blocking);
        }
    }

    public static void invokePreferNonBlocking(Runnable task) {
        switch (Invocable.getInvocationType(task)) {
            case BLOCKING: 
            case NON_BLOCKING: {
                task.run();
                break;
            }
            case EITHER: {
                Invocable.invokeNonBlocking(task);
            }
        }
    }

    public static void invokePreferred(Runnable task, InvocationType preferredInvocationType) {
        switch (Invocable.getInvocationType(task)) {
            case BLOCKING: 
            case NON_BLOCKING: {
                task.run();
                break;
            }
            case EITHER: {
                if (Invocable.getInvocationType(task) == InvocationType.EITHER && preferredInvocationType == InvocationType.NON_BLOCKING) {
                    Invocable.invokeNonBlocking(task);
                    break;
                }
                task.run();
            }
        }
    }

    public static Runnable asPreferred(Runnable task, InvocationType preferredInvocationType) {
        switch (Invocable.getInvocationType(task)) {
            case BLOCKING: 
            case NON_BLOCKING: {
                break;
            }
            case EITHER: {
                if (preferredInvocationType != InvocationType.NON_BLOCKING) break;
                return () -> Invocable.invokeNonBlocking(task);
            }
        }
        return task;
    }

    public static InvocationType getInvocationType(Object o) {
        if (o instanceof Invocable) {
            return ((Invocable)o).getInvocationType();
        }
        return InvocationType.BLOCKING;
    }

    default public InvocationType getInvocationType() {
        return InvocationType.BLOCKING;
    }

    public static enum InvocationType {
        BLOCKING,
        NON_BLOCKING,
        EITHER;

    }
}

