/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.keys.KeyBindingDispatcher;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class KeyAssistDialog
extends PopupDialog {
    private static final long serialVersionUID = 1L;
    private static final String BINDING_KEY = "Binding.bindings.jface.eclipse.org";
    private static final int NO_REMEMBERED_WIDTH = -1;
    private List<Binding> bindings = new ArrayList<Binding>();
    private Table completionsTable = null;
    private int previousWidth = -1;
    private KeyBindingDispatcher workbenchKeyboard;
    private Collection<Binding> matches;
    private IEclipseContext context;

    public KeyAssistDialog(IEclipseContext context, KeyBindingDispatcher associatedKeyboard) {
        super(null, 4, true, false, false, false, null, null);
        this.context = context;
        this.workbenchKeyboard = associatedKeyboard;
    }

    public void clearRememberedState() {
        this.previousWidth = -1;
    }

    public boolean close() {
        return this.close(false);
    }

    public boolean close(boolean rememberState) {
        return this.close(rememberState, true);
    }

    private boolean close(boolean rememberState, boolean resetState) {
        Shell shell = this.getShell();
        if (rememberState) {
            int widthToRemember = shell != null && !shell.isDisposed() ? this.getShell().getSize().x : -1;
            this.previousWidth = widthToRemember;
            this.completionsTable = null;
        }
        this.matches = null;
        boolean popupClosed = super.close();
        if (resetState) {
            this.workbenchKeyboard.resetState();
        }
        return popupClosed;
    }

    private void configureLocation(Point size) {
        int yCoord;
        int xCoord;
        Shell shell = this.getShell();
        Shell workbenchWindowShell = (Shell)shell.getParent();
        if (workbenchWindowShell != null) {
            Rectangle workbenchWindowBounds = workbenchWindowShell.getBounds();
            xCoord = workbenchWindowBounds.x + workbenchWindowBounds.width - size.x - 10;
            yCoord = workbenchWindowBounds.y + workbenchWindowBounds.height - size.y - 10;
        } else {
            xCoord = 0;
            yCoord = 0;
        }
        Rectangle bounds = new Rectangle(xCoord, yCoord, size.x, size.y);
        shell.setBounds(this.getConstrainedShellBounds(bounds));
    }

    private Point configureSize() {
        Shell workbenchWindowShell;
        Shell shell = this.getShell();
        shell.pack();
        Point size = shell.getSize();
        if (this.previousWidth != -1 && this.previousWidth > size.x) {
            size.x = this.previousWidth;
        }
        if ((workbenchWindowShell = (Shell)shell.getParent()) != null) {
            Point workbenchWindowSize = workbenchWindowShell.getSize();
            int maxWidth = workbenchWindowSize.x * 2 / 5;
            int maxHeight = workbenchWindowSize.y / 2;
            if (size.x > maxWidth) {
                size.x = maxWidth;
            }
            if (size.y > maxHeight) {
                size.y = maxHeight;
            }
        }
        shell.setSize(size);
        return size;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setBackground(parent.getBackground());
        Collection<Binding> bindings = this.matches != null ? this.matches : this.getActiveBindings();
        if (bindings == null || bindings.isEmpty()) {
            this.createEmptyDialogArea(composite);
        } else {
            this.createTableDialogArea(composite, bindings);
        }
        return composite;
    }

    private void createEmptyDialogArea(Composite parent) {
        Label noMatchesLabel = new Label(parent, 0);
        noMatchesLabel.setText("No matches");
        noMatchesLabel.setLayoutData((Object)new GridData(1808));
        noMatchesLabel.setBackground(parent.getBackground());
    }

    private void createTableDialogArea(Composite parent, Collection<Binding> partialMatches) {
        this.completionsTable = new Table(parent, 65540);
        GridData gridData = new GridData(1808);
        this.completionsTable.setLayoutData((Object)gridData);
        this.completionsTable.setBackground(parent.getBackground());
        this.completionsTable.setLinesVisible(true);
        this.bindings.clear();
        TableColumn columnCommandName = new TableColumn(this.completionsTable, 16384, 0);
        TableColumn columnKeySequence = new TableColumn(this.completionsTable, 16384, 1);
        for (Binding binding : partialMatches) {
            String sequence = binding.getTriggerSequence().format();
            ParameterizedCommand command = binding.getParameterizedCommand();
            try {
                String[] text = new String[]{command.getName(), sequence};
                TableItem item = new TableItem(this.completionsTable, 0);
                item.setText(text);
                item.setData(BINDING_KEY, (Object)binding);
                this.bindings.add(binding);
            }
            catch (NotDefinedException notDefinedException) {}
        }
        Dialog.applyDialogFont((Control)parent);
        columnKeySequence.pack();
        if (this.previousWidth != -1) {
            columnKeySequence.setWidth(this.previousWidth);
        }
        columnCommandName.pack();
        if (this.completionsTable.getItems().length > 0) {
            this.completionsTable.setSelection(0);
        }
        this.completionsTable.addListener(14, new Listener(){
            private static final long serialVersionUID = 1L;

            public void handleEvent(Event event) {
                KeyAssistDialog.this.executeKeyBinding(event);
            }
        });
    }

    private void executeKeyBinding(Event trigger) {
        int selectionIndex = this.completionsTable.getSelectionIndex();
        if (selectionIndex >= 0) {
            this.close();
            Binding binding = this.bindings.get(selectionIndex);
            try {
                this.workbenchKeyboard.executeCommand(binding.getParameterizedCommand(), trigger);
            }
            catch (CommandException e) {
                System.err.println(String.valueOf(binding.getParameterizedCommand().toString()) + " : " + (Object)((Object)e));
            }
        }
    }

    private Collection<Binding> getActiveBindings() {
        EBindingService bindingService = (EBindingService)this.context.getActiveLeaf().get(EBindingService.class);
        Collection<Binding> activeBindings = bindingService.getActiveBindings();
        Collection<Binding> conflictBindings = bindingService.getAllConflicts();
        TreeSet<Binding> sortedMatches = new TreeSet<Binding>(new Comparator<Binding>(){

            @Override
            public int compare(Binding binding1, Binding binding2) {
                ParameterizedCommand cmdA = binding1.getParameterizedCommand();
                ParameterizedCommand cmdB = binding2.getParameterizedCommand();
                int result = 0;
                try {
                    result = cmdA.getName().compareTo(cmdB.getName());
                }
                catch (NotDefinedException notDefinedException) {}
                return result;
            }
        });
        if (activeBindings != null) {
            for (Binding binding : activeBindings) {
                Collection<Binding> matchesForCommand = bindingService.getBindingsFor(binding.getParameterizedCommand());
                if (matchesForCommand != null && matchesForCommand.size() > 1) {
                    Binding bindingToAdd2 = null;
                    for (Binding bindingToAdd2 : matchesForCommand) {
                        if (bindingToAdd2.getSchemeId().equals("org.eclipse.ui.defaultAcceleratorConfiguration")) continue;
                        sortedMatches.add(bindingToAdd2);
                        break;
                    }
                    if (bindingToAdd2 == null) continue;
                    sortedMatches.add(bindingToAdd2);
                    continue;
                }
                if (matchesForCommand == null || matchesForCommand.size() != 1) continue;
                sortedMatches.addAll(matchesForCommand);
            }
        }
        if (conflictBindings != null) {
            for (Binding binding : conflictBindings) {
                sortedMatches.add(binding);
            }
        }
        return sortedMatches;
    }

    public int open() {
        Shell shell = this.getShell();
        if (shell != null) {
            this.close(false, false);
            return 0;
        }
        this.create();
        this.getShell().setData("org.eclipse.e4.ui.ignoreDialog", (Object)Boolean.TRUE);
        Point size = this.configureSize();
        this.configureLocation(size);
        return super.open();
    }

    public int open(Collection<Binding> bindings) {
        this.matches = new TreeSet<Binding>(new Comparator<Binding>(){

            @Override
            public int compare(Binding a, Binding b) {
                Binding bindingA = a;
                Binding bindingB = b;
                ParameterizedCommand commandA = bindingA.getParameterizedCommand();
                ParameterizedCommand commandB = bindingB.getParameterizedCommand();
                try {
                    return commandA.getName().compareTo(commandB.getName());
                }
                catch (NotDefinedException notDefinedException) {
                    return 0;
                }
            }
        });
        this.matches.addAll(bindings);
        Shell shell = this.getShell();
        if (shell != null) {
            this.close(false, false);
            return 0;
        }
        this.create();
        this.getShell().setData("org.eclipse.e4.ui.ignoreDialog", (Object)Boolean.TRUE);
        Point size = this.configureSize();
        this.configureLocation(size);
        return super.open();
    }

    public void setParentShell(Shell newParentShell) {
        super.setParentShell(newParentShell);
    }

    protected Binding getSelectedBinding() {
        int selectedIndex;
        if (this.completionsTable != null && !this.completionsTable.isDisposed() && (selectedIndex = this.completionsTable.getSelectionIndex()) != -1) {
            TableItem selectedItem = this.completionsTable.getItem(selectedIndex);
            return (Binding)selectedItem.getData(BINDING_KEY);
        }
        return null;
    }
}

