/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;

class Timestamp {
    private final DateTimeFormatter tzFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final ZoneId zoneId;
    private volatile Tick tick;

    public Timestamp(TimeZone timeZone) {
        this.zoneId = timeZone.toZoneId();
        this.tzFormatter.withZone(this.zoneId);
        this.tick = null;
    }

    public void formatNow(long now, StringBuilder builder) {
        long seconds = now / 1000L;
        int ms = (int)(now % 1000L);
        Tick tick = this.tick;
        if (tick != null && tick.seconds == seconds) {
            builder.append(tick.formattedString);
        } else {
            this.formatTick(now, builder);
        }
        if (ms > 99) {
            builder.append('.');
        } else if (ms > 9) {
            builder.append(".0");
        } else {
            builder.append(".00");
        }
        builder.append(ms);
    }

    protected void formatTick(long now, StringBuilder builder) {
        long seconds = now / 1000L;
        Tick tick = this.tick;
        if (tick == null || tick.seconds != seconds) {
            String s = ZonedDateTime.ofInstant(Instant.ofEpochMilli(now), this.zoneId).format(this.tzFormatter);
            builder.append(s);
            this.tick = new Tick(seconds, s);
        }
    }

    public static class Tick {
        private final long seconds;
        private final String formattedString;

        public Tick(long seconds, String string) {
            this.seconds = seconds;
            this.formattedString = string;
        }
    }
}

