/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.util.PrefUtil;

public class DynamicHelpAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;

    public DynamicHelpAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public DynamicHelpAction(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setActionDefinitionId("org.eclipse.ui.help.dynamicHelp");
        String overrideText = PrefUtil.getAPIPreferenceStore().getString("dynamicHelpActionText");
        if ("".equals(overrideText)) {
            this.setText(this.appendAccelerator(WorkbenchMessages.get().DynamicHelpAction_text));
            this.setToolTipText(WorkbenchMessages.get().DynamicHelpAction_toolTip);
        } else {
            this.setText(this.appendAccelerator(overrideText));
            this.setToolTipText(Action.removeMnemonics((String)overrideText));
        }
        window.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.rap.ui.dynamic_help_action_context");
    }

    private String appendAccelerator(String text) {
        return text;
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                DynamicHelpAction.this.workbenchWindow.getWorkbench().getHelpSystem().displayDynamicHelp();
            }
        });
    }

    @Override
    public void dispose() {
        this.workbenchWindow = null;
    }
}

