/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.rap.fileupload.DiskFileUploadReceiver;
import org.eclipse.rap.fileupload.FileUploadHandler;
import org.eclipse.rap.fileupload.FileUploadReceiver;
import org.eclipse.rap.rwt.client.ClientFile;
import org.eclipse.rap.rwt.dnd.ClientFileTransfer;
import org.eclipse.rap.rwt.internal.RWTMessages;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.rap.rwt.widgets.FileUpload;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.FileUploadRunnable;
import org.eclipse.swt.internal.widgets.LayoutUtil;
import org.eclipse.swt.internal.widgets.ProgressCollector;
import org.eclipse.swt.internal.widgets.UploadPanel;
import org.eclipse.swt.internal.widgets.UploaderService;
import org.eclipse.swt.internal.widgets.UploaderWidget;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final ServerPushSession pushSession;
    private ThreadPoolExecutor singleThreadExecutor;
    private Display display;
    private ScrolledComposite uploadsScroller;
    private Button okButton;
    private Label spacer;
    private UploadPanel placeHolder;
    private ProgressCollector progressCollector;
    private ClientFile[] clientFiles;
    private String[] filterExtensions;
    private long sizeLimit = -1L;
    private long timeLimit = -1L;
    private File uploadDirectory;

    public FileDialog(Shell parent) {
        this(parent, 67616);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, FileDialog.checkStyle(parent, style));
        this.checkSubclass();
        this.pushSession = new ServerPushSession();
    }

    public String getFileName() {
        String[] fileNames = this.getFileNames();
        return fileNames.length == 0 ? "" : fileNames[0];
    }

    public String[] getFileNames() {
        if (this.returnCode == 32) {
            String[] completedFileNames = this.getCompletedFileNames();
            if (this.isMulti() || completedFileNames.length == 0) {
                return completedFileNames;
            }
            return new String[]{completedFileNames[completedFileNames.length - 1]};
        }
        return EMPTY_ARRAY;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setClientFiles(ClientFile[] files) {
        this.clientFiles = files;
    }

    public void setUploadSizeLimit(long limit) {
        this.sizeLimit = limit;
    }

    public long getUploadSizeLimit() {
        return this.sizeLimit;
    }

    public void setUploadDirectory(File directory) {
        this.uploadDirectory = directory;
    }

    public File getUploadDirectory() {
        return this.uploadDirectory;
    }

    public void setUploadTimeLimit(long limit) {
        this.timeLimit = limit;
    }

    public long getUploadTimeLimit() {
        return this.timeLimit;
    }

    public List<Exception> getExceptions() {
        return this.progressCollector.getUploadExceptions();
    }

    public String open() {
        this.checkOperationMode();
        this.prepareOpen();
        this.runEventLoop(this.shell);
        String fileName = this.getFileName();
        return this.returnCode == 256 || "".equals(fileName) ? null : fileName;
    }

    protected void prepareOpen() {
        this.createShell();
        this.createControls();
        this.initializeBounds();
        this.initializeDefaults();
        this.pushSession.start();
        this.singleThreadExecutor = this.createSingleThreadExecutor();
        if (this.clientFiles != null && this.clientFiles.length > 0) {
            this.handleFileDrop(this.clientFiles);
        }
    }

    private void createShell() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setText(this.getText());
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                FileDialog.this.cleanup();
            }
        });
        this.display = this.shell.getDisplay();
    }

    private void initializeBounds() {
        Point prefSize = this.shell.computeSize(-1, -1);
        prefSize.y = prefSize.y + (this.isMulti() ? 165 : 10);
        this.shell.setMinimumSize(prefSize);
        Rectangle displaySize = this.getParent().getDisplay().getBounds();
        int locationX = (displaySize.width - prefSize.x) / 2 + displaySize.x;
        int locationY = (displaySize.height - prefSize.y) / 2 + displaySize.y;
        this.shell.setBounds(locationX, locationY, prefSize.x, prefSize.y);
        this.spacer.setLayoutData((Object)LayoutUtil.createHorizontalFillData());
    }

    private void initializeDefaults() {
        this.setReturnCode(256);
    }

    private void createControls() {
        this.shell.setLayout((Layout)LayoutUtil.createGridLayout(1, 10, 10));
        this.createDialogArea((Composite)this.shell);
        this.createButtonsArea((Composite)this.shell);
    }

    private void createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        dialogArea.setLayoutData((Object)LayoutUtil.createFillData());
        dialogArea.setLayout((Layout)LayoutUtil.createGridLayout(1, 0, 5));
        this.createUploadsArea(dialogArea);
        this.createProgressArea(dialogArea);
        this.createDropTarget((Control)dialogArea);
    }

    private void createUploadsArea(Composite parent) {
        this.uploadsScroller = new ScrolledComposite(parent, this.isMulti() ? 512 : 0);
        this.uploadsScroller.setLayoutData((Object)LayoutUtil.createFillData());
        this.uploadsScroller.setExpandHorizontal(true);
        this.uploadsScroller.setExpandVertical(true);
        Composite scrolledContent = new Composite((Composite)this.uploadsScroller, 0);
        scrolledContent.setLayout((Layout)new GridLayout(1, false));
        this.uploadsScroller.setContent((Control)scrolledContent);
        this.uploadsScroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                FileDialog.this.updateScrolledComposite();
            }
        });
        this.placeHolder = this.createPlaceHolder(scrolledContent);
    }

    private UploadPanel createPlaceHolder(Composite parent) {
        String text = this.isMulti() ? RWTMessages.getMessage((String)"RWT_FileDialogMultiUploadPanelMessage") : RWTMessages.getMessage((String)"RWT_FileDialogSingleUploadPanelMessage");
        UploadPanel panel = new UploadPanel(parent, new String[]{text});
        panel.setLayoutData(LayoutUtil.createHorizontalFillData());
        return panel;
    }

    private void createProgressArea(Composite parent) {
        this.progressCollector = new ProgressCollector(parent);
        this.progressCollector.setLayoutData(LayoutUtil.createHorizontalFillData());
    }

    private void createDropTarget(Control control) {
        DropTarget dropTarget = new DropTarget(control, 3);
        dropTarget.setTransfer(new Transfer[]{ClientFileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dropAccept(DropTargetEvent event) {
                if (!ClientFileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    event.detail = 0;
                }
            }

            public void drop(DropTargetEvent event) {
                FileDialog.this.handleFileDrop((ClientFile[])event.data);
            }
        });
    }

    private void handleFileDrop(ClientFile[] clientFiles) {
        ClientFile[] clientFileArray;
        this.placeHolder.dispose();
        if (!this.isMulti()) {
            this.clearUploadArea();
        }
        if (this.isMulti()) {
            clientFileArray = clientFiles;
        } else {
            ClientFile[] clientFileArray2 = new ClientFile[1];
            clientFileArray = clientFileArray2;
            clientFileArray2[0] = clientFiles[0];
        }
        ClientFile[] files = clientFileArray;
        UploadPanel uploadPanel = this.createUploadPanel(FileDialog.getFileNames(files));
        this.updateScrolledComposite();
        UploaderService uploader = new UploaderService(files);
        DiskFileUploadReceiver receiver = new DiskFileUploadReceiver();
        receiver.setUploadDirectory(this.uploadDirectory);
        FileUploadHandler handler = new FileUploadHandler((FileUploadReceiver)receiver);
        handler.setMaxFileSize(this.sizeLimit);
        handler.setUploadTimeLimit(this.timeLimit);
        FileUploadRunnable uploadRunnable = new FileUploadRunnable(uploadPanel, this.progressCollector, uploader, handler);
        this.singleThreadExecutor.execute(uploadRunnable);
    }

    private static String[] getFileNames(ClientFile[] clientFiles) {
        String[] fileNames = new String[clientFiles.length];
        int i = 0;
        while (i < fileNames.length) {
            fileNames[i] = clientFiles[i].getName();
            ++i;
        }
        return fileNames;
    }

    private void createButtonsArea(Composite parent) {
        Composite buttonsArea = new Composite(parent, 0);
        buttonsArea.setLayout((Layout)LayoutUtil.createGridLayout(4, 0, 5));
        buttonsArea.setLayoutData((Object)LayoutUtil.createHorizontalFillData());
        String text = this.isMulti() ? SWT.getMessage((String)"SWT_Add") : SWT.getMessage((String)"SWT_Browse");
        this.createFileUpload(buttonsArea, text);
        this.createSpacer(buttonsArea);
        this.okButton = this.createButton(buttonsArea, SWT.getMessage((String)"SWT_OK"));
        parent.getShell().setDefaultButton(this.okButton);
        this.okButton.forceFocus();
        this.okButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog.this.okPressed();
            }
        });
        Button cancelButton = this.createButton(buttonsArea, SWT.getMessage((String)"SWT_Cancel"));
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog.this.cancelPressed();
            }
        });
    }

    protected FileUpload createFileUpload(Composite parent, String text) {
        FileUpload fileUpload = new FileUpload(parent, this.isMulti() ? 2 : 0);
        fileUpload.setText(text);
        fileUpload.setLayoutData((Object)LayoutUtil.createButtonLayoutData((Control)fileUpload));
        if (this.filterExtensions != null) {
            fileUpload.setFilterExtensions(this.filterExtensions);
        }
        fileUpload.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog.this.handleFileUploadSelection((FileUpload)event.widget);
            }
        });
        fileUpload.moveAbove(null);
        return fileUpload;
    }

    private void createSpacer(Composite buttonArea) {
        this.spacer = new Label(buttonArea, 0);
        this.spacer.setLayoutData((Object)LayoutUtil.createButtonLayoutData((Control)this.spacer));
    }

    protected Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)LayoutUtil.createButtonLayoutData((Control)button));
        return button;
    }

    private void handleFileUploadSelection(FileUpload fileUpload) {
        this.placeHolder.dispose();
        if (!this.isMulti()) {
            this.clearUploadArea();
        }
        UploadPanel uploadPanel = this.createUploadPanel(fileUpload.getFileNames());
        this.updateScrolledComposite();
        this.updateButtonsArea(fileUpload);
        UploaderWidget uploader = new UploaderWidget(fileUpload);
        DiskFileUploadReceiver receiver = new DiskFileUploadReceiver();
        receiver.setUploadDirectory(this.uploadDirectory);
        FileUploadHandler handler = new FileUploadHandler((FileUploadReceiver)receiver);
        handler.setMaxFileSize(this.sizeLimit);
        handler.setUploadTimeLimit(this.timeLimit);
        FileUploadRunnable uploadRunnable = new FileUploadRunnable(uploadPanel, this.progressCollector, uploader, handler);
        this.singleThreadExecutor.execute(uploadRunnable);
    }

    private void updateScrolledComposite() {
        Composite content = (Composite)this.uploadsScroller.getContent();
        int i = 0;
        while (i < 2) {
            Rectangle clientArea = this.uploadsScroller.getClientArea();
            Point minSize = content.computeSize(clientArea.width, -1);
            this.uploadsScroller.setMinSize(minSize);
            ++i;
        }
        this.uploadsScroller.setOrigin(0, 10000);
        content.layout();
    }

    private void updateButtonsArea(FileUpload fileUpload) {
        Composite buttonsArea = fileUpload.getParent();
        FileDialog.hideControl((Control)fileUpload);
        String text = this.isMulti() ? SWT.getMessage((String)"SWT_Add") : SWT.getMessage((String)"SWT_Browse");
        this.createFileUpload(buttonsArea, text);
        buttonsArea.layout();
    }

    private UploadPanel createUploadPanel(String[] fileNames) {
        Composite parent = (Composite)this.uploadsScroller.getContent();
        UploadPanel uploadPanel = new UploadPanel(parent, fileNames);
        uploadPanel.setLayoutData(LayoutUtil.createHorizontalFillData());
        return uploadPanel;
    }

    private void clearUploadArea() {
        Composite parent = (Composite)this.uploadsScroller.getContent();
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
    }

    private static void hideControl(Control control) {
        if (control != null) {
            GridData layoutData = (GridData)control.getLayoutData();
            layoutData.exclude = true;
            control.setVisible(false);
        }
    }

    private void setButtonEnabled(final boolean enabled) {
        if (!this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!FileDialog.this.okButton.isDisposed()) {
                        FileDialog.this.okButton.setEnabled(enabled);
                    }
                }
            });
        }
    }

    private void okPressed() {
        this.setReturnCode(32);
        this.close();
    }

    private void cancelPressed() {
        this.setReturnCode(256);
        this.close();
    }

    private void setReturnCode(int code) {
        this.returnCode = code;
    }

    private boolean isMulti() {
        return (this.getStyle() & 2) != 0;
    }

    private void close() {
        this.shell.close();
    }

    private void cleanup() {
        this.pushSession.stop();
        this.singleThreadExecutor.shutdownNow();
        if (this.returnCode == 256) {
            this.deleteUploadedFiles(this.progressCollector.getCompletedFileNames());
        }
    }

    void deleteUploadedFiles(String[] fileNames) {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            ++n2;
        }
    }

    static int checkStyle(Shell parent, int style) {
        int result = style;
        int mask = 229376;
        if ((result & 0x10000000) != 0 && ((result &= 0xEFFFFFFF) & mask) == 0) {
            result |= parent == null ? 65536 : 32768;
        }
        if ((result & mask) == 0) {
            result |= 0x10000;
        }
        if ((result & 0x2000000) == 0 && parent != null && (parent.getStyle() & 0x2000000) != 0) {
            result |= 0x2000000;
        }
        result |= 0x820;
        return result &= 0xFFFFFF7F;
    }

    String[] getCompletedFileNames() {
        return this.progressCollector.getCompletedFileNames();
    }

    ThreadPoolExecutor createSingleThreadExecutor() {
        return new SingleThreadExecutor();
    }

    private final class SingleThreadExecutor
    extends ThreadPoolExecutor {
        public SingleThreadExecutor() {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }

        @Override
        protected void beforeExecute(Thread thread, Runnable runnable) {
            FileDialog.this.setButtonEnabled(false);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            if (this.getQueue().size() == 0) {
                FileDialog.this.setButtonEnabled(true);
            }
        }
    }
}

