/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.dnd.droptargetkit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.client.ClientFile;
import org.eclipse.rap.rwt.dnd.ClientFileTransfer;
import org.eclipse.rap.rwt.internal.client.ClientFileImpl;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.WidgetOperationHandler;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.dnd.DNDEvent;
import org.eclipse.swt.internal.dnd.DNDUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DropTargetOperationHandler
extends WidgetOperationHandler<DropTarget> {
    private static final String EVENT_DRAG_ENTER = "DragEnter";
    private static final String EVENT_DRAG_OPERATION_CHANGED = "DragOperationChanged";
    private static final String EVENT_DRAG_OVER = "DragOver";
    private static final String EVENT_DRAG_LEAVE = "DragLeave";
    private static final String EVENT_DROP_ACCEPT = "DropAccept";
    private static final String EVENT_PARAM_OPERATION = "operation";
    private static final String EVENT_PARAM_FEEDBACK = "feedback";
    private static final String EVENT_PARAM_SOURCE = "source";
    private static final String EVENT_PARAM_DATATYPE = "dataType";
    private static final String EVENT_PARAM_FILES = "files";

    public DropTargetOperationHandler(DropTarget dropTarget) {
        super(dropTarget);
    }

    @Override
    public void handleNotify(DropTarget dropTarget, String eventName, JsonObject properties) {
        if (EVENT_DRAG_ENTER.equals(eventName)) {
            this.handleNotifyDragEnter(dropTarget, properties);
        } else if (EVENT_DRAG_OPERATION_CHANGED.equals(eventName)) {
            this.handleNotifyDragOperationChanged(dropTarget, properties);
        } else if (EVENT_DRAG_OVER.equals(eventName)) {
            this.handleNotifyDragOver(dropTarget, properties);
        } else if (EVENT_DRAG_LEAVE.equals(eventName)) {
            this.handleNotifyDragLeave(dropTarget, properties);
        } else if (EVENT_DROP_ACCEPT.equals(eventName)) {
            this.handleNotifyDropAccept(dropTarget, properties);
        } else {
            super.handleNotify(dropTarget, eventName, properties);
        }
    }

    public void handleNotifyDragEnter(final DropTarget dropTarget, final JsonObject properties) {
        ProcessActionRunner.add(new Runnable(){

            @Override
            public void run() {
                int x = properties.get("x").asInt();
                int y = properties.get("y").asInt();
                int time = properties.get("time").asInt();
                int detail = DropTargetOperationHandler.translateOperation(properties.get(DropTargetOperationHandler.EVENT_PARAM_OPERATION).asString());
                int feedback = properties.get(DropTargetOperationHandler.EVENT_PARAM_FEEDBACK).asInt();
                Item item = (Item)DropTargetOperationHandler.getWidget(properties.get("item"));
                Control sourceControl = (Control)DropTargetOperationHandler.getWidget(properties.get(DropTargetOperationHandler.EVENT_PARAM_SOURCE));
                DragSource dragSource = DropTargetOperationHandler.getDragSource(sourceControl);
                int operations = DropTargetOperationHandler.getOperations(dragSource, dropTarget);
                TransferData[] dataTypes = DropTargetOperationHandler.determineDataTypes(dragSource, dropTarget);
                DNDEvent event = DropTargetOperationHandler.createDropTargetEvent(x, y, time, detail, feedback, operations, dataTypes, dataTypes[0], item);
                dropTarget.notifyListeners(2002, event);
                if (event.detail != detail) {
                    DropTargetOperationHandler.changeOperation(dragSource, dropTarget, event.detail);
                }
                DropTargetOperationHandler.changeDataType(dragSource, dropTarget, event.dataType);
                if (event.feedback != feedback) {
                    DNDUtil.setFeedbackChanged(dropTarget.getControl(), event.feedback);
                }
            }
        });
    }

    public void handleNotifyDragOperationChanged(final DropTarget dropTarget, final JsonObject properties) {
        ProcessActionRunner.add(new Runnable(){

            @Override
            public void run() {
                int x = properties.get("x").asInt();
                int y = properties.get("y").asInt();
                int time = properties.get("time").asInt();
                int detail = DropTargetOperationHandler.getOperation(properties.get(DropTargetOperationHandler.EVENT_PARAM_OPERATION));
                int feedback = DropTargetOperationHandler.getFeedback(properties.get(DropTargetOperationHandler.EVENT_PARAM_FEEDBACK));
                TransferData dataType = DropTargetOperationHandler.getDataType(properties.get(DropTargetOperationHandler.EVENT_PARAM_DATATYPE));
                Item item = (Item)DropTargetOperationHandler.getWidget(properties.get("item"));
                Control sourceControl = (Control)DropTargetOperationHandler.getWidget(properties.get(DropTargetOperationHandler.EVENT_PARAM_SOURCE));
                DragSource dragSource = DropTargetOperationHandler.getDragSource(sourceControl);
                int operations = DropTargetOperationHandler.getOperations(dragSource, dropTarget);
                TransferData[] dataTypes = DropTargetOperationHandler.determineDataTypes(dragSource, dropTarget);
                DNDEvent event = DropTargetOperationHandler.createDropTargetEvent(x, y, time, detail, feedback, operations, dataTypes, dataType, item);
                dropTarget.notifyListeners(2005, event);
                if (event.detail != detail) {
                    DropTargetOperationHandler.changeOperation(dragSource, dropTarget, event.detail);
                }
                if (event.dataType != dataType) {
                    DropTargetOperationHandler.changeDataType(dragSource, dropTarget, event.dataType);
                }
                if (event.feedback != feedback) {
                    DNDUtil.setFeedbackChanged(dropTarget.getControl(), event.feedback);
                }
            }
        });
    }

    public void handleNotifyDragOver(final DropTarget dropTarget, final JsonObject properties) {
        ProcessActionRunner.add(new Runnable(){

            @Override
            public void run() {
                int x = properties.get("x").asInt();
                int y = properties.get("y").asInt();
                int time = properties.get("time").asInt();
                int detail = DropTargetOperationHandler.getOperation(properties.get(DropTargetOperationHandler.EVENT_PARAM_OPERATION));
                int feedback = DropTargetOperationHandler.getFeedback(properties.get(DropTargetOperationHandler.EVENT_PARAM_FEEDBACK));
                TransferData dataType = DropTargetOperationHandler.getDataType(properties.get(DropTargetOperationHandler.EVENT_PARAM_DATATYPE));
                Item item = (Item)DropTargetOperationHandler.getWidget(properties.get("item"));
                Control sourceControl = (Control)DropTargetOperationHandler.getWidget(properties.get(DropTargetOperationHandler.EVENT_PARAM_SOURCE));
                DragSource dragSource = DropTargetOperationHandler.getDragSource(sourceControl);
                int operations = DropTargetOperationHandler.getOperations(dragSource, dropTarget);
                TransferData[] dataTypes = DropTargetOperationHandler.determineDataTypes(dragSource, dropTarget);
                DNDEvent event = DropTargetOperationHandler.createDropTargetEvent(x, y, time, detail, feedback, operations, dataTypes, dataType, item);
                dropTarget.notifyListeners(2004, event);
                if (event.detail != detail) {
                    DropTargetOperationHandler.changeOperation(dragSource, dropTarget, event.detail);
                }
                if (event.dataType != dataType) {
                    DropTargetOperationHandler.changeDataType(dragSource, dropTarget, event.dataType);
                }
                if (event.feedback != feedback) {
                    DNDUtil.setFeedbackChanged(dropTarget.getControl(), event.feedback);
                }
            }
        });
    }

    public void handleNotifyDragLeave(final DropTarget dropTarget, final JsonObject properties) {
        ProcessActionRunner.add(new Runnable(){

            @Override
            public void run() {
                int x = properties.get("x").asInt();
                int y = properties.get("y").asInt();
                int time = properties.get("time").asInt();
                int detail = DropTargetOperationHandler.translateOperation(properties.get(DropTargetOperationHandler.EVENT_PARAM_OPERATION).asString());
                DNDEvent event = DropTargetOperationHandler.createDropTargetEvent(x, y, time, detail, 0, 0, null, null, null);
                dropTarget.notifyListeners(2003, event);
            }
        });
    }

    public void handleNotifyDropAccept(final DropTarget dropTarget, final JsonObject properties) {
        ProcessActionRunner.add(new Runnable(){

            @Override
            public void run() {
                DropData dropData = DropTargetOperationHandler.createDropData(dropTarget, properties);
                if (!DropTargetOperationHandler.isFileDrop(dropData)) {
                    DropTargetOperationHandler.fireDragLeave(dropTarget, dropData);
                }
                DropTargetOperationHandler.fireDropAccept(dropTarget, dropData);
                if (dropData.detail != 0 && dropData.dataType != null) {
                    if (!DropTargetOperationHandler.isFileDrop(dropData)) {
                        DropTargetOperationHandler.fireSetData(dropTarget, dropData);
                    }
                    DropTargetOperationHandler.fireDrop(dropTarget, dropData);
                }
            }
        });
    }

    private static void fireDragLeave(DropTarget dropTarget, DropData dropData) {
        DNDEvent leaveEvent = DropTargetOperationHandler.createDropTargetEvent(dropData.x, dropData.y, dropData.time, dropData.detail, 0, 0, null, null, null);
        dropTarget.notifyListeners(2003, leaveEvent);
    }

    private static void fireDropAccept(DropTarget dropTarget, DropData dropData) {
        DNDEvent acceptEvent = DropTargetOperationHandler.createDropTargetEvent(dropData.x, dropData.y, dropData.time, dropData.detail, 0, dropData.operations, null, dropData.dataType, dropData.item);
        dropTarget.notifyListeners(2007, acceptEvent);
        dropData.detail = DropTargetOperationHandler.changeOperation(dropData.dragSource, dropTarget, acceptEvent.detail);
        dropData.dataTypes = DropTargetOperationHandler.determineDataTypes(dropData.dragSource, dropTarget);
        dropData.dataType = DropTargetOperationHandler.checkDataType(acceptEvent.dataType, dropData.dataTypes);
    }

    private static void fireSetData(DropTarget dropTarget, DropData dropData) {
        DNDEvent setDataEvent = DropTargetOperationHandler.createDragSetDataEvent(dropData.x, dropData.y, dropData.dataType);
        dropData.dragSource.notifyListeners(2001, setDataEvent);
        dropData.data = DropTargetOperationHandler.transferData(dropTarget, dropData.dataType, setDataEvent);
    }

    private static void fireDrop(DropTarget dropTarget, DropData dropData) {
        DNDEvent dropEvent = DropTargetOperationHandler.createDropEvent(dropData);
        dropEvent.data = dropData.data;
        dropTarget.notifyListeners(2006, dropEvent);
        DropTargetOperationHandler.changeOperation(dropData.dragSource, dropTarget, dropEvent.detail);
    }

    private static boolean isFileDrop(DropData dropData) {
        return dropData.data instanceof ClientFileImpl[];
    }

    private static DNDEvent createDropEvent(DropData dropData) {
        return DropTargetOperationHandler.createDropTargetEvent(dropData.x, dropData.y, 0, dropData.detail, 0, dropData.operations, dropData.dataTypes, dropData.dataType, dropData.item);
    }

    private static DropData createDropData(DropTarget dropTarget, JsonObject properties) {
        DropData dropData = new DropData();
        dropData.data = DropTargetOperationHandler.getClientFiles(properties.get(EVENT_PARAM_FILES));
        dropData.x = properties.get("x").asInt();
        dropData.y = properties.get("y").asInt();
        dropData.time = properties.get("time").asInt();
        dropData.detail = DropTargetOperationHandler.getOperation(properties.get(EVENT_PARAM_OPERATION));
        dropData.dataType = dropData.data != null ? DropTargetOperationHandler.getClientFileDataType() : DropTargetOperationHandler.getDataType(properties.get(EVENT_PARAM_DATATYPE));
        dropData.dragSource = DropTargetOperationHandler.getDragSource(properties.get(EVENT_PARAM_SOURCE));
        dropData.dataTypes = DropTargetOperationHandler.determineDataTypes(dropData.dragSource, dropTarget);
        dropData.item = (Item)DropTargetOperationHandler.getWidget(properties.get("item"));
        dropData.operations = DropTargetOperationHandler.getOperations(dropData.dragSource, dropTarget);
        return dropData;
    }

    private static ClientFile[] getClientFiles(JsonValue value) {
        if (value != null) {
            JsonObject fileProperties = value.asObject();
            List<String> fileIds = fileProperties.names();
            int filecount = fileIds.size();
            ClientFile[] result = new ClientFileImpl[filecount];
            int i = 0;
            while (i < filecount) {
                JsonObject file = (JsonObject)fileProperties.get(fileIds.get(i));
                result[i] = new ClientFileImpl(fileIds.get(i), file.get("name").asString(), file.get("type").asString(), file.get("size").asLong());
                ++i;
            }
            return result;
        }
        return null;
    }

    private static DragSource getDragSource(JsonValue sourceId) {
        Control sourceControl = (Control)DropTargetOperationHandler.getWidget(sourceId);
        DragSource dragSource = sourceControl != null ? DropTargetOperationHandler.getDragSource(sourceControl) : null;
        return dragSource;
    }

    private static DNDEvent createDropTargetEvent(int x, int y, int time, int detail, int feedback, int operations, TransferData[] dataTypes, TransferData dataType, Item item) {
        DNDEvent event = new DNDEvent();
        event.x = x;
        event.y = y;
        event.time = time;
        event.detail = detail;
        event.feedback = feedback;
        event.operations = operations;
        event.dataTypes = dataTypes;
        event.dataType = dataType;
        event.item = item;
        event.doit = true;
        return event;
    }

    private static DNDEvent createDragSetDataEvent(int x, int y, TransferData dataType) {
        DNDEvent result = new DNDEvent();
        result.detail = 0;
        result.dataType = dataType;
        result.x = x;
        result.y = y;
        result.data = null;
        result.doit = true;
        return result;
    }

    private static int getOperation(JsonValue operation) {
        int result = DNDUtil.hasDetailChanged() ? DNDUtil.getDetailChangedValue() : DropTargetOperationHandler.translateOperation(operation.asString());
        return result;
    }

    private static int translateOperation(String operation) {
        int result = 0;
        if ("copy".equals(operation)) {
            result = 1;
        } else if ("move".equals(operation)) {
            result = 2;
        } else if ("link".equals(operation)) {
            result = 4;
        }
        return result;
    }

    private static int changeOperation(DragSource dragSource, DropTarget dropTarget, int detail) {
        int checkedOperation = DropTargetOperationHandler.checkOperation(dragSource, dropTarget, detail);
        DNDUtil.setDetailChanged(dropTarget.getControl(), checkedOperation);
        return checkedOperation;
    }

    private static int checkOperation(DragSource dragSource, DropTarget dropTarget, int operation) {
        int allowedOperations = DropTargetOperationHandler.getOperations(dragSource, dropTarget);
        return (allowedOperations & operation) != 0 ? operation : 0;
    }

    private static int getOperations(DragSource dragSource, DropTarget dropTarget) {
        if (dragSource == null) {
            return dropTarget.getStyle();
        }
        return dragSource.getStyle() & dropTarget.getStyle();
    }

    private static TransferData getDataType(JsonValue dataType) {
        TransferData result = null;
        if (DNDUtil.hasDataTypeChanged()) {
            result = DNDUtil.getDataTypeChangedValue();
        } else if (dataType != null && !dataType.isNull()) {
            result = new TransferData();
            result.type = dataType.asInt();
        }
        return result;
    }

    private static TransferData getClientFileDataType() {
        TransferData result = new TransferData();
        result.type = ClientFileTransfer.getInstance().getSupportedTypes()[0].type;
        return result;
    }

    private static void changeDataType(DragSource dragSource, DropTarget dropTarget, TransferData dataType) {
        TransferData[] validDataTypes = DropTargetOperationHandler.determineDataTypes(dragSource, dropTarget);
        TransferData value = DropTargetOperationHandler.checkDataType(dataType, validDataTypes);
        if (value == null) {
            value = validDataTypes[0];
        }
        DNDUtil.setDataTypeChanged(dropTarget.getControl(), value);
    }

    static TransferData[] determineDataTypes(DragSource dragSource, DropTarget dropTarget) {
        ArrayList<TransferData> supportedTypes = new ArrayList<TransferData>();
        Transfer[] transferArray = dropTarget.getTransfer();
        int n = transferArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData[] dataTypes;
            Transfer dropTargetTransfer = transferArray[n2];
            TransferData[] transferDataArray = dataTypes = dropTargetTransfer.getSupportedTypes();
            int n3 = dataTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                TransferData dataType = transferDataArray[n4];
                if (dragSource == null || DropTargetOperationHandler.transfersSupport(dragSource.getTransfer(), dataType)) {
                    supportedTypes.add(dataType);
                }
                ++n4;
            }
            ++n2;
        }
        return supportedTypes.toArray(new TransferData[0]);
    }

    private static boolean transfersSupport(Transfer[] transfers, TransferData dataType) {
        Transfer[] transferArray = transfers;
        int n = transfers.length;
        int n2 = 0;
        while (n2 < n) {
            Transfer dropTargetTransfer = transferArray[n2];
            if (dropTargetTransfer.isSupportedType(dataType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static TransferData checkDataType(TransferData dataType, TransferData[] validTypes) {
        TransferData[] transferDataArray = validTypes;
        int n = validTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData validType = transferDataArray[n2];
            if (TransferData.sameType(dataType, validType)) {
                return dataType;
            }
            ++n2;
        }
        return null;
    }

    private static int getFeedback(JsonValue feedback) {
        int result = DNDUtil.hasFeedbackChanged() ? DNDUtil.getFeedbackChangedValue() : feedback.asInt();
        return result;
    }

    private static <T> T getWidget(JsonValue itemId) {
        if (itemId != null && !itemId.isNull()) {
            return (T)DropTargetOperationHandler.findWidgetById(itemId.asString());
        }
        return null;
    }

    private static Widget findWidgetById(String id) {
        Shell[] shellArray = LifeCycleUtil.getSessionDisplay().getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            Widget widget = WidgetUtil.find(shell, id);
            if (widget != null) {
                return widget;
            }
            ++n2;
        }
        return null;
    }

    private static DragSource getDragSource(Control control) {
        return (DragSource)control.getData("DragSource");
    }

    private static Object transferData(DropTarget dropTarget, TransferData dataType, DNDEvent setDataEvent) {
        if (setDataEvent.doit) {
            Transfer transfer = DropTargetOperationHandler.findTransferByType(dataType, dropTarget);
            transfer.javaToNative(setDataEvent.data, dataType);
            return transfer.nativeToJava(dataType);
        }
        return null;
    }

    private static Transfer findTransferByType(TransferData type, DropTarget dropTarget) {
        Transfer[] transferArray = dropTarget.getTransfer();
        int n = transferArray.length;
        int n2 = 0;
        while (n2 < n) {
            Transfer supported = transferArray[n2];
            if (supported.isSupportedType(type)) {
                return supported;
            }
            ++n2;
        }
        return null;
    }

    private static class DropData {
        int x;
        int y;
        int operations;
        Item item;
        DragSource dragSource;
        TransferData dataType;
        TransferData[] dataTypes;
        int detail;
        int time;
        Object data;

        private DropData() {
        }
    }
}

