/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.SerializableCompatibility;

public final class ListModel
implements SerializableCompatibility {
    private static final int[] EMPTY_SELECTION = new int[0];
    private final boolean single;
    private final List<String> items;
    private int[] selection;

    public ListModel(boolean single) {
        this.single = single;
        this.items = new ArrayList<String>();
        this.selection = EMPTY_SELECTION;
    }

    public int getSelectionIndex() {
        int result = -1;
        if (this.selection.length > 0) {
            result = this.selection[0];
        }
        return result;
    }

    public int[] getSelectionIndices() {
        int[] result = new int[this.selection.length];
        System.arraycopy(this.selection, 0, result, 0, this.selection.length);
        return result;
    }

    public int getSelectionCount() {
        return this.selection.length;
    }

    public void setSelection(int selection) {
        this.deselectAll();
        if (selection >= 0 && selection <= this.getItemCount() - 1) {
            this.selection = new int[]{selection};
        }
    }

    public void setSelection(int[] selection) {
        if (selection == null) {
            SWT.error(4);
        }
        this.deselectAll();
        int length = selection.length;
        if (this.single) {
            int end = this.getItemCount() - 1;
            if (length == 1 && selection[0] >= 0 && selection[0] <= end) {
                this.selection = new int[]{selection[0]};
            }
        } else {
            int end = this.getItemCount() - 1;
            int newLength = 0;
            int i = 0;
            while (i < length) {
                if (selection[i] >= 0 && selection[i] <= end) {
                    ++newLength;
                }
                ++i;
            }
            this.selection = new int[newLength];
            int pos = 0;
            int i2 = 0;
            while (i2 < length) {
                if (selection[i2] >= 0 && selection[i2] <= end) {
                    this.selection[pos] = selection[i2];
                    ++pos;
                }
                ++i2;
            }
        }
    }

    public void setSelection(int start, int end) {
        this.deselectAll();
        if (end >= 0 && start <= end && start <= this.getItemCount() - 1) {
            if (this.single) {
                if (start == end) {
                    this.selection = new int[]{start};
                }
            } else {
                int first = Math.max(0, start);
                int last = Math.min(end, this.getItemCount() - 1);
                this.selection = new int[last - first + 1];
                int current = first;
                int i = 0;
                while (i < this.selection.length) {
                    this.selection[i] = current++;
                    ++i;
                }
            }
        }
    }

    public void setSelection(String[] selection) {
        if (selection == null) {
            SWT.error(4);
        }
        this.deselectAll();
        int length = selection.length;
        if (this.single && length == 1 || !this.single && length > 0) {
            ArrayList<String> alreadySelected = new ArrayList<String>();
            int[] newSelection = new int[this.getItemCount()];
            int newLength = 0;
            int i = 0;
            while (i < length) {
                if (selection[i] != null && !alreadySelected.contains(selection[i])) {
                    alreadySelected.add(selection[i]);
                    int index = 0;
                    while (index < this.getItemCount()) {
                        String item = this.items.get(index);
                        if (item.equals(selection[i])) {
                            newSelection[newLength] = index;
                            ++newLength;
                        }
                        ++index;
                    }
                }
                ++i;
            }
            this.selection = new int[newLength];
            System.arraycopy(newSelection, 0, this.selection, 0, newLength);
        }
    }

    public void addSelection(int index) {
        if (index >= 0 && index < this.getItemCount()) {
            boolean exists = false;
            int i = 0;
            while (i < this.selection.length) {
                if (this.selection[i] == index) {
                    exists = true;
                }
                ++i;
            }
            if (!exists) {
                int newLength = this.selection.length + 1;
                int[] newSelection = new int[newLength];
                System.arraycopy(this.selection, 0, newSelection, 0, this.selection.length);
                newSelection[newLength - 1] = index;
                this.selection = newSelection;
            }
        }
    }

    public void selectAll() {
        if (!this.single) {
            this.selection = new int[this.items.size()];
            int i = 0;
            while (i < this.selection.length) {
                this.selection[i] = i;
                ++i;
            }
        }
    }

    public void deselectAll() {
        this.selection = EMPTY_SELECTION;
    }

    public void add(String string) {
        if (string == null) {
            SWT.error(4);
        }
        this.items.add(string);
    }

    public void add(String string, int index) {
        if (string == null) {
            SWT.error(4);
        }
        if (index != this.getItemCount()) {
            this.checkIndex(index);
        }
        this.items.add(index, string);
        this.adjustSelectionIdicesAfterAdd(index);
    }

    public void remove(int index) {
        this.checkIndex(index);
        this.items.remove(index);
        this.adjustSelectionIdicesAfterRemove(index);
    }

    public void remove(int start, int end) {
        this.checkIndex(start);
        this.checkIndex(end);
        int i = end;
        while (i >= start) {
            this.remove(i);
            --i;
        }
    }

    public void remove(int[] indices) {
        if (indices == null) {
            SWT.error(4);
        }
        if (indices.length > 0) {
            int[] newIndices = new int[indices.length];
            System.arraycopy(indices, 0, newIndices, 0, indices.length);
            Arrays.sort(newIndices);
            this.checkIndex(newIndices[0]);
            this.checkIndex(newIndices[newIndices.length - 1]);
            int i = newIndices.length - 1;
            while (i >= 0) {
                this.remove(newIndices[i]);
                --i;
            }
        }
    }

    public void remove(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int index = this.indexOf(string, 0);
        this.checkIndex(index);
        this.remove(index);
    }

    public void removeAll() {
        this.items.clear();
        this.deselectAll();
    }

    public void setItem(int index, String string) {
        if (string == null) {
            SWT.error(4);
        }
        this.checkIndex(index);
        this.items.set(index, string);
    }

    public void setItems(String[] items) {
        if (items == null) {
            SWT.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                SWT.error(5);
            }
            ++i;
        }
        this.items.clear();
        this.items.addAll(Arrays.asList(items));
        this.deselectAll();
    }

    public String getItem(int index) {
        this.checkIndex(index);
        return this.items.get(index);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public String[] getItems() {
        return this.items.toArray(new String[this.items.size()]);
    }

    public int indexOf(String string, int startIndex) {
        int result = -1;
        if (startIndex >= 0 && startIndex < this.getItemCount()) {
            int i = startIndex;
            while (result == -1 && i < this.getItemCount()) {
                String item = this.items.get(i);
                if (string.equals(item)) {
                    result = i;
                }
                ++i;
            }
        }
        return result;
    }

    private void adjustSelectionIdicesAfterRemove(int indexToRemove) {
        int counter = 0;
        int[] newSelection = new int[this.selection.length];
        int[] nArray = this.selection;
        int n = this.selection.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (indexToRemove < index) {
                newSelection[counter] = index - 1;
                ++counter;
            } else if (indexToRemove > index) {
                newSelection[counter] = index;
                ++counter;
            }
            ++n2;
        }
        this.selection = new int[counter];
        System.arraycopy(newSelection, 0, this.selection, 0, this.selection.length);
    }

    private void adjustSelectionIdicesAfterAdd(int indexToAdd) {
        int counter = 0;
        int[] newSelection = new int[this.selection.length];
        int[] nArray = this.selection;
        int n = this.selection.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (indexToAdd <= index) {
                newSelection[counter] = index + 1;
                ++counter;
            } else if (indexToAdd > index) {
                newSelection[counter] = index;
                ++counter;
            }
            ++n2;
        }
        this.selection = new int[counter];
        System.arraycopy(newSelection, 0, this.selection, 0, this.selection.length);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            SWT.error(6);
        }
    }
}

