/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.servlet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.rap.ui.resources.IResource;
import org.eclipse.ui.internal.WorkbenchPlugin;

class ResourceReader {
    private static final String ID_RESOURCES = "org.eclipse.rap.ui.resources";

    ResourceReader() {
    }

    public static List<IResource> readResources() {
        DependentResource[] resources = ResourceReader.readResourcesFromExtensions();
        DependentResource[] sortedResources = ResourceReader.sortResources(resources);
        return ResourceReader.createResourceList(sortedResources);
    }

    private static DependentResource[] readResourcesFromExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(ID_RESOURCES);
        IConfigurationElement[] elements = point.getConfigurationElements();
        DependentResource[] resources = new DependentResource[elements.length];
        int i = 0;
        while (i < elements.length) {
            try {
                IResource resource = (IResource)elements[i].createExecutableExtension("class");
                String resourceId = elements[i].getAttribute("id");
                IConfigurationElement[] dependsOn = elements[i].getChildren("dependsOn");
                ArrayList<String> resourceDependencies = new ArrayList<String>();
                int j = 0;
                while (j < dependsOn.length) {
                    String dependency = dependsOn[j].getAttribute("resourceId");
                    resourceDependencies.add(dependency);
                    ++j;
                }
                resources[i] = new DependentResource(resource, resourceId, resourceDependencies);
            }
            catch (CoreException ce) {
                WorkbenchPlugin.getDefault().getLog().log(ce.getStatus());
            }
            ++i;
        }
        return resources;
    }

    private static DependentResource[] sortResources(DependentResource[] resources) {
        DependentResource[] result = new DependentResource[resources.length];
        ArrayList<String> sortedResourceIds = new ArrayList<String>();
        ArrayList<DependentResource> deferredResources = new ArrayList<DependentResource>();
        int index = 0;
        int i = 0;
        while (i < resources.length) {
            DependentResource resource = resources[i];
            if (resource != null) {
                resource.dependencies.removeAll(sortedResourceIds);
                boolean checkDeferredResources = false;
                if (resource.dependencies.isEmpty()) {
                    result[index++] = resource;
                    sortedResourceIds.add(resource.id);
                    checkDeferredResources = true;
                } else {
                    deferredResources.add(resource);
                }
                while (checkDeferredResources) {
                    checkDeferredResources = false;
                    Iterator iterator = deferredResources.iterator();
                    while (iterator.hasNext()) {
                        DependentResource deferredResource = (DependentResource)iterator.next();
                        deferredResource.dependencies.removeAll(sortedResourceIds);
                        if (!deferredResource.dependencies.isEmpty()) continue;
                        result[index++] = deferredResource;
                        sortedResourceIds.add(deferredResource.id);
                        iterator.remove();
                        checkDeferredResources = true;
                    }
                }
            }
            ++i;
        }
        if (deferredResources.size() != 0) {
            String pluginId = WorkbenchPlugin.getDefault().getBundle().getSymbolicName();
            String message = "Dependencies could not be resolved for " + deferredResources;
            WorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, pluginId, message));
        }
        return result;
    }

    private static List<IResource> createResourceList(DependentResource[] sortedResources) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        DependentResource[] dependentResourceArray = sortedResources;
        int n = sortedResources.length;
        int n2 = 0;
        while (n2 < n) {
            DependentResource dependentResource = dependentResourceArray[n2];
            result.add(dependentResource.resource);
            ++n2;
        }
        return result;
    }

    private static final class DependentResource {
        public final IResource resource;
        public final String id;
        public final List<String> dependencies;

        public DependentResource(IResource resource, String id, List<String> dependencies) {
            this.resource = resource;
            this.id = id;
            this.dependencies = dependencies;
        }

        public String toString() {
            return this.id != null ? this.id : this.resource.getClass().getName();
        }
    }
}

