/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.jface.gridviewer;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.GridTreeViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridEditor;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class GridViewerEditor
extends ColumnViewerEditor {
    private GridEditor gridEditor;
    public static final int SELECTION_FOLLOWS_EDITOR = 0x40000000;
    private boolean selectionFollowsEditor = false;

    GridViewerEditor(ColumnViewer viewer, ColumnViewerEditorActivationStrategy editorActivationStrategy, int feature) {
        super(viewer, editorActivationStrategy, feature);
        this.selectionFollowsEditor = (feature & 0x40000000) == 0x40000000;
        this.gridEditor = new GridEditor((Grid)viewer.getControl());
    }

    protected void setEditor(Control w, Item item, int fColumnNumber) {
        this.gridEditor.setEditor(w, (GridItem)item, fColumnNumber);
    }

    protected void setLayoutData(CellEditor.LayoutData layoutData) {
        this.gridEditor.grabHorizontal = layoutData.grabHorizontal;
        this.gridEditor.horizontalAlignment = layoutData.horizontalAlignment;
        this.gridEditor.minimumWidth = layoutData.minimumWidth;
        this.gridEditor.verticalAlignment = layoutData.verticalAlignment;
        this.gridEditor.minimumHeight = layoutData.minimumHeight != -1 ? layoutData.minimumHeight : -1;
    }

    public ViewerCell getFocusCell() {
        Grid cfr_ignored_0 = (Grid)this.getViewer().getControl();
        return null;
    }

    private ViewerRow getViewerRowFromItem(GridItem item) {
        if (this.getViewer() instanceof GridTableViewer) {
            return ((GridTableViewer)this.getViewer()).getViewerRowFromItem((Widget)item);
        }
        return ((GridTreeViewer)this.getViewer()).getViewerRowFromItem((Widget)item);
    }

    protected void updateFocusCell(ViewerCell focusCell, ColumnViewerEditorActivationEvent event) {
        Grid grid = (Grid)this.getViewer().getControl();
        if (event.eventType == 4 || event.eventType == 5) {
            grid.setFocusItem((GridItem)focusCell.getItem());
        }
        grid.showColumn(grid.getColumn(focusCell.getColumnIndex()));
        grid.showItem((GridItem)focusCell.getItem());
    }

    public static void create(GridTableViewer viewer, ColumnViewerEditorActivationStrategy editorActivationStrategy, int feature) {
        viewer.setColumnViewerEditor(new GridViewerEditor((ColumnViewer)viewer, editorActivationStrategy, feature));
    }

    public static void create(GridTreeViewer viewer, ColumnViewerEditorActivationStrategy editorActivationStrategy, int feature) {
        viewer.setColumnViewerEditor(new GridViewerEditor((ColumnViewer)viewer, editorActivationStrategy, feature));
    }
}

