/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.ULocale;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeZone
implements Serializable,
Cloneable,
Freezable<TimeZone> {
    private static final long serialVersionUID = 1L;
    public final java.util.TimeZone timeZone;
    public static final int TIMEZONE_ICU = 0;
    public static final int TIMEZONE_JDK = 1;
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private transient boolean isFrozen = false;

    public TimeZone(java.util.TimeZone delegate) {
        this.timeZone = delegate;
    }

    public TimeZone() {
        this.timeZone = java.util.TimeZone.getDefault();
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
        return this.timeZone.getOffset(era, year, month, day, dayOfWeek, milliseconds);
    }

    public int getOffset(long date) {
        return this.timeZone.getOffset(date);
    }

    public void setRawOffset(int offsetMillis) {
        if (this.isFrozen) {
            throw new UnsupportedOperationException("Attempt to modify a frozen TimeZone instance.");
        }
        this.timeZone.setRawOffset(offsetMillis);
    }

    public int getRawOffset() {
        return this.timeZone.getRawOffset();
    }

    public String getID() {
        return this.timeZone.getID();
    }

    public void setID(String ID) {
        if (this.isFrozen) {
            throw new UnsupportedOperationException("Attempt to modify a frozen TimeZone instance.");
        }
        this.timeZone.setID(ID);
    }

    public final String getDisplayName() {
        return this.timeZone.getDisplayName(ULocale.getDefault(ULocale.Category.DISPLAY).toLocale());
    }

    public final String getDisplayName(Locale locale) {
        return this.timeZone.getDisplayName(locale);
    }

    public final String getDisplayName(ULocale locale) {
        return this.timeZone.getDisplayName(locale.toLocale());
    }

    public final String getDisplayName(boolean daylight, int style) {
        return this.getDisplayName(daylight, style, ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    public String getDisplayName(boolean daylight, int style, Locale locale) {
        return this.getDisplayName(daylight, style, ULocale.forLocale(locale));
    }

    public String getDisplayName(boolean daylight, int style, ULocale locale) {
        if (style == 0) {
            return this.timeZone.getDisplayName(daylight, 0, locale.toLocale());
        }
        if (style == 1) {
            return this.timeZone.getDisplayName(daylight, 1, locale.toLocale());
        }
        throw new UnsupportedOperationException("Specified time zone format style is not supported by com.ibm.icu.base");
    }

    public int getDSTSavings() {
        return this.timeZone.getDSTSavings();
    }

    public boolean useDaylightTime() {
        return this.timeZone.useDaylightTime();
    }

    public boolean inDaylightTime(Date date) {
        return this.timeZone.inDaylightTime(date);
    }

    public static synchronized TimeZone getTimeZone(String ID) {
        return new TimeZone(java.util.TimeZone.getTimeZone(ID));
    }

    public static TimeZone getFrozenTimeZone(String ID) {
        return TimeZone.getTimeZone(ID).freeze();
    }

    public static synchronized TimeZone getTimeZone(String ID, int type) {
        if (type == 1) {
            return new TimeZone(java.util.TimeZone.getTimeZone(ID));
        }
        throw new UnsupportedOperationException("TIMEZONE_ICU not supported by com.ibm.icu.base");
    }

    public static synchronized void setDefaultTimeZoneType(int type) {
        if (type != 1) {
            throw new UnsupportedOperationException("TimeZone type other than TIMEZONE_JDK is not supported by com.ibm.icu.base");
        }
    }

    public static int getDefaultTimeZoneType() {
        return 1;
    }

    public static String[] getAvailableIDs(int rawOffset) {
        return java.util.TimeZone.getAvailableIDs(rawOffset);
    }

    public static String[] getAvailableIDs() {
        return java.util.TimeZone.getAvailableIDs();
    }

    public static TimeZone getDefault() {
        return new TimeZone(java.util.TimeZone.getDefault());
    }

    public static void setDefault(TimeZone tz) {
        java.util.TimeZone.setDefault(tz.timeZone);
    }

    public boolean hasSameRules(TimeZone other) {
        return this.timeZone.hasSameRules(other.timeZone);
    }

    public Object clone() {
        return new TimeZone((java.util.TimeZone)this.timeZone.clone());
    }

    public boolean equals(Object obj) {
        try {
            return this.timeZone.equals(((TimeZone)obj).timeZone);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.timeZone.hashCode();
    }

    @Override
    public boolean isFrozen() {
        return this.isFrozen;
    }

    @Override
    public TimeZone freeze() {
        this.isFrozen = true;
        return this;
    }

    @Override
    public TimeZone cloneAsThawed() {
        try {
            TimeZone other = (TimeZone)super.clone();
            other.isFrozen = false;
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

