/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RequestTab
extends ExampleTab {
    public RequestTab(CTabFolder parent) {
        super(parent, "Longrunning Request");
    }

    protected void createStyleControls(Composite parent) {
    }

    protected void createExampleControls(final Composite parent) {
        parent.setLayout((Layout)new GridLayout(4, false));
        Label lblInfo = new Label(parent, 64);
        String msg = "Simulate a long running server-side task. You should see the mouse cursor change after a short delay.";
        lblInfo.setText(msg);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        lblInfo.setLayoutData((Object)gridData);
        Label lblProcessingTime = new Label(parent, 0);
        lblProcessingTime.setText("Processing time");
        final Text txtProcessingTime = new Text(parent, 2048);
        txtProcessingTime.setText("5000");
        Label lblMS = new Label(parent, 0);
        lblMS.setText("ms");
        Button btnRun = new Button(parent, 8);
        btnRun.setText("Run");
        btnRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String timeText = txtProcessingTime.getText().trim();
                int time = -1;
                try {
                    time = Integer.parseInt(timeText);
                }
                catch (NumberFormatException numberFormatException) {}
                if (time >= 0) {
                    boolean interrupted = false;
                    try {
                        Thread.sleep(time);
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                    }
                    Shell shell = parent.getShell();
                    String msg = interrupted ? "Interrupted" : "Done";
                    MessageDialog.openInformation((Shell)shell, (String)"Information", (String)msg);
                } else {
                    Shell shell = parent.getShell();
                    String msg = "'" + timeText + "' is not a valid processing time.";
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)msg);
                }
            }
        });
    }
}

