/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.buttonkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

final class ButtonLCAUtil {
    private static final String JS_PROP_SELECTION = "selection";
    private static final String JS_PROP_HORIZONTAL_CHILDREN_ALIGN = "horizontalChildrenAlign";
    static final String PROP_SELECTION = "selection";
    static final String PROP_ALIGNMENT = "alignment";
    static final String PROP_SELECTION_LISTENERS = "selectionListeners";
    private static final String PARAM_SELECTION = "selection";
    private static final Integer DEFAULT_ALIGNMENT = new Integer(0x1000000);

    private ButtonLCAUtil() {
    }

    static boolean readSelection(Button button) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)button, "selection");
        if (value != null) {
            button.setSelection(Boolean.valueOf(value).booleanValue());
        }
        return value != null;
    }

    static void preserveValues(Button button) {
        ControlLCAUtil.preserveValues((Control)button);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)button);
        adapter.preserve("text", (Object)button.getText());
        adapter.preserve("image", (Object)button.getImage());
        adapter.preserve("selection", (Object)button.getSelection());
        adapter.preserve(PROP_SELECTION_LISTENERS, (Object)SelectionEvent.hasListener((Adaptable)button));
        adapter.preserve(PROP_ALIGNMENT, (Object)new Integer(button.getAlignment()));
        boolean hasListeners = SelectionEvent.hasListener((Adaptable)button);
        adapter.preserve(PROP_SELECTION_LISTENERS, (Object)hasListeners);
        WidgetLCAUtil.preserveCustomVariant((Widget)button);
    }

    static void writeText(Button button) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)button);
        String text = button.getText();
        if (WidgetLCAUtil.hasChanged((Widget)button, "text", text, null)) {
            text = WidgetLCAUtil.escapeText(text, true);
            if ((button.getStyle() & 0x40) != 0) {
                text = WidgetLCAUtil.replaceNewLines(text, "<br/>");
            }
            writer.set("text", text.equals("") ? null : text);
        }
    }

    static void writeImage(Button button) throws IOException {
        Image image = button.getImage();
        if (WidgetLCAUtil.hasChanged((Widget)button, "image", image, null)) {
            String imagePath = ImageFactory.getImagePath((Image)image);
            JSWriter writer = JSWriter.getWriterFor((Widget)button);
            Rectangle bounds = image != null ? image.getBounds() : null;
            Object[] args = new Object[]{imagePath, new Integer(bounds != null ? bounds.width : 0), new Integer(bounds != null ? bounds.height : 0)};
            writer.set("image", args);
        }
    }

    static void writeAlignment(Button button) throws IOException {
        Integer defValue;
        Integer newValue;
        if ((button.getStyle() & 4) == 0 && WidgetLCAUtil.hasChanged((Widget)button, PROP_ALIGNMENT, newValue = new Integer(button.getAlignment()), defValue = DEFAULT_ALIGNMENT)) {
            String value;
            JSWriter writer = JSWriter.getWriterFor((Widget)button);
            switch (newValue) {
                case 16384: {
                    value = "left";
                    break;
                }
                case 0x1000000: {
                    value = "center";
                    break;
                }
                case 131072: {
                    value = "right";
                    break;
                }
                default: {
                    value = "left";
                }
            }
            writer.set(JS_PROP_HORIZONTAL_CHILDREN_ALIGN, value);
        }
    }

    static void writeSelection(Button button) throws IOException {
        Boolean newValue = button.getSelection();
        JSWriter writer = JSWriter.getWriterFor((Widget)button);
        writer.set("selection", "selection", newValue, Boolean.FALSE);
    }

    static void writeSelectionListener(Button button) throws IOException {
        String prop = PROP_SELECTION_LISTENERS;
        boolean hasListener = SelectionEvent.hasListener((Adaptable)button);
        Boolean newValue = hasListener;
        if (WidgetLCAUtil.hasChanged((Widget)button, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)button);
            writer.set("hasSelectionListener", newValue);
        }
    }

    static void writeChanges(Button button) throws IOException {
        ControlLCAUtil.writeChanges((Control)button);
        ButtonLCAUtil.writeText(button);
        ButtonLCAUtil.writeImage(button);
        ButtonLCAUtil.writeAlignment(button);
        ButtonLCAUtil.writeSelection(button);
        ButtonLCAUtil.writeSelectionListener(button);
        WidgetLCAUtil.writeCustomVariant((Widget)button);
    }

    public static void writeWrap(Button button) throws IOException {
        boolean wrap;
        boolean bl = wrap = (button.getStyle() & 0x40) != 0;
        if (wrap) {
            JSWriter writer = JSWriter.getWriterFor((Widget)button);
            writer.set("wrap", new Boolean(true));
        }
    }
}

