/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.readonly;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.readonly.Country;

public class UpdateReadOnlyClassTestCase
extends AutoVerifyTestCase {
    public UnitOfWork uow;
    Country aCountry;
    String oldName;

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setup() {
        this.beginTransaction();
        Vector<Class<Country>> readOnlyClasses = new Vector<Class<Country>>();
        readOnlyClasses.addElement(Country.class);
        this.uow = this.getSession().acquireUnitOfWork();
        this.uow.removeAllReadOnlyClasses();
        this.uow.addReadOnlyClasses(readOnlyClasses);
    }

    protected void test() {
        this.aCountry = (Country)this.uow.readObject(Country.class);
        this.oldName = this.aCountry.getName();
        this.uow.registerObject((Object)this.aCountry);
        this.aCountry.setName(this.aCountry.getName() + " 22");
        this.uow.commit();
    }

    protected void verify() {
        ExpressionBuilder xBuilder = new ExpressionBuilder();
        Expression exp = xBuilder.get("name").equal((Object)this.aCountry.name);
        Country dbCountry = (Country)this.getSession().readObject(Country.class, exp);
        if (dbCountry != null) {
            throw new TestErrorException("The Country object was illegally updated! It should not have been!");
        }
    }
}

