/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.events;

import java.util.Vector;
import org.eclipse.persistence.config.CacheIsolationType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.events.Address;
import org.eclipse.persistence.testing.models.events.CreditCard;
import org.eclipse.persistence.testing.models.events.Customer;
import org.eclipse.persistence.testing.models.events.EmailAccount;
import org.eclipse.persistence.testing.models.events.Order;
import org.eclipse.persistence.testing.models.events.Phone;
import org.eclipse.persistence.testing.tests.events.EventHookTestCase;

public class CloneEventOnIsolatedSessionTest
extends EventHookTestCase {
    Vector<ClassDescriptor> issolatedDescriptors;
    boolean hasIsolatedClasses = false;

    @Override
    public void setup() {
        this.issolatedDescriptors = new Vector();
        this.issolatedDescriptors.add(this.getSession().getDescriptor(Address.class));
        this.issolatedDescriptors.add(this.getSession().getDescriptor(Phone.class));
        this.issolatedDescriptors.add(this.getSession().getDescriptor(CreditCard.class));
        this.issolatedDescriptors.add(this.getSession().getDescriptor(Customer.class));
        this.issolatedDescriptors.add(this.getSession().getDescriptor(EmailAccount.class));
        this.issolatedDescriptors.add(this.getSession().getDescriptor(Order.class));
        for (ClassDescriptor descriptor : this.issolatedDescriptors) {
            descriptor.setCacheIsolation(CacheIsolationType.ISOLATED);
            descriptor.setUnitOfWorkCacheIsolationLevel(4);
        }
        this.hasIsolatedClasses = this.getDatabaseSession().getProject().hasIsolatedClasses();
        this.getDatabaseSession().getProject().setHasIsolatedClasses(true);
        super.setup();
        this.getDatabaseSession().writeObject((Object)this.getEmailAccount());
        this.getDatabaseSession().writeObject((Object)this.getPhoneNumber());
        this.getDatabaseSession().writeObject((Object)this.getAddress());
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    @Override
    public void reset() {
        for (ClassDescriptor descriptor : this.issolatedDescriptors) {
            descriptor.setCacheIsolation(CacheIsolationType.SHARED);
            descriptor.setUnitOfWorkCacheIsolationLevel(1);
        }
        this.getDatabaseSession().getProject().setHasIsolatedClasses(this.hasIsolatedClasses);
        super.reset();
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        EmailAccount emailAccountCopy = (EmailAccount)uow.readObject((Object)this.getEmailAccount());
        emailAccountCopy.setHostName("localHost");
        Phone phoneNumberCopy = (Phone)uow.readObject((Object)this.getPhoneNumber());
        phoneNumberCopy.phoneNo = "555-5555";
        Address addressCopy = (Address)uow.readObject((Object)this.getAddress());
        addressCopy.address = "No Where";
        uow.commit();
        if (!emailAccountCopy.postCloneExecuted) {
            throw new TestErrorException("Event hook failed. The post clone method on " + emailAccountCopy + " failed to execute.");
        }
        if (!phoneNumberCopy.postCloneExecuted) {
            throw new TestErrorException("Event hook failed. The post clone method on " + phoneNumberCopy + " failed to execute.");
        }
    }
}

