/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.FaultException;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import oracle.kv.table.TableIterator;

public interface StatementResult
extends Iterable<RecordValue> {
    public int getPlanId();

    public String getInfo();

    public String getInfoAsJson();

    public String getErrorMessage();

    public boolean isSuccessful();

    public boolean isDone();

    public boolean isCancelled();

    public String getResult();

    public Kind getKind();

    @Override
    public TableIterator<RecordValue> iterator() throws IllegalStateException;

    public void close();

    public RecordDef getResultDef() throws IllegalStateException, FaultException;

    public static enum Kind implements FastExternalizable
    {
        DDL(0),
        QUERY(1);

        private static final Kind[] VALUES;

        private Kind(int ordinal) {
            if (ordinal != this.ordinal()) {
                throw new IllegalArgumentException("Wrong ordinal");
            }
        }

        public static Kind readFastExternal(DataInput in, short serialVersion) throws IOException {
            int ordinal = in.readUnsignedByte();
            try {
                return VALUES[ordinal];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("unknown StatementResult.Kind: " + ordinal);
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            out.writeByte(this.ordinal());
        }

        static {
            VALUES = Kind.values();
        }
    }
}

