/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.tests.workbenchintegration.ProjectClassGeneratorResultFileTest;

public class TypeConversionConverterObjectClassIsArrayTest
extends ProjectClassGeneratorResultFileTest {
    protected ClassDescriptor descriptor;
    protected DirectToFieldMapping mapping;
    protected Class<?> classType;

    public TypeConversionConverterObjectClassIsArrayTest(Class<?> classType) {
        super(new EmployeeProject());
        this.setDescription("Test addTypeConversionConverterLines method -> setObjectClassName() generates legal array code");
        this.setName(this.getName() + "[" + classType.getName() + "]");
        if (!classType.isArray()) {
            this.throwError("ClassType must be an array type: " + classType);
        }
        this.classType = classType;
        String expectedName = classType.getComponentType().getName();
        this.testString = "someDataMappingConverter.setObjectClass(" + expectedName + "[].class);";
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.descriptor = (ClassDescriptor)this.project.getDescriptors().get(Employee.class);
        this.mapping = new DirectToFieldMapping();
        this.mapping.setAttributeName("someData");
        this.mapping.setFieldName("SOME_TABLE.SOME_DATA");
        TypeConversionConverter someConverter = new TypeConversionConverter();
        someConverter.setObjectClassName(this.classType.getName());
        this.mapping.setConverter((Converter)someConverter);
        this.descriptor.addMapping((DatabaseMapping)this.mapping);
    }

    @Override
    public void reset() {
        if (this.descriptor != null) {
            this.descriptor.getMappings().remove(this.mapping);
            this.mapping.setDescriptor(null);
        }
        super.reset();
    }
}

