/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simultaneous;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class QueryCacheTest
extends TestCase {
    protected Vector args = null;
    protected int results1 = 0;
    protected int results2 = 0;
    protected int results3 = 0;
    protected int expectedResults = 0;

    public QueryCacheTest(int parameterType) {
        this.setDescription("A single test run as part of the multithreaded query caching test.");
        this.args = new Vector();
        if (parameterType == 1) {
            this.args.add("B%");
            this.expectedResults = 2;
        } else if (parameterType == 2) {
            this.args.add("J%");
            this.expectedResults = 3;
        } else {
            this.args.add("%");
            this.expectedResults = 12;
        }
    }

    public void test() {
        Vector results = (Vector)this.getSession().executeQuery("multithreadedCachedResultsQuery", (List)this.args);
        this.results1 = results.size();
        results = (Vector)this.getSession().executeQuery("multithreadedCachedResultsQuery", (List)this.args);
        this.results2 = results.size();
        ReadQuery query = (ReadQuery)this.getSession().getQuery("multithreadedCachedResultsQuery");
        query.clearQueryResults((AbstractSession)this.getSession());
        results = (Vector)this.getSession().executeQuery((DatabaseQuery)query, (List)this.args);
        this.results3 = results.size();
    }

    public void verify() {
        if (this.results1 != this.expectedResults) {
            throw new TestErrorException("Initial Query did not yield the expected number of results: " + this.results1);
        }
        if (this.results2 != this.expectedResults) {
            throw new TestErrorException("Second Query did not yield the expected number of results: " + this.results2);
        }
        if (this.results3 != this.expectedResults) {
            throw new TestErrorException("Third Query did not yield the expected number of results: " + this.results3);
        }
    }
}

