/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class EmployeeClient
extends Thread {
    protected Server server;
    protected Session clientSession;
    protected Session session;
    public boolean keepRunning = true;
    public int maximumLoops = 0;
    public boolean errorOccurred = false;
    public Exception testException = null;
    public Vector sequenceNumbers = new Vector();

    public EmployeeClient() {
    }

    public EmployeeClient(Server server, Session session, String name, int maximumLoops) {
        super(name);
        this.server = server;
        this.session = session;
        this.setMaximumLoops(maximumLoops);
        this.clientSession = this.server.serverSession.acquireClientSession();
    }

    public boolean anErrorOccurred() {
        return this.getErrorOccurred();
    }

    private boolean getErrorOccurred() {
        return this.errorOccurred;
    }

    public boolean getKeepRunning() {
        return this.keepRunning;
    }

    protected int getMaximumLoops() {
        return this.maximumLoops;
    }

    public Vector getSequenceNumbers() {
        return this.sequenceNumbers;
    }

    public Exception getTestException() {
        return this.testException;
    }

    public void pleaseStop() {
        this.setKeepRunning(false);
    }

    @Override
    public void run() {
        ExpressionBuilder exb = new ExpressionBuilder();
        int i = 0;
        while (this.getKeepRunning()) {
            try {
                UnitOfWork uow = this.clientSession.acquireUnitOfWork();
                Address address = new Address();
                uow.assignSequenceNumber((Object)address);
                this.getSequenceNumbers().addElement(address.getId());
                if (++i > this.getMaximumLoops()) {
                    this.pleaseStop();
                }
                uow.commit();
            }
            catch (Exception e) {
                this.pleaseStop();
                this.setErrorOccurred(true);
                this.setTestException(e);
            }
        }
        this.session = null;
        this.server = null;
    }

    protected void setErrorOccurred(boolean newValue) {
        this.errorOccurred = newValue;
    }

    public void setKeepRunning(boolean newValue) {
        this.keepRunning = newValue;
    }

    private void setMaximumLoops(int newValue) {
        this.maximumLoops = newValue;
    }

    protected void setTestException(Exception newValue) {
        this.testException = newValue;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

