/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.mapping;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Address
implements Serializable {
    public Number id;
    public String location;
    public Employee employee;
    public Vector employeeRows;
    public String province;

    public Object copy() {
        return new Address();
    }

    public static Address example1() {
        Address example = new Address();
        example.setLocation("OTTAWA");
        example.setProvince("ONTARIO");
        return example;
    }

    public static Address example2() {
        Address example = new Address();
        example.setLocation("Montreal");
        example.setProvince("QUEBEC");
        return example;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public String getProvince() {
        return this.province;
    }

    public String getProvinceFromObject() {
        String province = "";
        if (this.getProvince() == null) {
            return null;
        }
        if (this.getProvince().equals("ONTARIO")) {
            province = "ON";
        }
        if (this.getProvince().equals("QUEBEC")) {
            province = "QUE";
        }
        return province;
    }

    public String getProvinceFromRow(DataRecord row, Session session) {
        String code = (String)row.get((Object)"PROVINCE");
        String provinceString = null;
        this.employeeRows = session.executeSelectingCall((Call)new SQLCall("Select * from MAP_EMP"));
        if (code == "ON") {
            provinceString = new String("ONTARIO");
        }
        if (code == "QUE") {
            provinceString = new String("QUEBEC");
        }
        return provinceString;
    }

    public void setEmployee(Employee anEmployee) {
        this.employee = anEmployee;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("MAP_ADD");
        definition.addIdentityField("A_ID", BigDecimal.class, 15);
        definition.addField("LOCATION", String.class, 15);
        definition.addField("PROVINCE", String.class, 3);
        return definition;
    }

    public String toString() {
        return "Address(" + this.location + "--" + this.province + ")";
    }
}

