/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

public class ResultIndexKeys
implements FastExternalizable {
    private final byte[] primaryKeyBytes;
    private final byte[] indexKeyBytes;
    private final long expirationTime;

    public ResultIndexKeys(byte[] primaryKeyBytes, byte[] indexKeyBytes, long expirationTime) {
        ObjectUtil.checkNull("primaryKeyBytes", primaryKeyBytes);
        ObjectUtil.checkNull("indexKeyBytes", indexKeyBytes);
        this.primaryKeyBytes = primaryKeyBytes;
        this.indexKeyBytes = indexKeyBytes;
        this.expirationTime = expirationTime;
    }

    public ResultIndexKeys(DataInput in, short serialVersion) throws IOException {
        this.primaryKeyBytes = SerializationUtil.readNonNullByteArrayOldShortLength(in, serialVersion);
        this.indexKeyBytes = SerializationUtil.readNonNullByteArrayOldShortLength(in, serialVersion);
        this.expirationTime = Result.readExpirationTime(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        SerializationUtil.writeNonNullByteArrayOldShortLength(out, serialVersion, this.primaryKeyBytes);
        SerializationUtil.writeNonNullByteArrayOldShortLength(out, serialVersion, this.indexKeyBytes);
        Result.writeExpirationTime(out, this.expirationTime, serialVersion);
    }

    public byte[] getPrimaryKeyBytes() {
        return this.primaryKeyBytes;
    }

    public byte[] getIndexKeyBytes() {
        return this.indexKeyBytes;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }
}

