/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerializationUtil;

public class StatusChanges
implements FastExternalizable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final ReplicatedEnvironment.State[] STATE_VALUES = ReplicatedEnvironment.State.values();
    private final ReplicatedEnvironment.State state;
    private final RepNodeId masterId;
    private final long statusTime;

    public StatusChanges(ReplicatedEnvironment.State state, RepNodeId masterId, long sequenceNum) {
        this.state = state;
        this.masterId = masterId;
        this.statusTime = sequenceNum;
    }

    public StatusChanges(DataInput in, short serialVersion) throws IOException {
        byte value = in.readByte();
        if (value == -1) {
            this.state = null;
        } else {
            try {
                this.state = STATE_VALUES[value];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Wrong value for ReplicatedEnvironment.State: " + value);
            }
        }
        if (in.readBoolean()) {
            ResourceId rId = ResourceId.readFastExternal(in, serialVersion);
            if (!(rId instanceof RepNodeId)) {
                throw new IOException("Expected RepNodeId: " + rId);
            }
            this.masterId = (RepNodeId)rId;
        } else {
            this.masterId = null;
        }
        this.statusTime = in.readLong();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        out.writeByte(this.state != null ? this.state.ordinal() : -1);
        SerializationUtil.writeFastExternalOrNull(out, serialVersion, this.masterId);
        out.writeLong(this.statusTime);
    }

    public ReplicatedEnvironment.State getState() {
        return this.state;
    }

    public RepNodeId getCurrentMaster() {
        return this.masterId;
    }

    public long getStatusTime() {
        return this.statusTime;
    }

    static {
        assert (ReplicatedEnvironment.State.DETACHED.ordinal() == 0);
        assert (ReplicatedEnvironment.State.UNKNOWN.ordinal() == 1);
        assert (ReplicatedEnvironment.State.MASTER.ordinal() == 2);
        assert (ReplicatedEnvironment.State.REPLICA.ordinal() == 3);
    }
}

