/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.resources.common;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.xml.bind.JAXBException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Parameter;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.SessionBeanCall;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.v2.ContextsCatalog;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.v2.Resource;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.ItemLinksBuilder;
import org.eclipse.persistence.jpa.rs.features.ServiceVersion;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;
import org.eclipse.persistence.jpa.rs.util.HrefHelper;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.jpa.rs.util.list.LinkList;

public abstract class AbstractPersistenceResource
extends AbstractResource {
    private static final String CLASS_NAME = AbstractPersistenceResource.class.getName();

    protected Response getContextsInternal(String version, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "getContextsInternal", new Object[]{"GET", version, uriInfo.getRequestUri().toASCIIString()});
        if (!AbstractPersistenceResource.isValidVersion(version)) {
            JPARSLogger.error("unsupported_service_version_in_the_request", new Object[]{version});
            throw JPARSException.invalidServiceVersion(version);
        }
        if (ServiceVersion.fromCode(version).compareTo(ServiceVersion.VERSION_2_0) >= 0) {
            return this.getContextsV2(version, headers, uriInfo);
        }
        return this.getContextsV1(version, headers, uriInfo);
    }

    protected Response callSessionBeanInternal(String version, HttpHeaders headers, UriInfo uriInfo, InputStream is) {
        JPARSLogger.entering(CLASS_NAME, "callSessionBeanInternal", new Object[]{"POST", headers.getMediaType(), version, uriInfo.getRequestUri().toASCIIString()});
        try {
            if (!AbstractPersistenceResource.isValidVersion(version)) {
                JPARSLogger.error("unsupported_service_version_in_the_request", new Object[]{version});
                throw JPARSException.invalidServiceVersion(version);
            }
            SessionBeanCall call = this.unmarshallSessionBeanCall(is);
            String jndiName = call.getJndiName();
            if (!this.isValid(jndiName)) {
                JPARSLogger.error("jpars_invalid_jndi_name", new Object[]{jndiName});
                throw JPARSException.jndiNamePassedIsInvalid(jndiName);
            }
            InitialContext ctx = new InitialContext();
            Object ans = ctx.lookup(jndiName);
            if (ans == null) {
                JPARSLogger.error("jpars_could_not_find_session_bean", new Object[]{jndiName});
                throw JPARSException.sessionBeanCouldNotBeFound(jndiName);
            }
            PersistenceContext context = null;
            if (call.getContext() != null && (context = this.getPersistenceFactory().get(call.getContext(), uriInfo.getBaseUri(), version, null)) == null) {
                JPARSLogger.error("jpars_could_not_find_persistence_context", new Object[]{call.getContext()});
                throw JPARSException.persistenceContextCouldNotBeBootstrapped(call.getContext());
            }
            Class[] parameters = new Class[call.getParameters().size()];
            Object[] args = new Object[call.getParameters().size()];
            int i = 0;
            for (Parameter param : call.getParameters()) {
                Object parameterValue;
                Class<?> parameterClass = null;
                if (context != null) {
                    parameterClass = context.getClass(param.getTypeName());
                }
                if (parameterClass != null) {
                    parameterValue = context.unmarshalEntity(param.getTypeName(), headers.getMediaType(), is);
                } else {
                    parameterClass = Thread.currentThread().getContextClassLoader().loadClass(param.getTypeName());
                    parameterValue = ConversionManager.getDefaultManager().convertObject((Object)param.getValue(), parameterClass);
                }
                parameters[i] = parameterClass;
                args[i] = parameterValue;
                ++i;
            }
            Method method = ans.getClass().getMethod(call.getMethodName(), parameters);
            Object returnValue = method.invoke(ans, args);
            return Response.ok((Object)new StreamingOutputMarshaller(null, returnValue, headers.getAcceptableMediaTypes())).build();
        }
        catch (JAXBException | ReflectiveOperationException | RuntimeException | NamingException e) {
            JPARSLogger.exception("exception_in_callSessionBeanInternal", new Object[]{version, headers.getMediaType(), uriInfo.getRequestUri().toASCIIString()}, e);
            throw JPARSException.exceptionOccurred((Exception)e);
        }
    }

    private boolean isValid(String jndiName) {
        String protocol = null;
        int colon = jndiName.indexOf(58);
        int slash = jndiName.indexOf(47);
        if (colon > 0 && (slash == -1 || colon < slash)) {
            protocol = jndiName.substring(0, colon);
        }
        return protocol == null || protocol.isEmpty() || protocol.equalsIgnoreCase("java") || protocol.equalsIgnoreCase("ejb");
    }

    private SessionBeanCall unmarshallSessionBeanCall(InputStream data) throws JAXBException {
        Class[] jaxbClasses = new Class[]{SessionBeanCall.class};
        JAXBContext context = (JAXBContext)JAXBContextFactory.createContext((Class[])jaxbClasses, null);
        JAXBUnmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)Boolean.FALSE);
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        StreamSource ss = new StreamSource(data);
        return (SessionBeanCall)unmarshaller.unmarshal((Source)ss, SessionBeanCall.class).getValue();
    }

    private Response getContextsV1(String version, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "getContextsV1", new Object[]{"GET", version, uriInfo.getRequestUri().toASCIIString()});
        try {
            Set<String> contexts = this.getPersistenceFactory().getPersistenceContextNames();
            String mediaType = StreamingOutputMarshaller.mediaType(headers.getAcceptableMediaTypes()).toString();
            URI baseURI = uriInfo.getBaseUri();
            ArrayList<Link> links = new ArrayList<Link>();
            for (String context : contexts) {
                if (version != null) {
                    links.add(new Link(context, mediaType, baseURI + version + "/" + context + "/metadata"));
                    continue;
                }
                links.add(new Link(context, mediaType, baseURI + context + "/metadata"));
            }
            LinkList linkList = new LinkList();
            linkList.setList(links);
            String result = mediaType.equals("application/json") ? this.marshallMetadata(linkList.getList(), mediaType) : this.marshallMetadata(linkList, mediaType);
            return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, headers.getAcceptableMediaTypes())).build();
        }
        catch (JAXBException ex) {
            JPARSLogger.exception("exception_in_getContextsV1", new Object[]{version, headers.getMediaType(), uriInfo.getRequestUri().toASCIIString()}, ex);
            throw JPARSException.exceptionOccurred((Exception)((Object)ex));
        }
    }

    private Response getContextsV2(String version, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "getContextsV2", new Object[]{"GET", version, uriInfo.getRequestUri().toASCIIString()});
        try {
            ContextsCatalog result = new ContextsCatalog();
            Set<String> contexts = this.getPersistenceFactory().getPersistenceContextNames();
            for (String context : contexts) {
                Resource contextResource = new Resource();
                contextResource.setName(context);
                String href = HrefHelper.getRoot(uriInfo.getBaseUri().toString(), version, context).append("/metadata-catalog").toString();
                contextResource.setLinks(new ItemLinksBuilder().addCanonical(href).getList());
                result.addContext(contextResource);
            }
            String mediaType = StreamingOutputMarshaller.mediaType(headers.getAcceptableMediaTypes()).toString();
            String marshalled = this.marshallMetadata(result, mediaType);
            return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)marshalled, headers.getAcceptableMediaTypes())).build();
        }
        catch (JAXBException ex) {
            JPARSLogger.exception("exception_in_getContextsV2", new Object[]{version, headers.getMediaType(), uriInfo.getRequestUri().toASCIIString()}, ex);
            throw JPARSException.exceptionOccurred((Exception)((Object)ex));
        }
    }
}

