/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class ReadAllQueryCheckCacheOnlyExpiryTest
extends CacheExpiryTest {
    protected int expectedEmployees = 0;
    protected Vector returnedEmployees = null;
    protected Expression employeeExpression = null;

    public ReadAllQueryCheckCacheOnlyExpiryTest() {
        this.setDescription("Test Cache Expiry a with a checkCacheOnly ReadAllQuery.");
    }

    @Override
    public void setup() {
        super.setup();
        this.getSession().getDescriptor(Employee.class).setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(1000000L));
        this.getSession().getDescriptor(Address.class).setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(1000000L));
        this.getSession().readAllObjects(Employee.class);
        this.getSession().readAllObjects(Address.class);
        ExpressionBuilder employee = new ExpressionBuilder();
        this.employeeExpression = employee.get("gender").equal((Object)"Male");
        this.employeeExpression = this.employeeExpression.and(employee.get("address").get("country").equal((Object)"Canada"));
        Vector employees = this.getSession().readAllObjects(Employee.class, this.employeeExpression);
        this.expectedEmployees = employees.size();
        Enumeration employeeEnum = employees.elements();
        while (employeeEnum.hasMoreElements()) {
            ((Employee)employeeEnum.nextElement()).getAddress();
        }
        ExpressionBuilder smithBuilder = new ExpressionBuilder();
        employees = this.getSession().readAllObjects(Employee.class, smithBuilder.get("lastName").equal((Object)"Smith"));
        this.getAbstractSession().getIdentityMapAccessor().invalidateObjects((Collection)employees);
        this.expectedEmployees -= employees.size();
        ExpressionBuilder address = new ExpressionBuilder();
        Expression bcAddresses = address.get("province").equal((Object)"ONT");
        Vector addresses = this.getSession().readAllObjects(Address.class, bcAddresses);
        this.getAbstractSession().getIdentityMapAccessor().invalidateObjects((Collection)addresses);
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery(Employee.class, this.employeeExpression);
        query.checkCacheOnly();
        this.returnedEmployees = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        if (this.returnedEmployees.size() != this.expectedEmployees) {
            throw new TestErrorException("Check Cache Only Read All Query does not get the correct number of results from the cache");
        }
    }
}

