/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public abstract class QueryTimeoutBatchTestCase
extends TestCase {
    protected static final int TIMEOUT_INVALID = -1;
    protected long sequence_start = 40000L;
    protected boolean limitExceeded;
    protected boolean limitNotExceeded;
    protected int vendorErrorCodeEncountered;
    protected boolean unsupportedPlatform = false;
    protected boolean usesBatchWriting;
    protected boolean shouldBindAllParameters;
    protected boolean shouldCacheAllStatements;
    protected boolean usesJDBCBatchWriting;
    protected boolean usesNativeBatchWriting;
    protected boolean usesStringBinding;

    protected abstract int getParentQueryTimeout();

    protected abstract int getChildQueryTimeout();

    protected abstract int getNumberOfInserts();

    protected abstract String getQuerySQLPrefix();

    protected abstract String getQuerySQLPostfix();

    protected abstract boolean shouldBindAllParameters();

    protected abstract boolean shouldCacheAllStatements();

    protected abstract List<Employee> registerObjects(UnitOfWork var1);

    protected abstract void setDescriptorLevelQueryTimeout(DescriptorQueryManager var1);

    protected abstract void setQueryLevelQueryTimeout(UnitOfWork var1, Object var2);

    public QueryTimeoutBatchTestCase() {
        this.initialize();
    }

    protected void initialize() {
        this.limitExceeded = false;
        this.limitNotExceeded = true;
    }

    protected long getCurrentIDSequence() {
        return this.sequence_start;
    }

    protected void setCurrentIDSequence(long aSequence) {
        this.sequence_start = aSequence;
    }

    protected boolean verifyErrorCode() {
        return false;
    }

    protected int getExpectedErrorCode() {
        return 17068;
    }

    protected void initializeDatabase(UnitOfWork uow) {
        try {
            DataModifyQuery modifyQuery = new DataModifyQuery();
            String sequenceTableName = "SEQUENCE";
            if (this.getSession().getPlatform().getDefaultSequence().isTable()) {
                sequenceTableName = this.getSession().getPlatform().getQualifiedSequenceTableName();
            }
            modifyQuery.setSQLString("UPDATE " + sequenceTableName + " SET SEQ_COUNT = SEQ_COUNT + 10 WHERE SEQ_NAME = 'EMP_SEQ'");
            modifyQuery.setForceBatchStatementExecution(true);
            uow.addQuery("modify1", (DatabaseQuery)modifyQuery);
            uow.executeQuery((DatabaseQuery)modifyQuery);
            DataReadQuery readQuery = new DataReadQuery();
            readQuery.setSQLString("SELECT SEQ_COUNT FROM " + sequenceTableName + " WHERE SEQ_NAME = 'EMP_SEQ'");
            uow.addQuery("read1", (DatabaseQuery)readQuery);
            Object resultFromRead = uow.executeQuery((DatabaseQuery)readQuery);
            DatabaseRecord dbRecord = (DatabaseRecord)((Vector)resultFromRead).get(0);
            this.setCurrentIDSequence(((BigDecimal)dbRecord.get("SEQ_COUNT")).longValue());
            uow.commit();
        }
        catch (Exception e) {
            System.out.println("QueryTimeoutBatchTest could not get EMP_SEQ sequence");
            this.setCurrentIDSequence(40000L + Math.round(Math.random()));
        }
    }

    protected UnitOfWork setupPlatform() {
        Session session = this.getSession();
        DatabasePlatform platform = session.getPlatform();
        if (!this.getSession().getPlatform().usesNativeBatchWriting() || !this.getSession().getPlatform().usesNativeBatchWriting()) {
            this.unsupportedPlatform = true;
        }
        if (!platform.isOracle()) {
            System.out.println("Native batch writing is not supported on this database.");
        } else {
            this.usesBatchWriting = platform.usesBatchWriting();
            this.shouldBindAllParameters = platform.shouldBindAllParameters();
            this.shouldCacheAllStatements = platform.shouldCacheAllStatements();
            this.usesJDBCBatchWriting = platform.usesJDBCBatchWriting();
            this.usesNativeBatchWriting = platform.usesNativeBatchWriting();
            this.usesStringBinding = platform.usesStringBinding();
            platform.setUsesBatchWriting(true);
            platform.setShouldBindAllParameters(this.shouldBindAllParameters());
            platform.setShouldCacheAllStatements(this.shouldCacheAllStatements());
            platform.setUsesJDBCBatchWriting(true);
            platform.setUsesNativeBatchWriting(true);
        }
        return session.acquireUnitOfWork();
    }

    protected void resetPlatform() {
        Session session = this.getSession();
        DatabasePlatform platform = session.getPlatform();
        if (!platform.isOracle()) {
            System.out.println("Native batch writing is not supported on this database.");
        } else {
            platform.setUsesBatchWriting(this.usesBatchWriting);
            platform.setShouldBindAllParameters(this.shouldBindAllParameters);
            platform.setShouldCacheAllStatements(this.shouldCacheAllStatements);
            platform.setUsesJDBCBatchWriting(this.usesJDBCBatchWriting);
            platform.setUsesNativeBatchWriting(this.usesNativeBatchWriting);
            platform.setUsesStringBinding(this.usesStringBinding);
        }
    }

    public void verifyBefore(UnitOfWork uow) {
    }

    public void verify() {
        if (!this.limitExceeded || this.verifyErrorCode() && this.getExpectedErrorCode() != this.vendorErrorCodeEncountered) {
            throw new TestErrorException("Batch timeout did not occur.");
        }
    }

    protected List updateObjects(List objectListForEditing, UnitOfWork uow) {
        return new ArrayList();
    }
}

