/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ShallowModifyTest
extends TestCase {
    protected Employee employeeFromDatabase;
    protected String addressCity;
    protected Number addressId;

    protected void setup() {
        this.beginTransaction();
        this.employeeFromDatabase = (Employee)this.getSession().readObject(Employee.class);
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }

    public void test() {
        Address address = this.employeeFromDatabase.getAddress();
        this.addressCity = address.getCity();
        this.addressId = address.getId();
        address.setCity("Chelmsford");
        UpdateObjectQuery query = new UpdateObjectQuery();
        query.setObject((Object)this.employeeFromDatabase);
        query.dontCascadeParts();
        this.getSession().executeQuery((DatabaseQuery)query);
    }

    protected void verify() {
        Expression expression = new ExpressionBuilder().get("id").equal(this.addressId.intValue());
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Address address = (Address)this.getSession().readObject(Address.class, expression);
        if (!address.getCity().equals(this.addressCity)) {
            throw new TestErrorException("The shallow modify test failed.  The private owned relationship has been modified");
        }
    }
}

