/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.inheritance;

import java.util.Collection;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.inheritance.GrassHopper;
import org.eclipse.persistence.testing.models.inheritance.Insect;

public class PaginationInheritanceTest
extends TestCase {
    public PaginationInheritanceTest() {
        this.setDescription("Verifies that inheritance queries are well formed with pagination.");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Insect.class);
        ExpressionBuilder expression = query.getExpressionBuilder();
        Expression filter = expression.treat(GrassHopper.class).get("gh_maximumJump").equal(5);
        query.setFirstResult(0);
        query.setMaxRows(10);
        query.setSelectionCriteria(filter);
        try {
            Collection collection = (Collection)this.getAbstractSession().executeQuery((DatabaseQuery)query);
        }
        catch (DatabaseException ex) {
            throw new TestErrorException("Failed to fetch results with downcasting and pagination. " + ex.getMessage());
        }
    }
}

