/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.customsqlstoredprocedures;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.StoredFunctionCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.models.legacy.Employee;
import org.eclipse.persistence.testing.models.legacy.LegacySystem;
import org.eclipse.persistence.testing.models.mapping.MappingSystem;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.CacheHitTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.CustomSQLCursoredStreamReadTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.CustomSQLSubQueryTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.DataReadQueryTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.EmployeeCustomSQLSystem;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.InsuranceORStoredProcedureSystem;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.OutputParameterEventTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.ReadObjectQueryTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.SetCustomSQLQueryTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.StoredProcWithOutputParamsAndResultSetTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.StoredProcedureARRAYTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.StoredProcedureNoParametersTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.StoredProcedureNullInOutTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.StoredProcedureORParametersClientSessionTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.StoredProcedureObjectRelationalParameters;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.StoredProcedureResultSetAndOutputTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.StoredProcedureTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.StoredProcedureTest_Inout_Out_In;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.StoredProcedureTimestampTest;
import org.eclipse.persistence.testing.tests.customsqlstoredprocedures.StoredProcedureVARRAYParametersTest;
import org.eclipse.persistence.testing.tests.employee.EmployeeDeleteTest;
import org.eclipse.persistence.testing.tests.employee.ProjectDeleteTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class CustomSQLTestModel
extends TestModel {
    public CustomSQLTestModel() {
        this.setDescription("This model tests reading/writing/deleting  using Custom SQL with the employee demo.");
    }

    public CustomSQLTestModel(String description) {
        this.setDescription(description);
    }

    public void addForcedRequiredSystems() {
        this.getExecutor().removeConfigureSystem((TestSystem)new EmployeeSystem());
        this.addForcedRequiredSystem(new EmployeeCustomSQLSystem());
        if (this.getSession().getPlatform().isOracle()) {
            this.addForcedRequiredSystem(new InsuranceORStoredProcedureSystem());
        }
        if (this.getSession().getPlatform().isPostgreSQL()) {
            this.getSession().getPlatform().setShouldForceFieldNamesToUpperCase(true);
        }
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new LegacySystem());
    }

    public void addTests() {
        this.addTest((Test)CustomSQLTestModel.getReadObjectTestSuite());
        this.addTest((Test)this.getRefreshObjectTestSuite());
        this.addTest((Test)CustomSQLTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)CustomSQLTestModel.getReadAllTestSuite());
        this.addTest((Test)CustomSQLTestModel.getInsertObjectTestSuite());
        this.addTest((Test)CustomSQLTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)this.getSelectWithOutputParametersTestSuite());
        this.addTest((Test)this.getOutputParametersTestSuite());
        this.addTest((Test)CustomSQLTestModel.getStoredProcedureTestSuite());
        this.addTest((Test)CustomSQLTestModel.getStoredFunctionTestSuite());
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CustomSQLDeleteObjectTestSuite");
        suite.setDescription("This suite tests delete SQL.");
        Class<org.eclipse.persistence.testing.models.employee.domain.Employee> employeeClass = org.eclipse.persistence.testing.models.employee.domain.Employee.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(SmallProject.class, "0003")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(LargeProject.class, "0001")));
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CustomSQLInsertObjectTestSuite");
        suite.setDescription("This suite tests insert SQL.");
        EmployeePopulator system = new EmployeePopulator();
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample4()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample5()));
        return suite;
    }

    public TestSuite getOutputParametersTestSuite() {
        TestSuite test = new TestSuite();
        test.setDescription("This Suite is used to test special Output Parameter functions ");
        test.setName("OutputParametersTestSuite");
        test.addTest((Test)new OutputParameterEventTest((org.eclipse.persistence.testing.models.employee.domain.Employee)new EmployeePopulator().basicEmployeeExample10()));
        return test;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CustomSQLReadAllTestSuite");
        suite.setDescription("This suite tests read all sql.");
        suite.addTest((Test)new ReadAllTest(org.eclipse.persistence.testing.models.employee.domain.Employee.class, 12));
        suite.addTest((Test)new CustomSQLSubQueryTest());
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CustomSQLReadObjectTestSuite");
        suite.setDescription("This suite test read sql.");
        Class<org.eclipse.persistence.testing.models.employee.domain.Employee> employeeClass = org.eclipse.persistence.testing.models.employee.domain.Employee.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new CacheHitTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new CustomSQLCursoredStreamReadTest());
        return suite;
    }

    public TestSuite getRefreshObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("RefreshObjectTestSuite");
        suite.setDescription("This Suite contains tests that verify that Refreshing of Objects is working correctly");
        Class<org.eclipse.persistence.testing.models.employee.domain.Employee> employeeClass = org.eclipse.persistence.testing.models.employee.domain.Employee.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectQueryTest((org.eclipse.persistence.testing.models.employee.domain.Employee)manager.getObject(employeeClass, "0003")));
        return suite;
    }

    public TestSuite getSelectWithOutputParametersTestSuite() {
        TestSuite test = new TestSuite();
        test.setDescription("This Suite is used to test special Output Parameter functions when using selecting queries");
        test.setName("SelectWithOutputParametersTestSuite");
        test.addTest((Test)new DataReadQueryTest());
        test.addTest((Test)new StoredProcWithOutputParamsAndResultSetTest(false, false));
        test.addTest((Test)new StoredProcWithOutputParamsAndResultSetTest(false, true));
        test.addTest((Test)new StoredProcWithOutputParamsAndResultSetTest(true, false));
        test.addTest((Test)new StoredProcWithOutputParamsAndResultSetTest(true, true));
        return test;
    }

    public static TestSuite getStoredProcedureTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CustomSQLStoredProcedureTestSuite");
        suite.setDescription("This suite tests certains aspects of StoredProcedures");
        Class<org.eclipse.persistence.testing.models.employee.domain.Employee> employeeClass = org.eclipse.persistence.testing.models.employee.domain.Employee.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new CacheHitTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new StoredProcedureTest());
        suite.addTest((Test)new StoredProcedureTest(false));
        suite.addTest((Test)new StoredProcedureTimestampTest());
        suite.addTest((Test)new StoredProcedureTimestampTest(false));
        suite.addTest((Test)StoredProcedureTest_Inout_Out_In.procUseCustomSQL(false));
        suite.addTest((Test)StoredProcedureTest_Inout_Out_In.procUseCustomSQL(true));
        suite.addTest((Test)StoredProcedureTest_Inout_Out_In.proc(false, false));
        suite.addTest((Test)StoredProcedureTest_Inout_Out_In.proc(false, true));
        suite.addTest((Test)StoredProcedureTest_Inout_Out_In.proc(true, false));
        suite.addTest((Test)StoredProcedureTest_Inout_Out_In.proc(true, true));
        suite.addTest((Test)StoredProcedureTest_Inout_Out_In.funcUseCustomSQL(false));
        suite.addTest((Test)StoredProcedureTest_Inout_Out_In.funcUseCustomSQL(true));
        suite.addTest((Test)StoredProcedureTest_Inout_Out_In.func(false, false));
        suite.addTest((Test)StoredProcedureTest_Inout_Out_In.func(false, true));
        suite.addTest((Test)StoredProcedureTest_Inout_Out_In.func(true, false));
        suite.addTest((Test)StoredProcedureTest_Inout_Out_In.func(true, true));
        suite.addTest((Test)new StoredProcedureARRAYTest());
        suite.addTest((Test)new StoredProcedureNullInOutTest());
        suite.addTest((Test)new StoredProcedureNullInOutTest(false));
        suite.addTest((Test)new StoredProcedureResultSetAndOutputTest());
        suite.addTest((Test)new StoredProcedureResultSetAndOutputTest(false));
        suite.addTest((Test)new StoredProcedureNoParametersTest());
        suite.addTest((Test)new StoredProcedureObjectRelationalParameters(false));
        suite.addTest((Test)new StoredProcedureObjectRelationalParameters(true));
        suite.addTest((Test)new StoredProcedureVARRAYParametersTest(false));
        suite.addTest((Test)new StoredProcedureVARRAYParametersTest(true));
        suite.addTest((Test)new StoredProcedureORParametersClientSessionTest());
        suite.addTest((Test)CustomSQLTestModel.buildSQLTransactionTest());
        suite.addTest((Test)CustomSQLTestModel.build2OutCursorTest());
        suite.addTest((Test)CustomSQLTestModel.buildUnnamedCursorTest());
        suite.addTest((Test)CustomSQLTestModel.build2ResultSetTest());
        return suite;
    }

    public static TestSuite getStoredFunctionTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CustomSQLStoredFunctionTestSuite");
        suite.setDescription("This suite tests certains aspects of StoredFunction");
        suite.addTest((Test)CustomSQLTestModel.buildStoredFunctionRefCursorTest());
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CustomSQLUpdateObjectTestSuite");
        suite.setDescription("This suite tests update sql.");
        Class<org.eclipse.persistence.testing.models.employee.domain.Employee> employeeClass = org.eclipse.persistence.testing.models.employee.domain.Employee.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(SmallProject.class, "0003")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(LargeProject.class, "0001")));
        suite.addTest((Test)new SetCustomSQLQueryTest("UPDATE EMPLOYEE SET F_NAME = 'Fatima?' WHERE L_NAME = 'Smith'"));
        Vector<String> v = new Vector<String>();
        v.addElement("L_NAME");
        Vector<String> myV = new Vector<String>();
        myV.addElement("Smith");
        suite.addTest((Test)new SetCustomSQLQueryTest("UPDATE EMPLOYEE SET F_NAME = 'Fatima' WHERE L_NAME = #L_NAME", v, myV));
        return suite;
    }

    public void reset() {
        this.getExecutor().removeConfigureSystem((TestSystem)new EmployeeCustomSQLSystem());
        new EmployeeSystem().addDescriptors(this.getDatabaseSession());
        new MappingSystem().addDescriptors(this.getDatabaseSession());
    }

    public void setup() {
        ClassDescriptor empDescriptor = this.getSession().getClassDescriptor(Employee.class);
        empDescriptor.getQueryManager().setReadObjectSQLString("select LEG_EMP.*, LEG_ADD.* FROM LEG_EMP, LEG_ADD WHERE (((LEG_EMP.FNAME = #LEG_EMP.FNAME) AND (LEG_EMP.LNAME = #LEG_EMP.LNAME)) AND ((LEG_ADD.FIRST_NM = #LEG_EMP.FNAME) AND (LEG_ADD.LNAME = #LEG_EMP.LNAME)))");
    }

    public static TestCase buildSQLTransactionTest() {
        TestCase test = new TestCase(){

            public void test() {
                UnitOfWork uow = this.getSession().acquireUnitOfWork();
                uow.executeNonSelectingSQL("Insert into ADDRESS (ADDRESS_ID) values (999999)");
                uow.commit();
                try {
                    if (this.getAbstractSession().isInTransaction() || this.getSession().executeSQL("Select * from ADDRESS where ADDRESS_ID = 999999").size() == 0) {
                        this.throwError("Database transaction not committed.");
                    }
                }
                finally {
                    uow = this.getSession().acquireUnitOfWork();
                    uow.executeNonSelectingSQL("Delete from ADDRESS where ADDRESS_ID = 999999");
                    uow.commit();
                }
            }
        };
        test.setName("SQLTransactionTest");
        return test;
    }

    public static TestCase build2OutCursorTest() {
        TestCase test = new TestCase(){

            public void test() {
                if (!this.getSession().getPlatform().isOracle()) {
                    this.throwWarning("This test can only be run in Oracle");
                }
                DataReadQuery query = new DataReadQuery();
                StoredProcedureCall call = new StoredProcedureCall();
                call.setProcedureName("Read_Emp_Add");
                call.getProcedureArgumentNames().add("CUR1");
                call.appendOutCursor(new DatabaseField("CUR1"));
                call.getProcedureArgumentNames().add("CUR2");
                call.appendOutCursor(new DatabaseField("CUR2"));
                query.setCall((Call)call);
                List result = (List)this.getSession().executeQuery((DatabaseQuery)query);
                if (!(((Map)result.get(0)).get("CUR1") instanceof List)) {
                    this.throwError("CUR1 not in output");
                }
                if (!(((Map)result.get(0)).get("CUR2") instanceof List)) {
                    this.throwError("CUR2 not in output");
                }
            }
        };
        test.setName("2OutCursorTest");
        return test;
    }

    public static TestCase buildUnnamedCursorTest() {
        TestCase test = new TestCase(){

            public void test() {
                if (!this.getSession().getPlatform().isOracle()) {
                    this.throwWarning("This test can only be run in Oracle");
                }
                DataReadQuery query = new DataReadQuery();
                StoredProcedureCall call = new StoredProcedureCall();
                call.setProcedureName("Read_All_Employees");
                call.useUnnamedCursorOutputAsResultSet();
                query.setCall((Call)call);
                List result = (List)this.getSession().executeQuery((DatabaseQuery)query);
                result.size();
                result = (List)this.getSession().executeQuery((DatabaseQuery)query);
            }
        };
        test.setName("UnnamedCursorTest");
        return test;
    }

    public static TestCase build2ResultSetTest() {
        TestCase test = new TestCase(){

            public void test() {
                if (!this.getSession().getPlatform().isMySQL()) {
                    this.throwWarning("This test can only be run in MySQL");
                }
                DataReadQuery query = new DataReadQuery();
                StoredProcedureCall call = new StoredProcedureCall();
                call.setProcedureName("Read_Emp_Add");
                call.setHasMultipleResultSets(true);
                query.setCall((Call)call);
                List result = (List)this.getSession().executeQuery((DatabaseQuery)query);
                if (result.size() != this.getSession().readAllObjects(org.eclipse.persistence.testing.models.employee.domain.Employee.class).size() + this.getSession().readAllObjects(Address.class).size()) {
                    this.throwError("Incorrect number of rows returned : " + result);
                }
                result = (List)this.getSession().executeQuery((DatabaseQuery)query);
            }
        };
        test.setName("2ResultSetTest");
        return test;
    }

    public static TestCase buildStoredFunctionRefCursorTest() {
        TestCase test = new TestCase(){

            public void test() {
                if (!this.getSession().getPlatform().isOracle()) {
                    this.throwWarning("This test can only be run in Oracle");
                }
                StoredFunctionCall call = new StoredFunctionCall();
                call.setProcedureName("PackageFunction_ResultCursor.BUSINESS_DATE");
                call.addNamedArgument("P_CODE");
                call.addNamedArgument("P_LOOKUP_TBL", "P_LOOKUP_TBL", 2003, "SF_LOOKUP_TBL");
                call.setResultCursor();
                DataReadQuery query = new DataReadQuery();
                query.setCall((Call)call);
                query.addArgument("P_CODE");
                query.addArgument("P_LOOKUP_TBL");
                Object[] data = new Object[]{"5-Jul-13", 5L};
                ArrayList<Object> args = new ArrayList<Object>();
                args.add("CN");
                args.add(new Object[]{data});
                List result = (List)this.getSession().executeQuery((DatabaseQuery)query, args);
                if (result == null || result.size() != 1) {
                    this.throwError("Incorrect number of rows returned: " + result);
                }
            }
        };
        test.setName("StoredFunctionRefCursorTest");
        return test;
    }
}

