/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.simple.sequencing;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicTypeBuilder;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicTestHelper;
import org.eclipse.persistence.testing.tests.jpa.dynamic.simple.sequencing.BaseSequencingTestSuite;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public class DefaultSequencingTestSuite
extends BaseSequencingTestSuite {
    @BeforeClass
    public static void setUp() {
        emf = DynamicTestHelper.createEMF("dynamic");
        helper = new JPADynamicHelper(emf);
        DynamicClassLoader dcl = helper.getDynamicClassLoader();
        Class javaType = dcl.createDynamicClass("model.sequencing.Simple");
        JPADynamicTypeBuilder typeBuilder = new JPADynamicTypeBuilder(javaType, null, new String[]{"SIMPLE_TABLE_SEQ"});
        typeBuilder.setPrimaryKeyFields(new String[]{"SID"});
        typeBuilder.addDirectMapping("id", Integer.TYPE, "SID");
        typeBuilder.addDirectMapping("value1", String.class, "VAL_1");
        TableSequence defaultSequence = (TableSequence)helper.getSession().getLogin().getDefaultSequence();
        defaultSequence.setTableName("TEST_SEQ");
        typeBuilder.configureSequencing("Simple_SEQ", "SID");
        helper.addTypes(true, true, new DynamicType[]{typeBuilder.getType()});
    }

    @AfterClass
    public static void tearDown() {
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.createNativeQuery("DROP TABLE SIMPLE_TABLE_SEQ").executeUpdate();
        em.createNativeQuery("DROP TABLE TEST_SEQ").executeUpdate();
        em.getTransaction().commit();
        em.close();
        emf.close();
    }

    @Before
    public void clearSimpleTypeInstances() {
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.createQuery("DELETE FROM Simple").executeUpdate();
        em.createNativeQuery("UPDATE TEST_SEQ SET SEQ_COUNT = 0").executeUpdate();
        em.getTransaction().commit();
        em.close();
        JpaHelper.getServerSession((EntityManagerFactory)emf).getSequencingControl().initializePreallocated();
    }
}

