/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.validation.Client;
import org.eclipse.persistence.testing.tests.validation.Server;

public class ClientServerTest
extends AutoVerifyTestCase {
    protected DatabaseLogin login;
    protected Client[] clients;
    protected Server server;
    protected int numberOfClients;
    protected int minimumConnections;
    protected int maximumConnections;

    public ClientServerTest(int number) {
        this(number, 2, 4);
    }

    public ClientServerTest(int number, int min, int max) {
        this.numberOfClients = number;
        this.minimumConnections = min;
        this.maximumConnections = max;
        this.clients = new Client[this.numberOfClients];
        this.setName(this.getName() + "(" + this.numberOfClients + " clients, min: " + min + " max: " + max + ")");
        this.setDescription("This test spawns clients and releases the client sessions many times to ensure that too many connections are not being disconnected.");
    }

    public void reset() throws Exception {
        block3: {
            try {
                for (int i = 0; i < this.numberOfClients; ++i) {
                    this.clients[i].release();
                }
                this.server.logout();
                ((DatabaseSession)this.getSession()).logout();
                ((DatabaseSession)this.getSession()).login();
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block3;
                this.verify();
            }
        }
    }

    public void setup() throws Exception {
        block3: {
            try {
                this.login = (DatabaseLogin)this.getSession().getLogin().clone();
                this.server = new Server(this.login, this.minimumConnections, this.maximumConnections);
                this.server.serverSession.setLogLevel(this.getSession().getLogLevel());
                this.server.serverSession.setLog(this.getSession().getLog());
                this.server.login();
                for (int i = 0; i < this.numberOfClients; ++i) {
                    this.clients[i] = new Client(this.server, "Client " + i, this.getSession());
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block3;
                this.verify();
            }
        }
    }

    public void test() {
        block6: {
            try {
                int i;
                for (i = 0; i < this.numberOfClients; ++i) {
                    this.clients[i].run();
                }
                try {
                    for (i = 0; i < this.numberOfClients; ++i) {
                        this.clients[i].join();
                    }
                }
                catch (InterruptedException exception) {
                    TestErrorException testException = new TestErrorException("Client threads are interrupted");
                    testException.setInternalException((Throwable)exception);
                    throw testException;
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block6;
                this.verify();
            }
        }
    }

    public void verify() {
        try {
            int counter = 0;
            ConnectionPool pool = (ConnectionPool)this.server.serverSession.getConnectionPools().get("default");
            List connections = pool.getConnectionsAvailable();
            Iterator iterator = connections.iterator();
            while (iterator.hasNext()) {
                if (!((Accessor)iterator.next()).isConnected()) continue;
                ++counter;
            }
            if (counter < this.minimumConnections) {
                throw new TestErrorException("too many connections are disconnected!!");
            }
            if (counter > this.minimumConnections) {
                throw new TestErrorException("not enough connections are disconected!!");
            }
            if (connections.size() < this.minimumConnections) {
                throw new TestErrorException("too many connections are released!!");
            }
            if (connections.size() > this.minimumConnections) {
                throw new TestErrorException("not enough connections are released!!");
            }
        }
        catch (Exception ex) {
            if (!(ex instanceof ValidationException) || ((ValidationException)((Object)ex)).getErrorCode() == 7090) {
                // empty if block
            }
        }
    }
}

