/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm;

import java.util.Hashtable;
import junit.framework.Test;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.coordination.CommandProcessor;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.optimisticlocking.OptimisticLockingSystem;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.ChangeObjectNotSentTest;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.ConfigurableUpdateChangeObjectTest;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.DeleteObjectNotSentTest;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.InvalidateObjectWithMissingReferenceTest;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.IsolatedObjectNotSentTest;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.MultipleCacheSyncTypeTest;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.NativeUpdateObjectInvalidationTest;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.NewObjectWithOptimisticLockingTest;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.OrderedListNewObjectTest;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.RCMDistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.RelatedNewObjectCacheSyncTest;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.RelatedNewObjectNotSentTest;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.SendNewObjectCacheSyncTest;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.UpdateObjectInvalidationTest;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmployee;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedSessionSystem;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class RCMDistributedServersModel
extends DistributedServersModel {
    public RCMDistributedServersModel() {
        this.setDescription("Tests cache synchronization with RCM.");
    }

    @Override
    public void addRequiredSystems() {
        super.addRequiredSystems();
        this.addRequiredSystem(new IsolatedSessionSystem());
        this.addRequiredSystem(new OptimisticLockingSystem());
    }

    @Override
    public DistributedServer createDistributedServer(Session session) {
        return new RCMDistributedServer((DatabaseSession)session);
    }

    @Override
    public void addTests() {
        super.addTests();
        PopulationManager manager = PopulationManager.getDefaultManager();
        Employee employee = (Employee)manager.getObject(Employee.class, "0001");
        Hashtable<Class<IsolatedEmployee>, Integer> configurationHashtable = new Hashtable<Class<IsolatedEmployee>, Integer>();
        configurationHashtable.put(Employee.class, 2);
        ConfigurableUpdateChangeObjectTest test = new ConfigurableUpdateChangeObjectTest(employee, configurationHashtable);
        test.setName("Update Change Employee - Invalidate Employee");
        test.setDescription("Test the invalidation setting on cache synchronization for Employee");
        this.addTest((Test)test);
        configurationHashtable = new Hashtable();
        configurationHashtable.put(PhoneNumber.class, 2);
        configurationHashtable.put(Employee.class, 2);
        test = new ConfigurableUpdateChangeObjectTest(employee, configurationHashtable);
        test.setName("Update Change Employee - Invalidate Employee, Phone Number");
        test.setDescription("Test the invalidation setting on cache synchronization for Phone Number");
        this.addTest((Test)test);
        this.addTest((Test)new SendNewObjectCacheSyncTest(true));
        this.addTest((Test)new SendNewObjectCacheSyncTest(false));
        this.addTest((Test)new RelatedNewObjectCacheSyncTest());
        this.addTest((Test)new MultipleCacheSyncTypeTest());
        this.addTest((Test)new RelatedNewObjectNotSentTest());
        this.addTest((Test)new DeleteObjectNotSentTest());
        this.addTest((Test)new ChangeObjectNotSentTest());
        this.addTest((Test)new IsolatedObjectNotSentTest());
        configurationHashtable = new Hashtable();
        configurationHashtable.put(IsolatedEmployee.class, 1);
        IsolatedObjectNotSentTest atest = new IsolatedObjectNotSentTest(configurationHashtable);
        atest.setName("IsolatedObjectNotSentTest - SEND_OBJECT_CHANGES");
        this.addTest((Test)atest);
        configurationHashtable = new Hashtable();
        configurationHashtable.put(IsolatedEmployee.class, 2);
        atest = new IsolatedObjectNotSentTest(configurationHashtable);
        atest.setName("IsolatedObjectNotSentTest - INVALIDATE_CHANGED_OBJECTS");
        this.addTest((Test)atest);
        configurationHashtable = new Hashtable();
        configurationHashtable.put(IsolatedEmployee.class, 3);
        atest = new IsolatedObjectNotSentTest(configurationHashtable);
        atest.setName("IsolatedObjectNotSentTest - SEND_NEW_OBJECTS_WITH_CHANGES");
        this.addTest((Test)atest);
        configurationHashtable = new Hashtable();
        configurationHashtable.put(IsolatedEmployee.class, 4);
        atest = new IsolatedObjectNotSentTest(configurationHashtable);
        atest.setName("IsolatedObjectNotSentTest - DO_NOT_SEND_CHANGES");
        this.addTest((Test)atest);
        this.addTest((Test)new InvalidateObjectWithMissingReferenceTest());
        this.addTest((Test)new UpdateObjectInvalidationTest());
        this.addTest((Test)new NativeUpdateObjectInvalidationTest());
        this.addTest((Test)new NewObjectWithOptimisticLockingTest());
        this.addTest((Test)new OrderedListNewObjectTest());
    }

    @Override
    public void startCacheSynchronization() {
        RemoteCommandManager cm = new RemoteCommandManager((CommandProcessor)((AbstractSession)this.getSession()));
        cm.setShouldPropagateAsynchronously(false);
        cm.getDiscoveryManager().setAnnouncementDelay(0);
        cm.getTransportManager().setNamingServiceType(1);
        cm.setUrl("rmi://localhost:1099");
        ((AbstractSession)this.getSession()).setShouldPropagateChanges(true);
        cm.setServerPlatform(this.getSession().getServerPlatform());
        cm.initialize();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void stopCacheSynchronization() {
        ((AbstractSession)this.getSession()).getCommandManager().shutdown();
        ((AbstractSession)this.getSession()).setCommandManager(null);
    }
}

