/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.mapping.Identification;
import org.eclipse.persistence.testing.models.mapping.SecureSystem;

public class SameNamePKTest
extends TestCase {
    protected Long systemId = null;
    protected SecureSystem system = null;
    protected Exception exception = null;

    public void setup() {
        this.beginTransaction();
        SecureSystem system = new SecureSystem();
        system.setManufacturer("Secure Systems Inc.");
        Identification identification = new Identification();
        identification.setId(1L);
        system.setId(identification);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)system);
        uow.commit();
        this.systemId = identification.getId();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        ReadObjectQuery query = new ReadObjectQuery(SecureSystem.class);
        ExpressionBuilder aBuilder = new ExpressionBuilder();
        Expression exp = aBuilder.get("id").get("id").equal((Object)this.systemId);
        query.setSelectionCriteria(exp);
        try {
            this.system = (SecureSystem)this.getSession().executeQuery((DatabaseQuery)query);
        }
        catch (DescriptorException e) {
            this.exception = e;
        }
    }

    public void verify() {
        if (this.exception != null) {
            throw new TestErrorException("An exception was thrown while trying to query across two attributes of the same name.", (Throwable)this.exception);
        }
        if (this.system == null) {
            throw new TestErrorException("No result retrieved when trying to query across two attributes of the same name.");
        }
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.exception = null;
        this.system = null;
    }
}

