/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.simple.sequencing;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.IdentityMapAccessor;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSequencingTestSuite {
    public static final String TABLE_NAME = "SIMPLE_TABLE_SEQ";
    public static final String SEQ_TABLE_NAME = "TEST_SEQ";
    public static final String ENTITY_TYPE = "Simple";
    static DatabaseSession session = null;
    static DynamicHelper dynamicHelper = null;

    @Test
    public void verifyConfig() throws Exception {
        ClassDescriptor descriptor = dynamicHelper.getSession().getClassDescriptorForAlias(ENTITY_TYPE);
        Assert.assertNotNull((String)"No descriptor found for alias: Simple", (Object)descriptor);
        DynamicType simpleType = dynamicHelper.getType(ENTITY_TYPE);
        Assert.assertNotNull((String)"EntityType not found for alias: Simple", (Object)simpleType);
        Assert.assertEquals((Object)descriptor, (Object)simpleType.getDescriptor());
        Assert.assertTrue((String)"Descriptor does not use sequencing", (boolean)descriptor.usesSequenceNumbers());
        this.verifySequencingConfig((Session)dynamicHelper.getSession(), descriptor);
    }

    protected void verifySequencingConfig(Session session, ClassDescriptor descriptor) {
    }

    @Test
    public void createSingleInstances() throws Exception {
        DynamicEntity simpleInstance = this.createSimpleInstance(dynamicHelper, (Session)session, 1);
        ReportQuery countQuery = dynamicHelper.newReportQuery(ENTITY_TYPE, new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        Assert.assertEquals((long)1L, (long)this.count(dynamicHelper, (Session)session));
        IdentityMapAccessor cache = session.getIdentityMapAccessor();
        Assert.assertTrue((boolean)cache.containsObjectInIdentityMap((Object)simpleInstance));
        cache.initializeAllIdentityMaps();
        DynamicEntity findResult = this.find(dynamicHelper, (Session)session, 1);
        Assert.assertNotNull((Object)findResult);
        Assert.assertEquals((Object)simpleInstance.get("id"), (Object)findResult.get("id"));
        Assert.assertEquals((Object)simpleInstance.get("value1"), (Object)findResult.get("value1"));
        session.release();
    }

    @Test
    public void createTwoInstances() throws DatabaseException, Exception {
        DynamicEntity simpleInstance1 = this.createSimpleInstance(dynamicHelper, (Session)session, 1);
        DynamicEntity simpleInstance2 = this.createSimpleInstance(dynamicHelper, (Session)session, 2);
        ReportQuery countQuery = dynamicHelper.newReportQuery(ENTITY_TYPE, new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        Assert.assertEquals((long)2L, (long)this.count(dynamicHelper, (Session)session));
        IdentityMapAccessor cache = session.getIdentityMapAccessor();
        Assert.assertTrue((boolean)cache.containsObjectInIdentityMap((Object)simpleInstance1));
        Assert.assertTrue((boolean)cache.containsObjectInIdentityMap((Object)simpleInstance2));
        cache.initializeAllIdentityMaps();
        DynamicEntity findResult1 = this.find(dynamicHelper, (Session)session, 1);
        DynamicEntity findResult2 = this.find(dynamicHelper, (Session)session, 2);
        Assert.assertNotNull((Object)findResult1);
        Assert.assertNotNull((Object)findResult2);
        Assert.assertEquals((Object)simpleInstance1.get("id"), (Object)findResult1.get("id"));
        Assert.assertEquals((Object)simpleInstance2.get("value1"), (Object)findResult2.get("value1"));
        session.release();
    }

    protected DynamicEntity find(DynamicHelper helper, Session session, int id) {
        ReadObjectQuery findQuery = helper.newReadObjectQuery(ENTITY_TYPE);
        findQuery.setSelectionCriteria(findQuery.getExpressionBuilder().get("id").equal(id));
        return (DynamicEntity)session.executeQuery((DatabaseQuery)findQuery);
    }

    protected int count(DynamicHelper helper, Session session) {
        ReportQuery countQuery = helper.newReportQuery(ENTITY_TYPE, new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        return ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
    }

    protected DynamicEntity createSimpleInstance(DynamicHelper helper, Session session, int expectedId) {
        DynamicType simpleEntityType = helper.getType(ENTITY_TYPE);
        Assert.assertNotNull((Object)simpleEntityType);
        DynamicEntity simpleInstance = simpleEntityType.newDynamicEntity();
        simpleInstance.set("value1", (Object)TABLE_NAME);
        UnitOfWork uow = session.acquireUnitOfWork();
        Assert.assertEquals((long)0L, (long)((Number)simpleInstance.get("id")).intValue());
        uow.registerNewObject((Object)simpleInstance);
        Assert.assertEquals((long)0L, (long)((Number)simpleInstance.get("id")).intValue());
        uow.commit();
        Assert.assertEquals((long)expectedId, (long)((Number)simpleInstance.get("id")).intValue());
        return simpleInstance;
    }
}

