/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo.change;

import com.sleepycat.persist.model.Persistent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.TopologyChange;
import oracle.kv.impl.util.ObjectUtil;

@Persistent
public class Remove
extends TopologyChange {
    private static final long serialVersionUID = 1L;
    private ResourceId resourceId;

    public Remove(int sequenceNumber, ResourceId resourceId) {
        super(sequenceNumber);
        ObjectUtil.checkNull("resourceId", resourceId);
        this.resourceId = resourceId;
    }

    Remove(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.resourceId = ResourceId.readFastExternal(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.resourceId.writeFastExternal(out, serialVersion);
    }

    private Remove() {
    }

    @Override
    public TopologyChange.Type getType() {
        return TopologyChange.Type.REMOVE;
    }

    @Override
    public ResourceId getResourceId() {
        return this.resourceId;
    }

    @Override
    public Topology.Component<?> getComponent() {
        return null;
    }

    @Override
    public Remove clone() {
        return new Remove(this.sequenceNumber, this.resourceId);
    }
}

