/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Queue;
import oracle.kv.impl.async.BytesInput;

class NioBytesInput
implements BytesInput {
    private int remaining;
    private final Queue<ByteBuffer> bufQueue;

    NioBytesInput(int remaining, Queue<ByteBuffer> bufQueue) {
        this.remaining = remaining;
        this.bufQueue = bufQueue;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws EOFException {
        if (len == 0) {
            return;
        }
        if (this.remaining < len) {
            throw new EOFException();
        }
        Iterator iter = this.bufQueue.iterator();
        while (iter.hasNext()) {
            ByteBuffer buf = (ByteBuffer)iter.next();
            int n = Math.min(len, buf.remaining());
            buf.get(b, off, n);
            len -= n;
            off += n;
            this.remaining -= n;
            if (buf.remaining() == 0) {
                iter.remove();
            }
            if (len != 0) continue;
            break;
        }
    }

    @Override
    public void skipBytes(int n) throws EOFException {
        if (this.remaining < n) {
            throw new EOFException();
        }
        Iterator iter = this.bufQueue.iterator();
        while (iter.hasNext()) {
            ByteBuffer buf = (ByteBuffer)iter.next();
            int toskip = Math.min(n, buf.remaining());
            buf.position(buf.position() + toskip);
            n -= toskip;
            this.remaining -= toskip;
            if (buf.remaining() == 0) {
                iter.remove();
            }
            if (n != 0) continue;
            break;
        }
    }

    @Override
    public byte readByte() throws EOFException {
        if (this.remaining == 0) {
            throw new EOFException();
        }
        Iterator iter = this.bufQueue.iterator();
        while (iter.hasNext()) {
            ByteBuffer buf = (ByteBuffer)iter.next();
            if (buf.remaining() != 0) {
                --this.remaining;
                return buf.get();
            }
            iter.remove();
        }
        throw new EOFException();
    }

    @Override
    public int remaining() {
        return this.remaining;
    }

    @Override
    public void release() {
        this.bufQueue.clear();
    }
}

