/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.merge.relationships;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.merge.relationships.Customer;
import org.eclipse.persistence.testing.models.jpa.xml.merge.relationships.Item;
import org.eclipse.persistence.testing.models.jpa.xml.merge.relationships.Order;
import org.eclipse.persistence.testing.models.jpa.xml.merge.relationships.PartsList;
import org.eclipse.persistence.testing.models.jpa.xml.merge.relationships.RelationshipsTableManager;

public class EntityMappingsMergeRelationshipsJUnitTestCase
extends JUnitTestCase {
    private static Integer customerId;
    private static Integer itemId;
    private static Integer orderId;

    public EntityMappingsMergeRelationshipsJUnitTestCase() {
    }

    public EntityMappingsMergeRelationshipsJUnitTestCase(String name) {
        super(name);
    }

    public void setUp() {
        try {
            super.setUp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Relationships Model");
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testSetup"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testCustomerOrdersMapping"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testOrderCustomerMapping"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testItemNameMapping"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testCreateCustomer"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testCreateItem"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testCreateOrder"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testReadCustomer"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testReadItem"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testReadOrder"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testNamedQueryOnCustomer"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testNamedQueryOnItem"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testNamedQueryOnOrder"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testUpdateCustomer"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testUpdateItem"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testUpdateOrder"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testDeleteOrder"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testDeleteCustomer"));
        suite.addTest((Test)new EntityMappingsMergeRelationshipsJUnitTestCase("testDeleteItem"));
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession();
        new RelationshipsTableManager().replaceTables((DatabaseSession)session);
        this.clearCache();
    }

    public void testCustomerOrdersMapping() {
        ServerSession session = JUnitTestCase.getServerSession();
        ClassDescriptor descriptor = session.getDescriptor(Customer.class);
        ForeignReferenceMapping mapping = (ForeignReferenceMapping)descriptor.getMappingForAttributeName("orders");
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Orders mapping on Customer is not set to cascade persist.", (boolean)mapping.isCascadePersist());
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Orders mapping on Customer is not set to cascade remove.", (boolean)mapping.isCascadeRemove());
        EntityMappingsMergeRelationshipsJUnitTestCase.assertFalse((String)"Orders mapping on Customer is set to cascade refresh.", (boolean)mapping.isCascadeRefresh());
        EntityMappingsMergeRelationshipsJUnitTestCase.assertFalse((String)"Orders mapping on Customer is set to cascade merge.", (boolean)mapping.isCascadeMerge());
        EntityMappingsMergeRelationshipsJUnitTestCase.assertFalse((String)"Orders mapping on Customer is set to private owned.", (boolean)mapping.isPrivateOwned());
    }

    public void testOrderCustomerMapping() {
        ServerSession session = JUnitTestCase.getServerSession();
        ClassDescriptor descriptor = session.getDescriptor(Order.class);
        ForeignReferenceMapping mapping = (ForeignReferenceMapping)descriptor.getMappingForAttributeName("customer");
        if (this.isWeavingEnabled()) {
            EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Customer mapping on Order is not set to LAZY loading.", (boolean)mapping.usesIndirection());
        }
    }

    public void testItemNameMapping() {
        ServerSession session = JUnitTestCase.getServerSession();
        ClassDescriptor descriptor = session.getDescriptor(Item.class);
        DirectToFieldMapping mapping = (DirectToFieldMapping)descriptor.getMappingForAttributeName("name");
        EntityMappingsMergeRelationshipsJUnitTestCase.assertFalse((String)"Customer mapping on Order is not set to LAZY loading.", (boolean)mapping.isMutable());
    }

    public void testCreateCustomer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Customer customer = new Customer();
            customer.setName("Joe Black");
            customer.setCity("Austin");
            em.persist((Object)customer);
            customerId = customer.getCustomerId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testCreateItem() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            PartsList pl = new PartsList();
            em.persist((Object)pl);
            PartsList pl2 = new PartsList();
            em.persist((Object)pl2);
            ArrayList<PartsList> partsLists = new ArrayList<PartsList>();
            partsLists.add(pl);
            partsLists.add(pl2);
            Item item = new Item();
            item.name = "PartA";
            item.setDescription("This is part of a widget.");
            item.setImage(new byte[1024]);
            item.setPartsLists(partsLists);
            em.persist((Object)item);
            itemId = item.getItemId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testCreateOrder() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Order order = new Order();
            order.setShippingAddress("50 O'Connor St.");
            Customer customer = (Customer)em.find(Customer.class, (Object)customerId);
            order.setCustomer(customer);
            order.setQuantity(1);
            Item item = (Item)em.find(Item.class, (Object)itemId);
            order.setItem(item);
            em.persist((Object)order);
            orderId = order.getOrderId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testDeleteCustomer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.remove(em.find(Customer.class, (Object)customerId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Error deleting Customer", (em.find(Customer.class, (Object)customerId) == null ? 1 : 0) != 0);
    }

    public void testDeleteItem() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.remove(em.find(Item.class, (Object)itemId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Error deleting Item", (em.find(Item.class, (Object)itemId) == null ? 1 : 0) != 0);
    }

    public void testDeleteOrder() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.remove(em.find(Order.class, (Object)orderId));
            em.refresh(em.find(Customer.class, (Object)customerId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Error deleting Order", (em.find(Order.class, (Object)orderId) == null ? 1 : 0) != 0);
    }

    public void testNamedQueryOnCustomer() {
        Customer customer = (Customer)this.createEntityManager().createNamedQuery("findAllXMLMergeCustomers").getSingleResult();
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Error executing named query 'findAllXMLMergeCustomers'", (customer != null ? 1 : 0) != 0);
    }

    public void testNamedQueryOnOrder() {
        Query query = this.createEntityManager().createNamedQuery("findAllXMLMergeOrdersByItem");
        query.setParameter("id", (Object)itemId);
        Order order = (Order)query.getSingleResult();
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Error executing named query 'findAllXMLMergeOrdersByItem'", (order != null ? 1 : 0) != 0);
    }

    public void testNamedQueryOnItem() {
        Query query = this.createEntityManager().createNamedQuery("findAllXMLMergeItemsByName");
        query.setParameter("1", (Object)"PartA");
        Item item = (Item)query.getSingleResult();
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Error executing named query 'findAllXMLMergeItemsByName'", (item != null ? 1 : 0) != 0);
    }

    public void testReadCustomer() {
        Customer customer = (Customer)this.createEntityManager().find(Customer.class, (Object)customerId);
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Error reading Customer", (customer.getCustomerId() == customerId ? 1 : 0) != 0);
    }

    public void testReadItem() {
        Item item = (Item)this.createEntityManager().find(Item.class, (Object)itemId);
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Error reading Item", (item.getItemId() == itemId ? 1 : 0) != 0);
    }

    public void testReadOrder() {
        Order order = (Order)this.createEntityManager().find(Order.class, (Object)orderId);
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Error reading Order", (order.getOrderId() == orderId ? 1 : 0) != 0);
    }

    public void testUpdateCustomer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Customer customer = (Customer)em.find(Customer.class, (Object)customerId);
            customer.setCity("Dallas");
            em.merge((Object)customer);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em.clear();
        Customer newCustomer = (Customer)em.find(Customer.class, (Object)customerId);
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Error updating Customer", (boolean)newCustomer.getCity().equals("Dallas"));
    }

    public void testUpdateItem() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            PartsList pl = new PartsList();
            em.persist((Object)pl);
            ArrayList<PartsList> partsLists = new ArrayList<PartsList>();
            partsLists.add(pl);
            Item item = (Item)em.find(Item.class, (Object)itemId);
            item.setDescription("A Widget");
            item.setImage(new byte[1280]);
            item.setPartsLists(partsLists);
            em.merge((Object)item);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em.clear();
        Item newItem = (Item)em.find(Item.class, (Object)itemId);
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Error updating Item description", (boolean)newItem.getDescription().equals("A Widget"));
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Error updating Item image", (newItem.getImage().length == 1280 ? 1 : 0) != 0);
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Error updating Item parts lists", (newItem.getPartsLists().size() != 1 ? 1 : 0) != 0);
    }

    public void testUpdateOrder() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Customer customer = (Customer)em.find(Customer.class, (Object)customerId);
            Order order = (Order)customer.getOrders().iterator().next();
            order.setQuantity(100);
            em.merge((Object)customer);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em.clear();
        Customer newCustomer = (Customer)em.find(Customer.class, (Object)customerId);
        EntityMappingsMergeRelationshipsJUnitTestCase.assertTrue((String)"Error updating Customer", (((Order)newCustomer.getOrders().iterator().next()).getQuantity() == 100 ? 1 : 0) != 0);
    }
}

