/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance;

import jakarta.persistence.EntityManager;
import jakarta.persistence.spi.PersistenceProvider;
import java.util.HashMap;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.models.jpa.performance.EmployeeTableCreator;
import org.eclipse.persistence.testing.tests.jpa.performance.JPAPerformanceRegressionModel;

public class OpenJPAPerformanceRegressionModel
extends JPAPerformanceRegressionModel {
    public OpenJPAPerformanceRegressionModel() {
        this.setDescription("Performance tests that compares OpenJPA JPA performance.");
    }

    @Override
    public void setupProvider() {
        String providerClass = "org.apache.openjpa.persistence.PersistenceProviderImpl";
        PersistenceProvider provider = null;
        try {
            provider = (PersistenceProvider)Class.forName(providerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception error) {
            throw new TestProblemException("Failed to create persistence provider.", (Throwable)error);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("openjpa.ConnectionDriverName", this.getSession().getLogin().getDriverClassName());
        properties.put("openjpa.ConnectionURL", this.getSession().getLogin().getConnectionString());
        properties.put("openjpa.ConnectionUserName", this.getSession().getLogin().getUserName());
        properties.put("openjpa.ConnectionPassword", this.getSession().getLogin().getPassword());
        if (this.getSession().shouldLogMessages()) {
            properties.put("openjpa.Log", "DefaultLevel=WARN,SQL=TRACE");
        }
        this.getExecutor().setEntityManagerFactory(provider.createEntityManagerFactory("performance", properties));
    }

    @Override
    public void setupDatabase(EntityManager manager) {
        super.setupDatabase(manager);
        new EmployeeTableCreator().dropConstraints(this.getDatabaseSession());
    }
}

