/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.clientserver.Client2;
import org.eclipse.persistence.testing.tests.clientserver.PolicyClientNonLock;
import org.eclipse.persistence.testing.tests.clientserver.PolicyHolderClient;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class ClientServerReadingNonDeadlockTest
extends TestCase {
    protected DatabaseLogin login;
    protected Client2[] policyClients = new PolicyClientNonLock[300];
    protected Client2[] policyHolderClients = new PolicyHolderClient[300];
    protected Server server;
    private static final int CLIENT_NUM = 300;

    public ClientServerReadingNonDeadlockTest() {
        this.setDescription("The test simulates the deadlock situation when reading the bidirectional objects among multi-thread");
    }

    public void reset() {
        block4: {
            try {
                for (int index2 = 0; index2 < 300; ++index2) {
                    this.policyHolderClients[index2].release();
                }
                for (int index = 0; index < 300; ++index) {
                    this.policyClients[index].release();
                }
                this.server.logout();
                this.getDatabaseSession().logout();
                this.getDatabaseSession().login();
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block4;
                this.verify();
            }
        }
    }

    public void setup() {
        block3: {
            try {
                this.login = (DatabaseLogin)this.getSession().getLogin().clone();
                this.server = new Server(this.login);
                this.server.serverSession.setSessionLog(this.getSession().getSessionLog());
                this.server.login();
                this.server.copyDescriptors(this.getSession());
                for (int index = 0; index < 300; ++index) {
                    this.policyClients[index] = new PolicyClientNonLock(this.server, this.getSession(), "PolicyClientNonLock" + index);
                    this.policyHolderClients[index] = new PolicyHolderClient(this.server, this.getSession(), "PolicyHolderClient" + index);
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block3;
                this.verify();
            }
        }
    }

    public void test() {
        block6: {
            try {
                int index;
                for (index = 0; index < 300; ++index) {
                    this.policyClients[index].start();
                    this.policyHolderClients[index].start();
                }
                try {
                    for (index = 0; index < 300; ++index) {
                        this.policyClients[index].join();
                        this.policyHolderClients[index].join();
                    }
                }
                catch (InterruptedException exception) {
                    TestErrorException testException = new TestErrorException("Client threads are interrupted");
                    testException.setInternalException((Throwable)exception);
                    throw testException;
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block6;
                this.verify();
            }
        }
    }

    public void verify() {
        block3: {
            try {
                if (this.server.errorOccured) {
                    throw new TestErrorException("An error occurred on one of the clients, check System.out.");
                }
            }
            catch (Exception ex) {
                if (ex instanceof ValidationException && ((ValidationException)((Object)ex)).getErrorCode() == 7090) break block3;
                throw new TestErrorException("Error: ", (Throwable)ex);
            }
        }
    }
}

